/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.registry.comparison;

import de.syranda.spidermysql.customclasses.registry.TableInformation;
import de.syranda.spidermysql.customclasses.registry.TableRegistry;
import de.syranda.spidermysql.customclasses.registry.comparison.FieldComparison;
import de.syranda.spidermysql.customclasses.registry.comparison.ForeignKeyComparison;
import de.syranda.spidermysql.customclasses.registry.comparison.KeyComparison;

public class ComparisonInformation {
    private FieldComparison fieldComparison;
    private KeyComparison keyComparison;
    private ForeignKeyComparison foreignKeyComparison;

    public ComparisonInformation(String tableName, String database) {
        TableInformation ram = TableRegistry.getRamTable(tableName, database);
        TableInformation data = TableRegistry.getDatabaseTable(tableName, database);
        this.fieldComparison = new FieldComparison(ram, data);
        this.keyComparison = new KeyComparison(ram, data);
        this.foreignKeyComparison = new ForeignKeyComparison(ram, data);
    }

    public FieldComparison getFieldComparison() {
        return this.fieldComparison;
    }

    public KeyComparison getKeyComparison() {
        return this.keyComparison;
    }

    public ForeignKeyComparison getForeignKeyComparison() {
        return this.foreignKeyComparison;
    }

    public boolean hasDifferences() {
        return this.fieldComparison.hasDifferences() || this.keyComparison.hasDifferences() || this.foreignKeyComparison.hasDifferences();
    }
}

