/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.registry;

import de.syranda.spidermysql.customclasses.builder.TableBuilder;
import de.syranda.spidermysql.customclasses.registry.TableInformation;
import de.syranda.spidermysql.customclasses.registry.comparison.ComparisonInformation;
import de.syranda.spidermysql.customclasses.table.TableClass;
import de.syranda.spidermysql.utils.ConfigValues;
import java.util.ArrayList;
import java.util.List;

public class TableRegistry {
    private static List<TableInformation> ramList = new ArrayList<TableInformation>();
    private static List<TableInformation> databaseList = new ArrayList<TableInformation>();

    public static void registerTable(TableBuilder builder) {
        if (TableRegistry.getRamTable(builder.getTableName(), builder.getDatabase()) != null) {
            return;
        }
        if (!ConfigValues.ENABLE_TABLE_REGISTRY) {
            System.err.println("[SpiderMySQL] Something tried to register the table '" + builder.getTableName() + "' on database '" + builder.getDatabase() + "' even tho the registry is disabled");
            return;
        }
        System.out.println("[SpiderMySQL] Registering table '" + builder.getTableName() + "' on database '" + builder.getDatabase() + "'");
        ramList.add(new TableInformation().load(builder));
        databaseList.add(new TableInformation().load(builder.getTableName(), builder.getDatabase()));
    }

    public static TableInformation getRamTable(String name, String database) {
        for (TableInformation ti : ramList) {
            if (!ti.getTableName().equals(name) || !ti.getDatabase().equals(database)) continue;
            return ti;
        }
        return null;
    }

    public static TableInformation getDatabaseTable(String name, String database) {
        for (TableInformation ti : databaseList) {
            if (!ti.getTableName().equals(name) || !ti.getDatabase().equals(database)) continue;
            return ti;
        }
        return null;
    }

    public static TableInformation getRamTable(TableClass table) {
        return TableRegistry.getRamTable(table.getTableName(), table.getDatabase());
    }

    public static TableInformation getDatabaseTable(TableClass table) {
        return TableRegistry.getDatabaseTable(table.getTableName(), table.getDatabase());
    }

    public static ComparisonInformation compareTable(String tableName, String database) {
        if (!ConfigValues.ENABLE_TABLE_REGISTRY) {
            System.err.println("[SpiderMySQL] Cannot compare tables. Table registry is not enabled");
            return null;
        }
        return new ComparisonInformation(tableName, database);
    }

    public static ComparisonInformation compareTable(TableClass table) {
        return TableRegistry.compareTable(table.getTableName(), table.getDatabase());
    }

    public static List<TableInformation> getRegisteredRamTables() {
        return ramList;
    }

    public static List<TableInformation> getRegisteredDatabaseTables() {
        return databaseList;
    }

    public static boolean isRegistered(String table, String database) {
        return TableRegistry.getRamTable(table, database) != null;
    }

    public static boolean isRegistered(String table) {
        return TableRegistry.isRegistered(table, ConfigValues.MYSQL_DATABASE);
    }
}

