/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.registry;

import de.syranda.spidermysql.customclasses.builder.ForeignKey;
import de.syranda.spidermysql.customclasses.builder.ForeignKeyAction;
import de.syranda.spidermysql.customclasses.builder.Key;
import de.syranda.spidermysql.customclasses.builder.KeyType;
import de.syranda.spidermysql.customclasses.builder.TableBuilder;
import de.syranda.spidermysql.customclasses.table.MySQLField;
import de.syranda.spidermysql.customclasses.table.RecordResult;
import de.syranda.spidermysql.customclasses.table.TableClass;
import de.syranda.spidermysql.utils.ConfigValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class TableInformation {
    private String tableName;
    private String database;
    private List<MySQLField> fieldList = new ArrayList<MySQLField>();
    private List<Key> keyList = new ArrayList<Key>();
    private List<ForeignKey> foreignKeyList = new ArrayList<ForeignKey>();

    public TableInformation load(TableBuilder builder) {
        this.tableName = builder.getTableName();
        this.database = builder.getDatabase();
        this.fieldList.clear();
        this.keyList.clear();
        this.foreignKeyList.clear();
        for (MySQLField field : builder.getFields()) {
            this.fieldList.add(field);
        }
        for (Key key : builder.getKeys()) {
            Arrays.sort(key.getColumns());
            this.keyList.add(key);
        }
        for (ForeignKey fKey : builder.getForeignKeys()) {
            Arrays.sort(fKey.getReferenceColumns());
            Arrays.sort(fKey.getTargetColumns());
            this.foreignKeyList.add(fKey);
        }
        return this;
    }

    public TableInformation load(String tableName) {
        return this.load(tableName, ConfigValues.MYSQL_DATABASE);
    }

    public TableInformation load(String tableName, String database) {
        this.tableName = tableName;
        this.database = database;
        this.fieldList.clear();
        this.keyList.clear();
        this.foreignKeyList.clear();
        RecordResult fields = this.getTableClass().describe();
        while (fields.next()) {
            String type = fields.getCurrentString("Type");
            int length = 0;
            if (type.contains("(")) {
                length = Integer.parseInt(type.split("\\(")[1].split("\\)")[0]);
                type = type.split("\\(")[0];
            }
            MySQLField field = new MySQLField(fields.getCurrentString("Field"), type);
            if (length != 0) {
                field.setLength(length);
            }
            field.setAllowNull(fields.getCurrentString("Null").equals("YES"));
            if (fields.getCurrentString("Extra").contains("auto_increment")) {
                field.setAutoIncrement(true);
            }
            field.setDefaultValue(fields.getCurrentObject("Default"));
            this.fieldList.add(field);
        }
        RecordResult keys = this.getTableClass().showKeys();
        HashMap<String, Key> addKeys = new HashMap<String, Key>();
        HashMap<String, ForeignKey> addForeignKeys = new HashMap<String, ForeignKey>();
        while (keys.next()) {
            Key key;
            String keyName = keys.getCurrentString("CONSTRAINT_NAME");
            if (keys.getCurrentObject("REFERENCED_TABLE_NAME") != null) {
                ForeignKey fKey = null;
                if (addForeignKeys.containsKey(keyName)) {
                    fKey = (ForeignKey)addForeignKeys.get(keyName);
                    String[] ref = Arrays.copyOf(fKey.getReferenceColumns(), fKey.getReferenceColumns().length + 1);
                    ref[ref.length - 1] = keys.getCurrentString("REFERENCED_COLUMN_NAME");
                    fKey.setReferenceColumns(ref);
                    String[] tar = Arrays.copyOf(fKey.getTargetColumns(), fKey.getTargetColumns().length + 1);
                    tar[tar.length - 1] = keys.getCurrentString("COLUMN_NAME");
                    fKey.setTargetColumns(tar);
                } else {
                    fKey = new ForeignKey(keyName, keys.getCurrentString("REFERENCED_TABLE_NAME"), ForeignKeyAction.valueOf(keys.getCurrentString("UPDATE_RULE").replace(" ", "_")), ForeignKeyAction.valueOf(keys.getCurrentString("DELETE_RULE").replace(" ", "_"))).setReferenceColumns(keys.getCurrentString("REFERENCED_COLUMN_NAME")).setTargetColumns(keys.getCurrentString("COLUMN_NAME"));
                }
                addForeignKeys.put(keyName, fKey);
                continue;
            }
            if (addKeys.containsKey(keyName)) {
                key = (Key)addKeys.get(keyName);
                String[] col = Arrays.copyOf(key.getColumns(), key.getColumns().length + 1);
                col[col.length - 1] = keys.getCurrentString("COLUMN_NAME");
                key.setColoumns(col);
            } else {
                key = keyName.equals("PRIMARY") ? new Key("", KeyType.PRIMARY, keys.getCurrentString("COLUMN_NAME")) : new Key(keyName, KeyType.UNIQUE, keys.getCurrentString("COLUMN_NAME"));
            }
            addKeys.put(keyName, key);
        }
        for (ForeignKey fKey : addForeignKeys.values()) {
            Arrays.sort(fKey.getReferenceColumns());
            Arrays.sort(fKey.getTargetColumns());
            this.foreignKeyList.add(fKey);
        }
        for (Key key : addKeys.values()) {
            Arrays.sort(key.getColumns());
            this.keyList.add(key);
        }
        return this;
    }

    public TableClass getTableClass() {
        return new TableClass(this.tableName, this.database);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabase() {
        return this.database;
    }

    public List<MySQLField> getFieldList() {
        return this.fieldList;
    }

    public List<ForeignKey> getForeignKeyList() {
        return this.foreignKeyList;
    }

    public List<Key> getKeyList() {
        return this.keyList;
    }

    public MySQLField getMySQLField(String fieldName) {
        for (MySQLField field : this.fieldList) {
            if (!field.getFieldName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public Key getKey(String keyName) {
        for (Key key : this.keyList) {
            if (!key.getKeyName().equals(keyName)) continue;
            return key;
        }
        if (keyName.equals("")) {
            ArrayList<String> columns = new ArrayList<String>();
            for (MySQLField field : this.fieldList) {
                if (!field.isPrimaryKey()) continue;
                columns.add(field.getFieldName());
            }
            if (!columns.isEmpty()) {
                return new Key("", KeyType.PRIMARY, columns.toArray(new String[columns.size()]));
            }
        }
        return null;
    }

    public Key getPrimaryKey() {
        return this.getKey("");
    }

    public ForeignKey getForeignKey(String foreignKeyName) {
        for (ForeignKey fKey : this.foreignKeyList) {
            if (!fKey.getKeyName().equals(foreignKeyName)) continue;
            return fKey;
        }
        return null;
    }

    public void rebuild() {
        new TableBuilder(this).build();
    }
}

