/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.helper;

import de.syranda.spidermysql.customclasses.table.ClassSerializer;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DefaultClassSerializers {
    public static void loadDefaultClassSerializers() {
        ClassSerializer.addClassSerializer(JSONObject.class, new ClassSerializer<JSONObject>(){

            @Override
            public HashMap<String, Object> serialize(String fieldName, JSONObject object) {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put(fieldName, object.toJSONString());
                return ret;
            }

            @Override
            public HashMap<String, Class<?>> getPattern(String fieldName) {
                HashMap ret = new HashMap();
                ret.put(fieldName, String.class);
                return ret;
            }

            @Override
            public JSONObject deserialize(String fieldName, HashMap<String, Object> columns) {
                try {
                    return (JSONObject)new JSONParser().parse(columns.get(fieldName).toString());
                }
                catch (ParseException e) {
                    return null;
                }
            }
        });
    }
}

