/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.event;

import de.syranda.spidermysql.customclasses.event.Interval;
import de.syranda.spidermysql.customclasses.event.Schedule;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimestampSchedule
implements Schedule {
    private String scheduleString;

    public TimestampSchedule(long timestamp) {
        this.scheduleString = "'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timestamp)) + "'";
    }

    public TimestampSchedule() {
        this.scheduleString = "'" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(System.currentTimeMillis())) + "'";
    }

    public TimestampSchedule addInterval(int quantity, Interval interval) {
        this.scheduleString = String.valueOf(this.scheduleString) + " + INTERVAL " + quantity + " " + interval.name();
        return this;
    }

    public TimestampSchedule addInterval(String quantity, Interval interval) {
        this.scheduleString = String.valueOf(this.scheduleString) + " + INTERVAL '" + quantity + "' " + interval.name();
        return this;
    }

    @Override
    public String getScheduleString() {
        return "AT " + this.scheduleString;
    }

    @Override
    public String getIntervalString() {
        return this.scheduleString;
    }
}

