/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.event;

import de.syranda.spidermysql.customclasses.ConnectionManager;
import de.syranda.spidermysql.customclasses.event.Schedule;

public class EventBuilder {
    private String name;
    private Schedule schedule;
    private String task = "";
    private boolean preserve = true;
    private boolean enabled = true;

    public EventBuilder(String name) {
        this.name = name;
    }

    public EventBuilder setSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public EventBuilder addStatement(String statement) {
        this.task = String.valueOf(this.task) + statement + ";";
        return this;
    }

    public EventBuilder setPreserve(boolean preserve) {
        this.preserve = preserve;
        return this;
    }

    public EventBuilder setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void build() {
        String query = "CREATE EVENT IF NOT EXISTS `" + this.name + "`" + " ON SCHEDULE " + this.schedule.getScheduleString() + " ON COMPLETION" + (this.preserve ? "" : " NOT") + " PRESERVE " + (this.enabled ? "ENABLE" : "DISABLE") + " DO BEGIN " + this.task + " END";
        ConnectionManager.insertStatement(query, true);
    }
}

