/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.builder;

import com.mysql.jdbc.Connection;
import de.syranda.spidermysql.customclasses.ConnectionManager;
import de.syranda.spidermysql.customclasses.ConventionFormatter;
import de.syranda.spidermysql.customclasses.builder.ColumnType;
import de.syranda.spidermysql.customclasses.builder.Exclude;
import de.syranda.spidermysql.customclasses.builder.ExcludeField;
import de.syranda.spidermysql.customclasses.builder.ForeignKey;
import de.syranda.spidermysql.customclasses.builder.Key;
import de.syranda.spidermysql.customclasses.builder.KeyType;
import de.syranda.spidermysql.customclasses.builder.MySQLClass;
import de.syranda.spidermysql.customclasses.builder.MySQLField;
import de.syranda.spidermysql.customclasses.builder.Primary;
import de.syranda.spidermysql.customclasses.builder.Unique;
import de.syranda.spidermysql.customclasses.registry.TableInformation;
import de.syranda.spidermysql.customclasses.registry.TableRegistry;
import de.syranda.spidermysql.customclasses.syntax.MySQLTableSyntax;
import de.syranda.spidermysql.customclasses.table.ClassSerializer;
import de.syranda.spidermysql.customclasses.trigger.Trigger;
import de.syranda.spidermysql.customclasses.trigger.TriggerEvent;
import de.syranda.spidermysql.customclasses.trigger.TriggerTime;
import de.syranda.spidermysql.utils.ConfigValues;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableBuilder {
    private String tableName;
    private String database;
    private List<de.syranda.spidermysql.customclasses.table.MySQLField> fields = new ArrayList<de.syranda.spidermysql.customclasses.table.MySQLField>();
    private List<Key> keys = new ArrayList<Key>();
    private List<ForeignKey> fKeys = new ArrayList<ForeignKey>();

    public TableBuilder(String tableName) {
        this.tableName = tableName;
        this.database = ConfigValues.MYSQL_DATABASE;
    }

    public TableBuilder(String tableName, String database) {
        this.tableName = tableName;
        this.database = database;
    }

    public TableBuilder(TableInformation information) {
        this.tableName = information.getTableName();
        this.database = information.getDatabase();
        this.fields = information.getFieldList();
        this.keys = information.getKeyList();
        this.fKeys = information.getForeignKeyList();
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableBuilder addField(de.syranda.spidermysql.customclasses.table.MySQLField field) {
        this.fields.add(field);
        return this;
    }

    public TableBuilder addField(String fieldName, Class<?> field, String[] exclude) {
        ClassSerializer<?> serializer = ClassSerializer.getSerializer(field);
        TableBuilder ret = this;
        for (Map.Entry<String, Class<?>> entry : serializer.getPattern(fieldName).entrySet()) {
            boolean con = true;
            if (exclude != null) {
                String[] stringArray = exclude;
                int n = exclude.length;
                int n2 = 0;
                while (n2 < n) {
                    String exField = stringArray[n2];
                    if (entry.getKey().equals(exField)) {
                        con = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (!con) continue;
            ret = ClassSerializer.hasSerializer(entry.getValue()) ? this.addField(fieldName, entry.getValue(), exclude) : this.addField(new de.syranda.spidermysql.customclasses.table.MySQLField(entry.getKey(), ColumnType.getType(entry.getValue())));
        }
        return ret;
    }

    public TableBuilder addForeignKey(ForeignKey key) {
        this.fKeys.add(key);
        return this;
    }

    public TableBuilder addKey(Key key) {
        this.keys.add(key);
        return this;
    }

    public TableBuilder addFieldsOfClass(Class<?> clazz) {
        HashMap<String, List<String>> keys = new HashMap<String, List<String>>();
        boolean adjust = clazz.isAnnotationPresent(MySQLClass.class) ? clazz.getAnnotation(MySQLClass.class).adjustFields() : false;
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.isAnnotationPresent(MySQLField.class) || clazz.isAnnotationPresent(MySQLClass.class)) && !field.isAnnotationPresent(Exclude.class) && !Modifier.isStatic(field.getModifiers())) {
                MySQLField ann = field.getAnnotation(MySQLField.class);
                if (ClassSerializer.hasSerializer(field.getType())) {
                    this.addField(adjust ? ConventionFormatter.getMySQLName(field.getName()) : field.getName(), field.getType(), field.isAnnotationPresent(ExcludeField.class) ? field.getAnnotation(ExcludeField.class).fields() : null);
                } else {
                    ColumnType type = ColumnType.getType(field.getType());
                    de.syranda.spidermysql.customclasses.table.MySQLField mField = new de.syranda.spidermysql.customclasses.table.MySQLField(adjust ? ConventionFormatter.getMySQLName(field.getName()) : field.getName(), type);
                    mField.setLength(type.getDefaultLength());
                    if (ann != null) {
                        if (ann.type() != ColumnType.NONE) {
                            mField.setType(ann.type());
                        }
                        if (ann.length() != 0) {
                            mField.setLength(ann.length());
                        }
                        mField.setAllowNull(!ann.notNull());
                        mField.setAutoIncrement(ann.autoIncrement());
                        mField.setPrimaryKey(ann.isPrimaryKey());
                    }
                    if (!mField.getType().equalsIgnoreCase("none")) {
                        ArrayList<String> list;
                        if (field.isAnnotationPresent(Primary.class)) {
                            if (!keys.containsKey("primary")) {
                                keys.put("primary", Arrays.asList(field.getName()));
                            } else {
                                list = (ArrayList<String>)keys.get("primary");
                                list.add(field.getName());
                                keys.put("primary", list);
                            }
                        }
                        if (field.isAnnotationPresent(Unique.class)) {
                            list = !keys.containsKey(field.getAnnotation(Unique.class).name()) ? new ArrayList<String>() : (List)keys.get(field.getAnnotation(Unique.class).name());
                            list.add(field.getName());
                            keys.put(field.getAnnotation(Unique.class).name(), list);
                        }
                        this.addField(mField);
                    }
                }
            }
            ++n2;
        }
        for (String key : keys.keySet()) {
            String[] fields = new String[((List)keys.get(key)).size()];
            int i = 0;
            while (i < fields.length) {
                fields[i] = (String)((List)keys.get(key)).get(i);
                ++i;
            }
            if (key.equals("primary")) {
                this.addKey(new Key("", KeyType.PRIMARY, fields));
                continue;
            }
            this.addKey(new Key(key, KeyType.UNIQUE, fields));
        }
        return this;
    }

    public void build() {
        String query = "CREATE TABLE IF NOT EXISTS " + this.getTarget() + " (";
        int i = 0;
        while (i < this.fields.size()) {
            de.syranda.spidermysql.customclasses.table.MySQLField field = this.fields.get(i);
            if (i != 0) {
                query = String.valueOf(query) + ", ";
            }
            query = String.valueOf(query) + "`" + field.getFieldName() + "` " + field.getType() + (field.getLength() != 0 ? "(" + field.getLength() + ")" : "");
            if (!field.allowNull()) {
                query = String.valueOf(query) + " NOT NULL";
            }
            if (field.getDefaultValue() != null) {
                try {
                    int defaultValue = Integer.parseInt(field.getDefaultValue().toString());
                    query = String.valueOf(query) + " DEFAULT " + defaultValue;
                }
                catch (Exception e) {
                    query = String.valueOf(query) + " DEFAULT '" + field.getDefaultValue().toString() + "'";
                }
            }
            if (field.isAutoIncrement()) {
                query = String.valueOf(query) + " AUTO_INCREMENT";
            }
            if (field.isPrimaryKey()) {
                query = String.valueOf(query) + " PRIMARY KEY";
            }
            ++i;
        }
        if (!this.keys.isEmpty()) {
            for (Key key : this.keys) {
                String keys = "";
                int i2 = 0;
                while (i2 < key.getColumns().length) {
                    keys = String.valueOf(keys) + (i2 == 0 ? "`" + key.getColumns()[i2] + "`" : ", `" + key.getColumns()[i2] + "`");
                    ++i2;
                }
                switch (key.getKeyType()) {
                    case PRIMARY: {
                        query = String.valueOf(query) + ", PRIMARY KEY (" + keys + ")";
                        break;
                    }
                    case UNIQUE: {
                        query = String.valueOf(query) + ", UNIQUE KEY `" + key.getKeyName() + "` (" + keys + ")";
                        break;
                    }
                }
            }
        }
        if (!this.fKeys.isEmpty()) {
            query = String.valueOf(query) + ", ";
            i = 0;
            while (i < this.fKeys.size()) {
                ForeignKey key = this.fKeys.get(i);
                if (i != 0) {
                    query = String.valueOf(query) + ", ";
                }
                String targetC = "";
                int ii = 0;
                while (ii < key.getTargetColumns().length) {
                    targetC = String.valueOf(targetC) + (ii == 0 ? "`" + key.getTargetColumns()[ii] + "`" : ", `" + key.getTargetColumns()[ii] + "`");
                    ++ii;
                }
                String referenceC = "";
                int ii2 = 0;
                while (ii2 < key.getReferenceColumns().length) {
                    referenceC = String.valueOf(referenceC) + (ii2 == 0 ? "`" + key.getReferenceColumns()[ii2] + "`" : ", `" + key.getReferenceColumns()[ii2] + "`");
                    ++ii2;
                }
                query = String.valueOf(query) + "CONSTRAINT `" + key.getKeyName() + "` FOREIGN KEY (" + targetC + ") REFERENCES `" + key.getRefrenceTable() + "` (" + referenceC + ") ON DELETE " + key.getOnDelete().getAction() + " ON UPDATE " + key.getOnUpdate().getAction();
                ++i;
            }
        }
        query = String.valueOf(query) + ") ENGINE=InnoDB";
        ConnectionManager.insertStatement(query, true);
        for (Map.Entry<String, Connection> connection : ConnectionManager.getBackupConnections().entrySet()) {
            String insertQuery = "";
            String updateQueryWhat = "";
            String updateQueryWhere = "";
            String deleteQuery = "";
            int i3 = 0;
            while (i3 < this.fields.size()) {
                de.syranda.spidermysql.customclasses.table.MySQLField field = this.fields.get(i3);
                insertQuery = String.valueOf(insertQuery) + (i3 == 0 ? String.valueOf(field.getFieldName()) + ":NEW." + field.getFieldName() : ";" + field.getFieldName() + ":NEW." + field.getFieldName());
                updateQueryWhat = String.valueOf(updateQueryWhat) + (i3 == 0 ? String.valueOf(field.getFieldName()) + ":NEW." + field.getFieldName() : ";" + field.getFieldName() + ":NEW." + field.getFieldName());
                updateQueryWhere = String.valueOf(updateQueryWhere) + (i3 == 0 ? String.valueOf(field.getFieldName()) + ":OLD." + field.getFieldName() : ";" + field.getFieldName() + ":OLD." + field.getFieldName());
                deleteQuery = String.valueOf(deleteQuery) + (i3 == 0 ? String.valueOf(field.getFieldName()) + ":OLD." + field.getFieldName() : ";" + field.getFieldName() + ":OLD." + field.getFieldName());
                ++i3;
            }
            Trigger insertTrigger = new Trigger(String.valueOf(connection.getKey()) + "_" + this.tableName + "_insert");
            insertTrigger.builder(this.tableName, TriggerTime.AFTER, TriggerEvent.INSERT).addStatement(new MySQLTableSyntax(this.tableName, connection.getKey()).insert(insertQuery)).build();
            Trigger updateTrigger = new Trigger(String.valueOf(connection.getKey()) + "_" + this.tableName + "_update");
            updateTrigger.builder(this.tableName, TriggerTime.AFTER, TriggerEvent.UPDATE).addStatement(new MySQLTableSyntax(this.tableName, connection.getKey()).update(updateQueryWhat, updateQueryWhere)).build();
            Trigger deleteTrigger = new Trigger(String.valueOf(connection.getKey()) + "_" + this.tableName + "_delete");
            deleteTrigger.builder(this.tableName, TriggerTime.AFTER, TriggerEvent.DELETE).addStatement(new MySQLTableSyntax(this.tableName, connection.getKey()).delete(deleteQuery)).build();
        }
        if (ConfigValues.ENABLE_TABLE_REGISTRY) {
            TableRegistry.registerTable(this);
        }
    }

    public String getTarget() {
        return "`" + this.database + "`.`" + this.tableName + "`";
    }

    public String getDatabase() {
        return this.database;
    }

    public List<de.syranda.spidermysql.customclasses.table.MySQLField> getFields() {
        return this.fields;
    }

    public List<Key> getKeys() {
        return this.keys;
    }

    public List<ForeignKey> getForeignKeys() {
        return this.fKeys;
    }
}

