/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.customclasses.builder;

import java.io.Serializable;

public enum ColumnType {
    INT("int", 11),
    LONG("bigint", 20),
    SHORT("smallint", 6),
    DOUBLE("double", 0),
    STRING("varchar", 50),
    BOOLEAN("tinyint", 4),
    NONE("NONE", 0),
    TEXT("text", 0);

    private String stringType;
    private int defaultLength;

    private ColumnType(String stringType, int defaultLength) {
        this.stringType = stringType;
        this.defaultLength = defaultLength;
    }

    public String getTypeName() {
        return this.stringType;
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    public static ColumnType getType(Class<?> field) {
        switch (field.getSimpleName()) {
            case "int": {
                return INT;
            }
            case "long": {
                return LONG;
            }
            case "short": {
                return SHORT;
            }
            case "float": {
                return DOUBLE;
            }
            case "double": {
                return DOUBLE;
            }
            case "String": {
                return STRING;
            }
            case "boolean": {
                return BOOLEAN;
            }
            case "text": {
                return TEXT;
            }
        }
        if (Serializable.class.isAssignableFrom(field)) {
            return TEXT;
        }
        return null;
    }
}

