/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.bukkit.config;

import de.syranda.spidermysql.bukkit.Main;
import de.syranda.spidermysql.utils.ConfigValues;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private static File configFile;
    private static FileConfiguration config;

    public static boolean loadConfig(Main c) {
        configFile = new File(c.getDataFolder(), "//config.yml");
        config = YamlConfiguration.loadConfiguration((File)configFile);
        config.addDefault("Config.LogQuery", (Object)false);
        config.addDefault("Config.EnableTableRegistry", (Object)false);
        config.addDefault("MySQL.MainConnection.Host", (Object)"127.0.0.1");
        config.addDefault("MySQL.MainConnection.Port", (Object)3306);
        config.addDefault("MySQL.MainConnection.Database", (Object)"database");
        config.addDefault("MySQL.MainConnection.User", (Object)"root");
        config.addDefault("MySQL.MainConnection.Password", (Object)"");
        ConfigValues.LOG_QUERY = config.getBoolean("Config.LogQuery");
        ConfigValues.ENABLE_TABLE_REGISTRY = config.getBoolean("Config.EnableTableRegistry");
        ConfigValues.MYSQL_HOST = config.getString("MySQL.MainConnection.Host");
        ConfigValues.MYSQL_PORT = config.getInt("MySQL.MainConnection.Port");
        ConfigValues.MYSQL_DATABASE = config.getString("MySQL.MainConnection.Database");
        ConfigValues.MYSQL_USER = config.getString("MySQL.MainConnection.User");
        ConfigValues.MYSQL_PASSWORD = config.getString("MySQL.MainConnection.Password");
        if (!configFile.exists()) {
            config.addDefault("MySQL.BackupConnections.Element_1.Host", (Object)"127.0.0.1");
            config.addDefault("MySQL.BackupConnections.Element_1.Port", (Object)3306);
            config.addDefault("MySQL.BackupConnections.Element_1.Database", (Object)"backup_database");
            config.addDefault("MySQL.BackupConnections.Element_1.User", (Object)"root");
            config.addDefault("MySQL.BackupConnections.Element_1.Password", (Object)"");
        }
        config.options().copyDefaults(true);
        try {
            config.save(configFile);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static File getConfigFile() {
        return configFile;
    }

    public static FileConfiguration getConfig() {
        return config;
    }
}

