/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.bukkit.commands;

import de.syranda.bettercommands.customclasses.BetterCommand;
import de.syranda.bettercommands.customclasses.SubCommand;
import de.syranda.bettercommands.customclasses.parameter.ParameterSet;
import de.syranda.bettercommands.customclasses.parameter.ParameterType;
import de.syranda.spidermysql.bukkit.Main;
import de.syranda.spidermysql.customclasses.builder.ForeignKey;
import de.syranda.spidermysql.customclasses.builder.Key;
import de.syranda.spidermysql.customclasses.registry.TableInformation;
import de.syranda.spidermysql.customclasses.registry.TableRegistry;
import de.syranda.spidermysql.customclasses.registry.comparison.ComparisonInformation;
import de.syranda.spidermysql.customclasses.registry.comparison.FieldComparison;
import de.syranda.spidermysql.customclasses.registry.comparison.ForeignKeyComparison;
import de.syranda.spidermysql.customclasses.registry.comparison.KeyComparison;
import de.syranda.spidermysql.customclasses.registry.comparison.SingleComparison;
import de.syranda.spidermysql.customclasses.registry.patcher.PatcherRegistry;
import de.syranda.spidermysql.customclasses.registry.patcher.TablePatcher;
import de.syranda.spidermysql.customclasses.table.MySQLField;
import de.syranda.spidermysql.customclasses.table.TableClass;
import java.util.Arrays;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class SpiderMySQLCommand
extends BetterCommand {
    public SpiderMySQLCommand() {
        super((Plugin)Main.getInstance(), "spidermysql", "sql", "smysql", "spidersql");
        this.registerHelpSubCommand();
        this.setRootPermission("spidermysql");
        this.setDescription("SpiderMySQL main command");
        this.registerSubCommand(new SubCommand(this, "check"){

            @Override
            public void register() {
                this.addParameter("table", ParameterType.OPTIONAL);
                this.setHelpMessage("Command to check differences in the registered table class and its database counterpart");
            }

            @Override
            public void execute(CommandSender sender, ParameterSet parameterSet) {
                if (parameterSet.isSet("table")) {
                    this.checkTable(sender, new TableClass(parameterSet.getParameter("table").asString()));
                } else if (!TableRegistry.getRegisteredRamTables().isEmpty()) {
                    for (TableInformation table : TableRegistry.getRegisteredRamTables()) {
                        this.checkTable(sender, table.getTableClass());
                    }
                } else {
                    this.sendMessage(sender, this.getFailedColor() + "There are no tables to check", new Object[0]);
                }
            }

            private void checkTable(CommandSender sender, TableClass table) {
                if (!TableRegistry.isRegistered(table.getTableName())) {
                    sender.sendMessage(this.getFailedColor() + "Table not found");
                    return;
                }
                ComparisonInformation comp = table.compare();
                this.sendMessage(sender, this.getMinorColor() + this.repeatString("=", 20), new Object[0]);
                sender.sendMessage(this.getNormalColor() + "Checking table " + this.getHighlightColor() + table.getTableName() + this.getNormalColor() + "...");
                if (comp.hasDifferences()) {
                    sender.sendMessage(this.getNormalColor() + "There are the following differences:");
                    FieldComparison fComp = comp.getFieldComparison();
                    if (fComp.hasDifferences()) {
                        sender.sendMessage(this.getFailedColor() + "Field differences:");
                        for (Map.Entry<String, SingleComparison<MySQLField>> field : fComp.getDifferences().entrySet()) {
                            if (field.getValue().isInRam() && !field.getValue().isInDatabase()) {
                                sender.sendMessage(this.getNormalColor() + "Field " + this.getHighlightColor() + field.getKey() + this.getNormalColor() + " was not found in the " + this.getHighlightColor() + "database");
                                continue;
                            }
                            if (!field.getValue().isInRam() && field.getValue().isInDatabase()) {
                                sender.sendMessage(this.getNormalColor() + "Field " + this.getHighlightColor() + field.getKey() + this.getNormalColor() + " was not found in the " + this.getHighlightColor() + "RAM");
                                continue;
                            }
                            sender.sendMessage(this.getNormalColor() + "RAM: " + this.getHighlightColor() + field.getValue().getRamValue().toString() + this.getNormalColor() + " -> Database: " + this.getHighlightColor() + field.getValue().getDatabaseValue().toString());
                        }
                    } else {
                        sender.sendMessage(this.getSuccessColor() + "No field differences were found");
                    }
                    KeyComparison kComp = comp.getKeyComparison();
                    if (kComp.hasDifferences()) {
                        sender.sendMessage(this.getFailedColor() + "Key differences:");
                        for (Map.Entry<String, SingleComparison<Key>> key : kComp.getDifferences().entrySet()) {
                            if (key.getValue().isInRam() && !key.getValue().isInDatabase()) {
                                sender.sendMessage(this.getNormalColor() + "The " + (key.getKey().equals("") ? this.getHighlightColor() + "Primary key" : this.getNormalColor() + "Key " + this.getHighlightColor() + key.getKey()) + this.getNormalColor() + " was not found in the " + this.getHighlightColor() + "database");
                                continue;
                            }
                            if (!key.getValue().isInRam() && key.getValue().isInDatabase()) {
                                sender.sendMessage(this.getNormalColor() + "The " + (key.getKey().equals("") ? this.getHighlightColor() + "Primary key" : this.getNormalColor() + "Key " + this.getHighlightColor() + key.getKey()) + this.getNormalColor() + " was not found in the " + this.getHighlightColor() + "RAM");
                                continue;
                            }
                            Key ram = key.getValue().getRamValue();
                            Key data = key.getValue().getDatabaseValue();
                            if (ram.getKeyType() != ram.getKeyType()) {
                                sender.sendMessage(this.getNormalColor() + "Key type mismatch for the " + (key.getKey().equals("") ? this.getHighlightColor() + "Primary key" : "key " + this.getHighlightColor() + key.getKey()) + this.getNormalColor() + " | RAM: " + this.getHighlightColor() + ram.getKeyType().name() + this.getNormalColor() + " -> Database: " + this.getHighlightColor() + data.getKeyType().name());
                            }
                            if (Arrays.equals(ram.getColumns(), data.getColumns())) continue;
                            sender.sendMessage(this.getNormalColor() + "Key reference mismatch for the " + (key.getKey().equals("") ? this.getHighlightColor() + "Primary key" : "key " + this.getHighlightColor() + key.getKey()) + this.getNormalColor() + " | RAM: " + this.getHighlightColor() + String.join((CharSequence)", ", ram.getColumns()) + this.getNormalColor() + " -> Database: " + this.getHighlightColor() + String.join((CharSequence)", ", data.getColumns()));
                        }
                    } else {
                        sender.sendMessage(this.getSuccessColor() + "No key differences were found");
                    }
                    ForeignKeyComparison fkComp = comp.getForeignKeyComparison();
                    if (fkComp.hasDifferences()) {
                        sender.sendMessage(this.getFailedColor() + "Foreign key differences:");
                        for (Map.Entry<String, SingleComparison<ForeignKey>> fKey : fkComp.getDifferences().entrySet()) {
                            if (fKey.getValue().isInRam() && !fKey.getValue().isInDatabase()) {
                                sender.sendMessage(this.getNormalColor() + "Foreign key " + this.getHighlightColor() + fKey.getKey() + this.getNormalColor() + " was not found in the " + this.getHighlightColor() + "database");
                                continue;
                            }
                            if (!fKey.getValue().isInRam() && fKey.getValue().isInDatabase()) {
                                sender.sendMessage(this.getNormalColor() + "Foreign key " + this.getHighlightColor() + fKey.getKey() + this.getNormalColor() + " was not found in the " + this.getHighlightColor() + "RAM");
                                continue;
                            }
                            ForeignKey ram = fKey.getValue().getRamValue();
                            ForeignKey data = fKey.getValue().getDatabaseValue();
                            if (!ram.getRefrenceTable().equals(data.getRefrenceTable())) {
                                sender.sendMessage(this.getNormalColor() + "Reference table mismatch for foreign key " + this.getHighlightColor() + fKey.getKey() + this.getNormalColor() + " | RAM: " + this.getHighlightColor() + ram.getRefrenceTable() + this.getNormalColor() + " -> Database: " + this.getHighlightColor() + data.getKeyName());
                            }
                            if (!Arrays.equals(ram.getReferenceColumns(), data.getReferenceColumns())) {
                                sender.sendMessage(this.getNormalColor() + "Reference columns mismatch for foreign key " + this.getHighlightColor() + fKey.getKey() + this.getNormalColor() + " | RAM: " + this.getHighlightColor() + String.join((CharSequence)", ", ram.getReferenceColumns()) + this.getNormalColor() + " -> Database: " + this.getHighlightColor() + String.join((CharSequence)", ", data.getReferenceColumns()));
                            }
                            if (!Arrays.equals(ram.getTargetColumns(), data.getTargetColumns())) {
                                sender.sendMessage(this.getNormalColor() + "Target columns mismatch for foreign key " + this.getHighlightColor() + fKey.getKey() + this.getNormalColor() + " | RAM: " + this.getHighlightColor() + String.join((CharSequence)", ", ram.getTargetColumns()) + this.getNormalColor() + " -> Database: " + this.getHighlightColor() + String.join((CharSequence)", ", data.getTargetColumns()));
                            }
                            if (ram.getOnUpdate() != data.getOnUpdate()) {
                                sender.sendMessage(this.getNormalColor() + "On update action mismatch for foreign key " + this.getHighlightColor() + fKey.getKey() + this.getNormalColor() + " | RAM: " + this.getHighlightColor() + ram.getOnUpdate().name() + this.getNormalColor() + " -> Database: " + this.getHighlightColor() + data.getOnUpdate().name());
                            }
                            if (ram.getOnDelete() == data.getOnDelete()) continue;
                            sender.sendMessage(this.getNormalColor() + "On delete action mismatch for foreign key " + this.getHighlightColor() + fKey.getKey() + this.getNormalColor() + " | RAM: " + this.getHighlightColor() + ram.getOnDelete().name() + this.getNormalColor() + " -> Database: " + this.getHighlightColor() + data.getOnDelete().name());
                        }
                    } else {
                        sender.sendMessage(this.getSuccessColor() + "No foreign key differences were found");
                    }
                } else {
                    sender.sendMessage(this.getSuccessColor() + "No differences found.");
                }
            }
        });
        this.registerSubCommand(new SubCommand(this, "patcher.list"){

            @Override
            public void register() {
                this.setHelpMessage("Shows all registered table patchers");
            }

            @Override
            public void execute(CommandSender sender, ParameterSet parameterSet) {
                if (PatcherRegistry.getPatcherList().isEmpty()) {
                    this.sendMessage(sender, this.getFailedColor() + "There are not patcher available", new Object[0]);
                    return;
                }
                sender.sendMessage(this.getNormalColor() + "There are the following patcher available:");
                for (TablePatcher patcher : PatcherRegistry.getPatcherList()) {
                    sender.sendMessage(this.getNormalColor() + "Patcher " + this.getHighlightColor() + patcher.getName() + this.getNormalColor());
                }
            }
        });
        this.registerSubCommand(new SubCommand(this, "patcher.info"){

            @Override
            public void register() {
                this.addParameter("test", ParameterType.CONSTRAINT);
                this.setHelpMessage("Shows information about a table patcher");
            }

            @Override
            public void execute(CommandSender sender, ParameterSet parameterSet) {
            }
        });
        this.registerSubCommand(new SubCommand(this, "patcher.load"){

            @Override
            public void execute(CommandSender sender, ParameterSet parameterSet) {
            }
        });
        this.registerSubCommand(new SubCommand(this, "patcher.set"){

            @Override
            public void execute(CommandSender sender, ParameterSet parameterSet) {
            }
        });
        this.registerSubCommand(new SubCommand(this, "patcher.addalter"){

            @Override
            public void execute(CommandSender sender, ParameterSet parameterSet) {
            }
        });
        this.registerSubCommand(new SubCommand(this, "patch"){

            @Override
            public void execute(CommandSender sender, ParameterSet parameterSet) {
            }
        });
    }
}

