/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.spidermysql.bukkit;

import de.syranda.spidermysql.customclasses.table.ClassSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class DefaultClassSerializers {
    public static void loadDefaultClassSerializers() {
        ClassSerializer.addClassSerializer(Location.class, new ClassSerializer<Location>(){

            @Override
            public HashMap<String, Object> serialize(String fieldName, Location loc) {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put(String.valueOf(fieldName) + "_x", loc.getX());
                ret.put(String.valueOf(fieldName) + "_y", loc.getY());
                ret.put(String.valueOf(fieldName) + "_z", loc.getZ());
                ret.put(String.valueOf(fieldName) + "_yaw", Float.valueOf(loc.getYaw()));
                ret.put(String.valueOf(fieldName) + "_pitch", Float.valueOf(loc.getPitch()));
                ret.put(String.valueOf(fieldName) + "_world", loc.getWorld().getName());
                return ret;
            }

            @Override
            public HashMap<String, Class<?>> getPattern(String fieldName) {
                HashMap ret = new HashMap();
                ret.put(String.valueOf(fieldName) + "_x", Double.TYPE);
                ret.put(String.valueOf(fieldName) + "_y", Double.TYPE);
                ret.put(String.valueOf(fieldName) + "_z", Double.TYPE);
                ret.put(String.valueOf(fieldName) + "_yaw", Float.TYPE);
                ret.put(String.valueOf(fieldName) + "_pitch", Float.TYPE);
                ret.put(String.valueOf(fieldName) + "_world", String.class);
                return ret;
            }

            @Override
            public Location deserialize(String fieldName, HashMap<String, Object> columns) {
                Location loc = new Location(Bukkit.getWorld((String)columns.get(String.valueOf(fieldName) + "_world").toString()), Double.parseDouble(columns.get(String.valueOf(fieldName) + "_x").toString()), Double.parseDouble(columns.get(String.valueOf(fieldName) + "_y").toString()), Double.parseDouble(columns.get(String.valueOf(fieldName) + "_z").toString()));
                if (columns.containsKey(String.valueOf(fieldName) + "_pitch")) {
                    loc.setPitch(Float.parseFloat(columns.get(String.valueOf(fieldName) + "_pitch").toString()));
                }
                if (columns.containsKey(String.valueOf(fieldName) + "_yaw")) {
                    loc.setYaw(Float.parseFloat(columns.get(String.valueOf(fieldName) + "_yaw").toString()));
                }
                return loc;
            }
        });
        ClassSerializer.addClassSerializer(JSONObject.class, new ClassSerializer<JSONObject>(){

            @Override
            public HashMap<String, Object> serialize(String fieldName, JSONObject object) {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put(fieldName, object.toJSONString());
                return ret;
            }

            @Override
            public HashMap<String, Class<?>> getPattern(String fieldName) {
                HashMap ret = new HashMap();
                ret.put(fieldName, String.class);
                return ret;
            }

            @Override
            public JSONObject deserialize(String fieldName, HashMap<String, Object> columns) {
                try {
                    return (JSONObject)new JSONParser().parse(columns.get(fieldName).toString());
                }
                catch (ParseException e) {
                    return null;
                }
            }
        });
        ClassSerializer.addClassSerializer(ItemStack.class, new ClassSerializer<ItemStack>(){

            @Override
            public HashMap<String, Object> serialize(String fieldName, ItemStack is) {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put(String.valueOf(fieldName) + "_material", is.getType().name());
                ret.put(String.valueOf(fieldName) + "_amount", is.getAmount());
                ret.put(String.valueOf(fieldName) + "_data", is.getData().getData());
                if (is.hasItemMeta()) {
                    ItemMeta im = is.getItemMeta();
                    ret.put(String.valueOf(fieldName) + "_displayname", im.hasDisplayName() ? im.getDisplayName().replace("\u00a7", "&") : null);
                    String lore = null;
                    if (im.hasLore()) {
                        lore = "";
                        int i = 0;
                        while (i < im.getLore().size()) {
                            lore = String.valueOf(lore) + (i == 0 ? ((String)im.getLore().get(i)).replace("\u00a7", "&") : "\\n" + ((String)im.getLore().get(i)).replace("\u00a7", "&"));
                            ++i;
                        }
                    }
                    ret.put(String.valueOf(fieldName) + "_lore", lore);
                    String ench = null;
                    if (im.hasEnchants()) {
                        ench = "";
                        if (is.getType() == Material.ENCHANTED_BOOK) {
                            EnchantmentStorageMeta esm = (EnchantmentStorageMeta)im;
                            int i = 0;
                            while (i < esm.getStoredEnchants().size()) {
                                Map.Entry entry = (Map.Entry)esm.getStoredEnchants().entrySet().toArray()[i];
                                ench = String.valueOf(ench) + (i == 0 ? String.valueOf(((Enchantment)entry.getKey()).getName()) + ":" + entry.getValue() : ";" + entry.getKey() + ":" + entry.getValue());
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < im.getEnchants().size()) {
                                Map.Entry entry = (Map.Entry)im.getEnchants().entrySet().toArray()[i];
                                ench = String.valueOf(ench) + (i == 0 ? String.valueOf(((Enchantment)entry.getKey()).getName()) + ":" + entry.getValue() : ";" + entry.getKey() + ":" + entry.getValue());
                                ++i;
                            }
                        }
                    }
                    ret.put(String.valueOf(fieldName) + "_enchantments", ench);
                    String flags = null;
                    if (!im.getItemFlags().isEmpty()) {
                        flags = "";
                        int i = 0;
                        while (i < im.getItemFlags().size()) {
                            flags = String.valueOf(flags) + (i == 0 ? ((ItemFlag)im.getItemFlags().toArray()[i]).name() : ";" + ((ItemFlag)im.getItemFlags().toArray()[i]).name());
                            ++i;
                        }
                    }
                    ret.put(String.valueOf(fieldName) + "_flags", flags);
                    String potioneffects = null;
                    if (im instanceof PotionMeta) {
                        PotionMeta pm = (PotionMeta)im;
                        potioneffects = pm.getBasePotionData() + ":" + pm.getBasePotionData().isExtended() + ":" + pm.getBasePotionData().isUpgraded();
                    }
                    ret.put(String.valueOf(fieldName) + "_potioneffects", potioneffects);
                }
                return ret;
            }

            @Override
            public HashMap<String, Class<?>> getPattern(String fieldName) {
                HashMap ret = new HashMap();
                ret.put(String.valueOf(fieldName) + "_material", String.class);
                ret.put(String.valueOf(fieldName) + "_amount", Integer.TYPE);
                ret.put(String.valueOf(fieldName) + "_data", Integer.TYPE);
                ret.put(String.valueOf(fieldName) + "_displayname", String.class);
                ret.put(String.valueOf(fieldName) + "_lore", String.class);
                ret.put(String.valueOf(fieldName) + "_enchantments", String.class);
                ret.put(String.valueOf(fieldName) + "_potioneffects", String.class);
                ret.put(String.valueOf(fieldName) + "_flags", String.class);
                return ret;
            }

            @Override
            public ItemStack deserialize(String fieldName, HashMap<String, Object> columns) {
                int n;
                ItemStack is = new ItemStack(Material.valueOf((String)columns.get(String.valueOf(fieldName) + "_material").toString()));
                int amount = columns.containsKey(String.valueOf(fieldName) + "_amount") ? Integer.parseInt(columns.get(String.valueOf(fieldName) + "_amount").toString()) : 1;
                is.setAmount(amount);
                short data = columns.containsKey(String.valueOf(fieldName) + "_data") ? Short.parseShort(columns.get(String.valueOf(fieldName) + "_data").toString()) : (short)0;
                is.setDurability(data);
                ItemMeta im = is.getItemMeta();
                String displayname = columns.containsKey(String.valueOf(fieldName) + "_displayname") ? ChatColor.translateAlternateColorCodes((char)'&', (String)columns.get(String.valueOf(fieldName) + "_displayname").toString()) : null;
                im.setDisplayName(displayname);
                if (columns.containsKey(String.valueOf(fieldName) + "_lore") && columns.get(String.valueOf(fieldName) + "_lore") != null) {
                    ArrayList<String> lore = new ArrayList<String>();
                    String[] stringArray = columns.get(String.valueOf(fieldName) + "_lore").toString().split("\\\\n");
                    int n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        String loreL = stringArray[n];
                        if (!loreL.matches("^(\\s)*$")) {
                            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)loreL));
                        }
                        ++n;
                    }
                    im.setLore(lore);
                }
                if (columns.containsKey(String.valueOf(fieldName) + "_enchantments") && columns.get(String.valueOf(fieldName) + "_enchantments") != null) {
                    String[] stringArray = columns.get(String.valueOf(fieldName) + "_enchantments").toString().split(";");
                    n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String enchString = stringArray[n3];
                        Enchantment ench = Enchantment.getByName((String)enchString.split(":")[0]);
                        int level = Integer.parseInt(enchString.split(":")[1]);
                        if (is.getType() == Material.ENCHANTED_BOOK) {
                            ((EnchantmentStorageMeta)im).addStoredEnchant(ench, level, true);
                        } else {
                            im.addEnchant(ench, level, true);
                        }
                        ++n3;
                    }
                }
                if (columns.containsKey(String.valueOf(fieldName) + "_flags") && columns.get(String.valueOf(fieldName) + "_flags") != null) {
                    String[] stringArray = columns.get(String.valueOf(fieldName) + "_flags").toString().split(";");
                    n = stringArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String flagString = stringArray[n4];
                        im.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flagString)});
                        ++n4;
                    }
                }
                if (columns.containsKey(String.valueOf(fieldName) + "_potioneffects") && columns.get(String.valueOf(fieldName) + "_potioneffects") != null) {
                    String potioneffect = columns.get(String.valueOf(fieldName) + "_potioneffects").toString();
                    ((PotionMeta)im).setBasePotionData(new PotionData(PotionType.valueOf((String)potioneffect.split(";")[0]), Boolean.parseBoolean(potioneffect.split(";")[1]), Boolean.parseBoolean(potioneffect.split(";")[2])));
                }
                is.setItemMeta(im);
                return is;
            }
        });
    }
}

