/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.bettercommands.customclasses;

import de.syranda.bettercommands.customclasses.BetterCommand;
import de.syranda.bettercommands.customclasses.CommandValue;
import de.syranda.bettercommands.customclasses.config.BetterCommandConfig;
import de.syranda.bettercommands.customclasses.parameter.CommandParameter;
import de.syranda.bettercommands.customclasses.parameter.ParameterSet;
import de.syranda.bettercommands.customclasses.parameter.ParameterType;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubCommand
implements BetterCommandConfig {
    private BetterCommand command;
    private String path;
    private String permission;
    private boolean isPlayerOnly = false;
    private String helpMessage;
    private String castErrorMessage;
    private String permissionDeniedMessage;
    private String syntaxErrorMessage;
    private String invalidSenderMessage;
    private String prefix;
    private ChatColor normalColor;
    private ChatColor subNormalColor;
    private ChatColor successColor;
    private ChatColor failedColor;
    private ChatColor highlightColor;
    private ChatColor subHighlightColor;
    private ChatColor minorColor;
    private CommandValue[] values;
    private List<CommandParameter> parameters;
    private ParameterType lastType;

    public SubCommand(BetterCommand command, String path) {
        this.command = command;
        this.path = path;
        if (!this.hasCorrectFormedPath()) {
            System.err.println("[BetterCommands] Invalid path format for command '" + command.getName() + "' (Path: " + path + ")");
        }
        this.parameters = new ArrayList<CommandParameter>();
        if (this.getCommand().getRootPermission() != null) {
            this.permission = String.valueOf(this.getCommand().getRootPermission()) + "." + path;
        }
        this.setHelpMessage(command.getHelpMessage());
        this.setCastErrorMessage(command.getCastErrorMessage());
        this.setPermissionDeniedMessage(command.getPermissionDeniedMessage());
        this.setSyntaxErrorMessage(command.getSyntaxErrorMessage());
        this.setInvalidSenderMessage(command.getInvalidSenderMessage());
        this.setPrefix(command.getPrefix());
        this.setNormalColor(command.getNormalColor());
        this.setSubNormalColor(command.getSubNormalColor());
        this.setSuccessColor(command.getSuccessColor());
        this.setFailedColor(command.getFailedColor());
        this.setHighlightColor(command.getHighlightColor());
        this.setSubHighlightColor(command.getSubHighlightColor());
        this.setMinorColor(command.getMinorColor());
        this.register();
        int count = this.getInlineParameterIndexes(this.getPath()).size();
        if (count > this.parameters.size()) {
            System.err.println("[BetterCommands] Command " + command.getName() + " (" + this.getPath() + ") does contain to few parameters. Registering placeholder parameters...");
            int i = 1;
            while (i <= count) {
                this.addParameter("placeholder" + i, ParameterType.CONSTRAINT);
                ++i;
            }
        }
    }

    public SubCommand(BetterCommand command) {
        this(command, "");
    }

    public BetterCommand getCommand() {
        return this.command;
    }

    public String getPath() {
        return this.path;
    }

    public String getPermission() {
        return this.permission;
    }

    protected void setPermission(String permission) {
        this.permission = permission;
    }

    public int getMinParameterLength() {
        int ret = 0;
        for (CommandParameter set : this.parameters) {
            if (set.getParameterType() != ParameterType.CONSTRAINT && set.getParameterType() != ParameterType.CONSTRAINT_ARRAY) continue;
            ++ret;
        }
        return ret - this.getInlineParameterIndexes(this.getPath()).size();
    }

    public int getMaxParameterLength() {
        for (CommandParameter set : this.parameters) {
            if (set.getParameterType() != ParameterType.CONSTRAINT_ARRAY && set.getParameterType() != ParameterType.OPTIONAL_ARRAY) continue;
            return -1;
        }
        return this.parameters.size() - this.getInlineParameterIndexes(this.getPath()).size();
    }

    public void clearPermission() {
        this.permission = null;
    }

    public void setPlayerOnly(boolean isPlayerOnly) {
        this.isPlayerOnly = isPlayerOnly;
    }

    public boolean isPlayerOnly() {
        return this.isPlayerOnly;
    }

    public void addParameter(CommandParameter parameter) {
        if (!this.parameters.isEmpty()) {
            if (this.lastType == ParameterType.CONSTRAINT_ARRAY || this.lastType == ParameterType.OPTIONAL_ARRAY) {
                System.err.println("[BetterCommands] Cannot register parameter after an array (Command: " + this.command.getName() + " | Path: " + this.getPath() + ")");
                return;
            }
            if (this.lastType == ParameterType.OPTIONAL && (parameter.getParameterType() == ParameterType.CONSTRAINT || parameter.getParameterType() == ParameterType.CONSTRAINT_ARRAY)) {
                System.err.println("[BetterCommands] Cannot register a contraint parameter after an optional parameter (Command: " + this.command.getName() + " | Path: " + this.getPath() + ")");
                return;
            }
            for (CommandParameter commandParameter : this.parameters) {
                if (!commandParameter.getName().equalsIgnoreCase(parameter.getName())) continue;
                System.err.println("[BetterCommands] Cannto register paremeters with the same name (Command: " + this.command.getName() + " | Path: " + this.getPath() + ")");
                return;
            }
        }
        if (this.parameters.size() < this.getInlineParameterIndexes(this.getPath()).size() && parameter.getParameterType() != ParameterType.CONSTRAINT) {
            System.err.println("[BetterCommands] Inline parameters have to be constraint type parameters (Command: " + this.command.getName() + " | Path: " + this.getPath() + ")");
            return;
        }
        this.lastType = parameter.getParameterType();
        this.parameters.add(parameter);
    }

    public void addParameter(String name, ParameterType type) {
        this.addParameter(new CommandParameter(name, type));
    }

    public List<CommandParameter> getParameters() {
        return this.parameters;
    }

    public void internalExecute(CommandSender sender, CommandValue[] args) {
        this.values = args;
        if (this.permission != null && !sender.hasPermission(this.getPermission())) {
            this.sendMessage(sender, this.getPermissionDeniedMessage(), new Object[0]);
            return;
        }
        if (this.isPlayerOnly && !(sender instanceof Player)) {
            this.sendMessage(sender, this.getInvalidSenderMessage(), new Object[0]);
            return;
        }
        List<Integer> inlineParameters = this.getInlineParameterIndexes(this.getPath().split("\\."));
        CommandValue[] sortOutArgs = new CommandValue[]{};
        if (args.length != 0) {
            sortOutArgs = new CommandValue[args.length - (this.getPathLength() - inlineParameters.size())];
            int i = 0;
            while (i < inlineParameters.size()) {
                sortOutArgs[i] = args[inlineParameters.get(i)];
                ++i;
            }
            i = inlineParameters.size();
            while (i < sortOutArgs.length) {
                sortOutArgs[i] = args[this.getPathLength() - 1 + i];
                ++i;
            }
        }
        this.execute(sender, new ParameterSet(this, sortOutArgs));
    }

    public CommandValue[] getValues() {
        return this.values;
    }

    public void register() {
    }

    public abstract void execute(CommandSender var1, ParameterSet var2);

    public String getUsage(boolean appendCommand) {
        StringBuilder build = new StringBuilder();
        build.append(appendCommand ? "/" + this.command.getCommand() : "");
        build.append(!this.path.equals("") && appendCommand ? " " : "");
        build.append(String.join((CharSequence)" ", this.path.split("\\.")));
        int i = 0;
        while (i < this.parameters.size()) {
            CommandParameter parameter = this.parameters.get(i);
            List<Integer> iParameters = this.getInlineParameterIndexes(build.toString());
            if (i < iParameters.size()) {
                build.replace(iParameters.get(i), iParameters.get(i) + 1, "<" + parameter.getName() + ">");
            } else if (parameter.getParameterType() == ParameterType.OPTIONAL) {
                build.append(" [" + parameter.getName() + "]");
            } else if (parameter.getParameterType() == ParameterType.CONSTRAINT) {
                build.append(" <" + parameter.getName() + ">");
            } else if (parameter.getParameterType() == ParameterType.CONSTRAINT_ARRAY) {
                build.append(" <" + parameter.getName() + "...>");
            } else if (parameter.getParameterType() == ParameterType.OPTIONAL_ARRAY) {
                build.append(" [" + parameter.getName() + "...]");
            }
            ++i;
        }
        return build.toString();
    }

    @Override
    public String getHelpMessage() {
        return this.helpMessage;
    }

    public void setHelpMessage(String helpMessage) {
        this.helpMessage = helpMessage;
    }

    @Override
    public String getCastErrorMessage() {
        return this.castErrorMessage;
    }

    public void setCastErrorMessage(String castErrorMessage) {
        this.castErrorMessage = castErrorMessage;
    }

    @Override
    public String getPermissionDeniedMessage() {
        return this.permissionDeniedMessage;
    }

    public void setPermissionDeniedMessage(String permissionDeniedMessage) {
        this.permissionDeniedMessage = permissionDeniedMessage;
    }

    @Override
    public String getSyntaxErrorMessage() {
        return this.syntaxErrorMessage;
    }

    public void setSyntaxErrorMessage(String syntaxErrorMessage) {
        this.syntaxErrorMessage = syntaxErrorMessage;
    }

    @Override
    public String getInvalidSenderMessage() {
        return this.invalidSenderMessage;
    }

    public void setInvalidSenderMessage(String invalidSenderMessage) {
        this.invalidSenderMessage = invalidSenderMessage;
    }

    @Override
    public ChatColor getNormalColor() {
        return this.normalColor;
    }

    public void setNormalColor(ChatColor normalColor) {
        this.normalColor = normalColor;
    }

    @Override
    public ChatColor getSuccessColor() {
        return this.successColor;
    }

    public void setSuccessColor(ChatColor successColor) {
        this.successColor = successColor;
    }

    @Override
    public ChatColor getFailedColor() {
        return this.failedColor;
    }

    public void setFailedColor(ChatColor failedColor) {
        this.failedColor = failedColor;
    }

    @Override
    public ChatColor getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(ChatColor highlightColor) {
        this.highlightColor = highlightColor;
    }

    @Override
    public ChatColor getMinorColor() {
        return this.minorColor;
    }

    public void setMinorColor(ChatColor minorColor) {
        this.minorColor = minorColor;
    }

    @Override
    public ChatColor getSubNormalColor() {
        return this.subNormalColor;
    }

    public void setSubNormalColor(ChatColor subNormalColor) {
        this.subNormalColor = subNormalColor;
    }

    @Override
    public ChatColor getSubHighlightColor() {
        return this.subHighlightColor;
    }

    public void setSubHighlightColor(ChatColor subHighlightColor) {
        this.subHighlightColor = subHighlightColor;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void sendMessage(CommandSender sender, String message, Object ... arguments) {
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        int i = 0;
        while (i < arguments.length) {
            message = message.replace("$" + i, arguments[i].toString());
            ++i;
        }
        sender.sendMessage(message);
    }

    public String repeatString(String string, int repeat) {
        return new String(new char[repeat]).replace("\u0000", string);
    }

    public int getPathLength() {
        return this.path.contains(".") ? this.path.split("\\.").length : (this.path.equals("") ? 0 : 1);
    }

    public List<Integer> getInlineParameterIndexes(String string) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < string.length()) {
            if (string.toCharArray()[i] == '%') {
                list.add(i);
            }
            ++i;
        }
        return list;
    }

    public List<Integer> getInlineParameterIndexes(String[] string) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < string.length) {
            if (string[i].equals("%")) {
                list.add(i);
            }
            ++i;
        }
        return list;
    }

    public boolean matchesPath(String path) {
        String[] own = this.getPath().split("\\.");
        String[] given = path.split("\\.");
        int i = 0;
        while (i < own.length) {
            if (!own[i].equals(given[i]) && !own[i].equals("%")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasCorrectFormedPath() {
        return this.getPath().equals("") || this.getPath().matches("(([^\\.\\s\\%]+|%)(\\.([^\\.\\s\\%]+|%))*\\.)?[^\\s\\.\\%]+");
    }
}

