/*
 * Decompiled with CFR 0.152.
 */
package de.syranda.bettercommands.customclasses;

import de.syranda.bettercommands.Main;
import de.syranda.bettercommands.customclasses.CommandValue;
import de.syranda.bettercommands.customclasses.SubCommand;
import de.syranda.bettercommands.customclasses.config.BetterCommandConfig;
import de.syranda.bettercommands.customclasses.config.ConfigRegistry;
import de.syranda.bettercommands.customclasses.parameter.ParameterSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.craftbukkit.v1_10_R1.CraftServer;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetterCommand
extends BukkitCommand
implements BetterCommandConfig {
    private static ArrayList<BetterCommand> betterCommands = new ArrayList();
    private String command;
    private List<SubCommand> subCommands;
    private String rootPermission;
    private String plugin;
    private String helpMessage;
    private String castErrorMessage;
    private String permissionDeniedMessage;
    private String syntaxErrorMessage;
    private String invalidSenderMessage;
    private String prefix;
    private ChatColor normalColor;
    private ChatColor subNormalColor;
    private ChatColor successColor;
    private ChatColor failedColor;
    private ChatColor highlightColor;
    private ChatColor subHighlightColor;
    private ChatColor minorColor;

    public static BetterCommand getBetterCommand(String command) {
        for (BetterCommand bc : betterCommands) {
            if (!bc.getCommand().equals(command)) continue;
            return bc;
        }
        return null;
    }

    public BetterCommand(Plugin plugin, String command, String ... aliases) {
        super(command);
        this.plugin = plugin != null ? plugin.getName() : "";
        this.command = command;
        this.subCommands = new ArrayList<SubCommand>();
        this.rootPermission = String.valueOf(plugin != null ? String.valueOf(plugin.getName()) + "." : "") + command;
        if (aliases != null) {
            this.setAliases(Arrays.asList(aliases));
        }
        ((CraftServer)Bukkit.getServer()).getCommandMap().register(command, (Command)this);
        betterCommands.add(this);
        this.setHelpMessage(this.getConfig().getHelpMessage());
        this.setCastErrorMessage(this.getConfig().getCastErrorMessage());
        this.setPermissionDeniedMessage(this.getConfig().getPermissionDeniedMessage());
        this.setSyntaxErrorMessage(this.getConfig().getSyntaxErrorMessage());
        this.setInvalidSenderMessage(this.getConfig().getInvalidSenderMessage());
        this.setPrefix(this.getConfig().getPrefix());
        this.setNormalColor(this.getConfig().getNormalColor());
        this.setSubNormalColor(this.getConfig().getSubNormalColor());
        this.setSuccessColor(this.getConfig().getSuccessColor());
        this.setFailedColor(this.getConfig().getFailedColor());
        this.setHighlightColor(this.getConfig().getHighlightColor());
        this.setSubHighlightColor(this.getConfig().getSubHighlightColor());
        this.setMinorColor(this.getConfig().getMinorColor());
    }

    public BetterCommand(String command, String ... aliases) {
        this((Plugin)Main.getInstance(), command, aliases);
    }

    public String getCommand() {
        return this.command;
    }

    public void setRootPermission(String rootPermission) {
        this.rootPermission = rootPermission;
    }

    public String getRootPermission() {
        return this.rootPermission;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        CommandValue[] cArgs = new CommandValue[args.length];
        int i = 0;
        while (i < args.length) {
            cArgs[i] = new CommandValue(args[i]);
            ++i;
        }
        if (args.length == 0 && this.getSubCommand("") == null && this.getSubCommand("help") != null) {
            this.getSubCommand("help").internalExecute(sender, cArgs);
            return true;
        }
        SubCommand sc = null;
        int i2 = args.length;
        while (i2 >= 0) {
            for (SubCommand current : this.getInlineArgumentlessSubCommands(i2)) {
                if (!current.matchesPath(String.join((CharSequence)".", Arrays.copyOf(args, i2)))) continue;
                sc = current;
                break;
            }
            if (sc != null) break;
            for (SubCommand current : this.getInlineArgumentedSubCommands(i2)) {
                if (!current.matchesPath(String.join((CharSequence)".", Arrays.copyOf(args, i2)))) continue;
                sc = current;
                break;
            }
            --i2;
        }
        if (sc != null && (sc.getMaxParameterLength() >= args.length - sc.getPathLength() || sc.getMaxParameterLength() == -1) && args.length - sc.getPathLength() >= sc.getMinParameterLength()) {
            sc.internalExecute(sender, cArgs);
        } else if (sc != null) {
            sc.sendMessage(sender, sc.getSyntaxErrorMessage(), sc.getUsage(true));
        } else if (this.getSubCommand("help") != null) {
            this.getSubCommand("help").internalExecute(sender, cArgs);
        }
        return true;
    }

    public void registerSubCommand(SubCommand subCommand) {
        if (this.getSubCommand(subCommand.getPath()) != null) {
            System.err.println("[BetterCommand] Cannot register subcommand " + subCommand.getPath() + ". Path does already exist");
            return;
        }
        if (subCommand.hasCorrectFormedPath()) {
            this.subCommands.add(subCommand);
        }
    }

    public void registerHelpSubCommand() {
        this.registerSubCommand(new SubCommand(this, "help"){

            public void register() {
                this.setHelpMessage("Help command");
            }

            public void execute(CommandSender sender, ParameterSet parameterSet) {
                int i = 0;
                while (i <= BetterCommand.this.getMaxArguments()) {
                    for (SubCommand subCommand : BetterCommand.this.getInlineArgumentlessSubCommands(i)) {
                        subCommand.sendMessage(sender, this.getSubHighlightColor() + "/" + subCommand.getCommand().getName() + (!subCommand.getPath().equals("") ? " " : "") + this.getNormalColor() + subCommand.getUsage(false) + this.getMinorColor() + " - " + this.getSubNormalColor() + subCommand.getHelpMessage(), new Object[0]);
                    }
                    for (SubCommand subCommand : BetterCommand.this.getInlineArgumentedSubCommands(i)) {
                        subCommand.sendMessage(sender, this.getSubHighlightColor() + "/" + subCommand.getCommand().getName() + (!subCommand.getPath().equals("") ? " " : "") + this.getNormalColor() + subCommand.getUsage(false) + this.getMinorColor() + " - " + this.getSubNormalColor() + subCommand.getHelpMessage(), new Object[0]);
                    }
                    ++i;
                }
            }
        });
    }

    private int getMaxArguments() {
        int ret = 0;
        for (SubCommand subCommand : this.subCommands) {
            ret = Math.max(ret, subCommand.getPath().split("\\.").length);
        }
        return ret;
    }

    private List<SubCommand> getInlineArgumentedSubCommands(int paraLength) {
        ArrayList<SubCommand> ret = new ArrayList<SubCommand>();
        for (SubCommand subCommand : this.subCommands) {
            if (subCommand.getPathLength() != paraLength || subCommand.getInlineParameterIndexes(subCommand.getPath()).size() <= 0) continue;
            ret.add(subCommand);
        }
        return ret;
    }

    private List<SubCommand> getInlineArgumentlessSubCommands(int paraLength) {
        ArrayList<SubCommand> ret = new ArrayList<SubCommand>();
        for (SubCommand subCommand : this.subCommands) {
            if (subCommand.getPathLength() != paraLength || subCommand.getInlineParameterIndexes(subCommand.getPath()).size() != 0) continue;
            ret.add(subCommand);
        }
        return ret;
    }

    public SubCommand getSubCommand(String path) {
        for (SubCommand subCommand : this.subCommands) {
            if (!subCommand.getPath().equals(path)) continue;
            return subCommand;
        }
        return null;
    }

    private BetterCommandConfig getConfig() {
        return ConfigRegistry.getConfig(this.plugin);
    }

    @Override
    public String getHelpMessage() {
        return this.helpMessage;
    }

    public void setHelpMessage(String helpMessage) {
        this.helpMessage = helpMessage;
    }

    @Override
    public String getCastErrorMessage() {
        return this.castErrorMessage;
    }

    public void setCastErrorMessage(String castErrorMessage) {
        this.castErrorMessage = castErrorMessage;
    }

    @Override
    public String getPermissionDeniedMessage() {
        return this.permissionDeniedMessage;
    }

    public void setPermissionDeniedMessage(String permissionDeniedMessage) {
        this.permissionDeniedMessage = permissionDeniedMessage;
    }

    @Override
    public String getSyntaxErrorMessage() {
        return this.syntaxErrorMessage;
    }

    public void setSyntaxErrorMessage(String syntaxErrorMessage) {
        this.syntaxErrorMessage = syntaxErrorMessage;
    }

    @Override
    public String getInvalidSenderMessage() {
        return this.invalidSenderMessage;
    }

    public void setInvalidSenderMessage(String invalidSenderMessage) {
        this.invalidSenderMessage = invalidSenderMessage;
    }

    @Override
    public ChatColor getNormalColor() {
        return this.normalColor;
    }

    public void setNormalColor(ChatColor normalColor) {
        this.normalColor = normalColor;
    }

    @Override
    public ChatColor getSuccessColor() {
        return this.successColor;
    }

    public void setSuccessColor(ChatColor successColor) {
        this.successColor = successColor;
    }

    @Override
    public ChatColor getFailedColor() {
        return this.failedColor;
    }

    public void setFailedColor(ChatColor failedColor) {
        this.failedColor = failedColor;
    }

    @Override
    public ChatColor getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(ChatColor highlightColor) {
        this.highlightColor = highlightColor;
    }

    @Override
    public ChatColor getMinorColor() {
        return this.minorColor;
    }

    public void setMinorColor(ChatColor minorColor) {
        this.minorColor = minorColor;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public ChatColor getSubNormalColor() {
        return this.subNormalColor;
    }

    public void setSubNormalColor(ChatColor subNormalColor) {
        this.subNormalColor = subNormalColor;
    }

    @Override
    public ChatColor getSubHighlightColor() {
        return this.subHighlightColor;
    }

    public void setSubHighlightColor(ChatColor subHighlightColor) {
        this.subHighlightColor = subHighlightColor;
    }
}

