/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.views;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Stream;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.utils.Reflections;
import mc.rellox.spawnermeta.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class SpawnerViewLayout {
    private static File lf;
    public static FileConfiguration layout;
    private static final Slot[] DEFAULT;
    public static final Slot[] LAYOUT;
    public static int charges;
    public static Slot background_slot;
    public static Material background;
    public static int background_model;

    static {
        int i = 0;
        DEFAULT = new Slot[]{new Slot(SlotType.STATS, true, i++, Material.NETHER_STAR, true), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.UPGRADE_RANGE, true, i++, Material.COMPASS, true), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.UPGRADE_DELAY, true, i++, Material.CLOCK, true), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.UPGRADE_AMOUNT, true, i++, Material.GOLD_INGOT, true), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.BACKGROUND, false, i++, Material.CYAN_STAINED_GLASS_PANE, false), new Slot(SlotType.CHARGES, true, i++, Material.COAL, true)};
        LAYOUT = new Slot[27];
    }

    public static void initialize() {
        lf = new File(SpawnerMeta.instance().getDataFolder(), "layout.yml");
        if (!lf.getParentFile().exists()) {
            lf.getParentFile().mkdirs();
        }
        if (lf.exists()) {
            layout = YamlConfiguration.loadConfiguration((File)lf);
        } else {
            try {
                lf.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            layout = YamlConfiguration.loadConfiguration((File)lf);
        }
        SpawnerViewLayout.setDefaultLayout();
        new BukkitRunnable(){

            public void run() {
                SpawnerViewLayout.setSlots();
                Slot[] slotArray = LAYOUT;
                int n = LAYOUT.length;
                int n2 = 0;
                while (n2 < n) {
                    Slot s = slotArray[n2];
                    if (s.t == SlotType.BACKGROUND) {
                        background = s.m;
                        background_model = s.o;
                        background_slot = s;
                        break;
                    }
                    ++n2;
                }
            }
        }.runTaskLater((Plugin)SpawnerMeta.instance(), 5L);
    }

    public static void saveLayout() {
        try {
            layout.save(lf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void updateLayout() {
        int i = 0;
        while (i < 27) {
            SpawnerViewLayout.LAYOUT[i].i = i;
            ++i;
        }
    }

    public static void setEditor(Inventory v) {
        int i = 0;
        while (i < 27) {
            v.setItem(i, SpawnerViewLayout.slot(LAYOUT[i]));
            ++i;
        }
        i = 27;
        while (i < 36) {
            v.setItem(i, SpawnerViewLayout.x());
            ++i;
        }
        v.setItem(31, SpawnerViewLayout.background());
    }

    public static void setBackground() {
        Stream.of(LAYOUT).filter(s -> s.t == SlotType.BACKGROUND).forEach(s -> {
            s.m = background;
            s.o = background_model;
        });
    }

    private static ItemStack background() {
        boolean b = background == null;
        ItemStack item = new ItemStack(b ? Material.BARRIER : background);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.setDisplayName(ChatColor.AQUA + "Background: " + ChatColor.GRAY + (b ? "Air" : Utils.displayName(item)));
        meta.addItemFlags(ItemFlag.values());
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(ChatColor.GREEN + "Click " + ChatColor.AQUA + "to swap material");
        lore.add(ChatColor.GOLD + "Shift-click " + ChatColor.AQUA + "to set as air");
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private static void setSlots() {
        int i = 0;
        while (i < 27) {
            try {
                String path = "Upgrade-Layout." + i;
                SpawnerViewLayout.LAYOUT[i] = new Slot(Reflections.RF.enumerate(SlotType.class, layout.getString(String.valueOf(path) + ".Type")), layout.getBoolean(String.valueOf(path) + ".Changable"), i, Reflections.RF.enumerate(Material.class, layout.getString(String.valueOf(path) + ".Material")), layout.getBoolean(String.valueOf(path) + ".Glint"), layout.getInt(String.valueOf(path) + ".Model"));
            }
            catch (Exception e) {
                SpawnerViewLayout.LAYOUT[i] = DEFAULT[i].copy();
                Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "SM" + ChatColor.DARK_PURPLE + "]" + ChatColor.DARK_RED + " Unable to read layout slot: " + i + ", using default");
            }
            ++i;
        }
    }

    public static void setDefaultLayout() {
        int i = 0;
        while (i < 27) {
            SpawnerViewLayout.defaultSlot(DEFAULT[i]);
            ++i;
        }
        layout.options().copyDefaults(true);
        layout.options().header("In this file you can modify spawner upgrade inventory layout.\nAfter any modifications do /sm update");
        SpawnerViewLayout.saveLayout();
    }

    private static void defaultSlot(Slot s) {
        if (s == null) {
            return;
        }
        layout.addDefault("Upgrade-Layout." + s.i + ".Type", (Object)s.t.name());
        layout.addDefault("Upgrade-Layout." + s.i + ".Changable", (Object)s.c);
        layout.addDefault("Upgrade-Layout." + s.i + ".Material", (Object)(s.m == null ? "AIR" : s.m.name()));
        layout.addDefault("Upgrade-Layout." + s.i + ".Glint", (Object)s.g);
        layout.addDefault("Upgrade-Layout." + s.i + ".Model", (Object)s.o);
    }

    public static void resetLayout() {
        int i = 0;
        while (i < 27) {
            SpawnerViewLayout.LAYOUT[i] = DEFAULT[i].copy();
            SpawnerViewLayout.saveSlot(SpawnerViewLayout.LAYOUT[i]);
            ++i;
        }
        background = Material.CYAN_STAINED_GLASS_PANE;
        background_model = 0;
    }

    public static void saveSlots() {
        int i = 0;
        while (i < 27) {
            SpawnerViewLayout.saveSlot(LAYOUT[i]);
            ++i;
        }
    }

    private static void saveSlot(Slot s) {
        if (s == null) {
            return;
        }
        layout.set("Upgrade-Layout." + s.i + ".Type", (Object)s.t.name());
        layout.set("Upgrade-Layout." + s.i + ".Changable", (Object)s.c);
        layout.set("Upgrade-Layout." + s.i + ".Material", (Object)(s.m == null ? "AIR" : s.m.name()));
        layout.set("Upgrade-Layout." + s.i + ".Glint", (Object)s.g);
        layout.set("Upgrade-Layout." + s.i + ".Model", (Object)s.o);
        SpawnerViewLayout.saveLayout();
    }

    private static ItemStack slot(Slot s) {
        boolean b = s.m == null;
        ItemStack item = new ItemStack(b ? Material.BARRIER : s.m);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.setDisplayName(String.valueOf(s.t.getName()) + ChatColor.GRAY + " (" + (b ? "Air" : Utils.displayName(item)) + ")");
        if (s.g) {
            meta.addEnchant(Enchantment.ARROW_DAMAGE, 0, true);
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES});
        if (s.c) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            lore.add(ChatColor.GREEN + "Right-click " + ChatColor.AQUA + "to shift to right " + ChatColor.GOLD + " -> ");
            lore.add(ChatColor.YELLOW + "Left-click " + ChatColor.AQUA + "to shift to left " + ChatColor.GOLD + " <- ");
            lore.add(ChatColor.GOLD + "Middle-click " + ChatColor.AQUA + "to swap material");
            lore.add(ChatColor.RED + "Shift-click " + ChatColor.AQUA + "to toggle glint");
            meta.setLore(lore);
        }
        if (s.o > 0) {
            meta.setCustomModelData(Integer.valueOf(s.o));
        }
        item.setItemMeta(meta);
        return item;
    }

    private static ItemStack x() {
        ItemStack item = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.setDisplayName(" ");
        item.setItemMeta(meta);
        return item;
    }

    public static class Slot {
        protected final SlotType t;
        protected final boolean c;
        protected int i;
        protected Material m;
        protected boolean g;
        protected int o;

        public Slot(SlotType t, boolean c, int i, Material m, boolean g, int o) {
            this.t = t;
            this.c = c;
            this.i = i;
            this.m = m == Material.AIR ? null : m;
            this.g = g;
            this.o = o;
        }

        public Slot(SlotType t, boolean c, int i, Material m, boolean g) {
            this(t, c, i, m, g, 0);
        }

        public Slot copy() {
            return new Slot(this.t, this.c, this.i, this.m, this.g, this.o);
        }
    }

    public static enum SlotType {
        BACKGROUND(ChatColor.DARK_GRAY + "Background"),
        UPGRADE_DELAY(ChatColor.GOLD + "Delay Upgrade"),
        UPGRADE_AMOUNT(ChatColor.DARK_PURPLE + "Amount Upgrade"),
        UPGRADE_RANGE(ChatColor.DARK_AQUA + "Range Upgrade"),
        CHARGES(ChatColor.AQUA + "Charges"),
        STATS(ChatColor.YELLOW + "Stats");

        private String name;

        private SlotType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static final class WL {
        public static boolean is(SlotType type, int o) {
            return Stream.of(LAYOUT).anyMatch(s -> s.t == type && s.i == o);
        }
    }
}

