/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.views;

import java.util.List;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.commands.CommandManager;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.utils.DataManager;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public final class SpawnerView
implements Listener {
    private static final ItemStack x = SpawnerView.x();
    private final List<SpawnerType> types;
    private final Player player;
    private final Inventory v;
    private int page;
    private final int total;

    public SpawnerView(Player player) {
        this.types = Settings.settings.spawner_view_entities;
        this.player = player;
        this.total = (this.types.size() + 1) / 27;
        this.v = Bukkit.createInventory(null, (int)36, (String)Language.get("Inventory.spawner-view.name").text());
        this.update();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SpawnerMeta.instance());
        player.openInventory(this.v);
        player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 2.0f, 2.0f);
    }

    private void update() {
        int i = 0;
        while (i < this.v.getSize()) {
            this.v.setItem(i, x);
            ++i;
        }
        int a = this.page * 27;
        int b = (Math.min(this.types.size(), (this.page + 1) * 27) - 1) % 27;
        int i2 = 0;
        while (i2 <= b) {
            if (i2 + a >= this.types.size()) break;
            this.v.setItem(i2, Settings.settings.view_item(this.types.get(i2 + a)));
            ++i2;
        }
        if (this.page > 0) {
            this.v.setItem(29, this.previous());
        }
        if (this.page < this.total) {
            this.v.setItem(33, this.next());
        }
        if (this.total > 0) {
            this.v.setItem(31, this.page(this.page + 1));
        }
    }

    public void close() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    private void onClick(InventoryClickEvent event) {
        if (this.player.isOnline()) {
            if (!this.v.equals(event.getClickedInventory())) {
                return;
            }
            if (!this.player.equals(event.getWhoClicked())) {
                return;
            }
            event.setCancelled(true);
            int s = event.getSlot();
            if (s == 33) {
                if (this.page >= this.total) {
                    return;
                }
                ++this.page;
                this.update();
                this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 2.0f, 2.0f);
            } else if (s == 29) {
                if (this.page <= 0) {
                    return;
                }
                --this.page;
                this.update();
                this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 2.0f, 2.0f);
            } else if (this.player.getGameMode() == GameMode.CREATIVE && this.player.isOp()) {
                int l = (Math.min(this.types.size(), (this.page + 1) * 27) - 1) % 27;
                if (s > l) {
                    return;
                }
                SpawnerType type = this.types.get(this.page * 27 + s);
                if (!type.exists()) {
                    return;
                }
                ClickType click = event.getClick();
                int a = click.isShiftClick() ? 64 : (click.isRightClick() ? 8 : 1);
                CommandManager.success((CommandSender)this.player, "Added #0 \u00d7 #1 to your inventory!", a, type.formated() + " Spawner");
                this.player.getInventory().addItem(new ItemStack[]{DataManager.getSpawners(type, a, false, true).get(0)});
                this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 2.0f);
            }
        } else {
            this.close();
        }
    }

    @EventHandler
    private void onClose(InventoryCloseEvent event) {
        if (!this.v.equals(event.getInventory())) {
            return;
        }
        this.close();
    }

    private ItemStack next() {
        ItemStack item = new ItemStack(Material.SPECTRAL_ARROW);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.spawner-view.items.page.next").text());
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack page(int p) {
        ItemStack item = new ItemStack(Material.PAPER, p);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.spawner-view.items.page.current", "page", (Object)p).text());
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack previous() {
        ItemStack item = new ItemStack(Material.SPECTRAL_ARROW);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.spawner-view.items.page.previous").text());
        item.setItemMeta(meta);
        return item;
    }

    private static ItemStack x() {
        ItemStack item = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(" ");
        item.setItemMeta(meta);
        return item;
    }
}

