/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.api.events.SpawnerChargeEvent;
import mc.rellox.spawnermeta.api.events.SpawnerSwitchEvent;
import mc.rellox.spawnermeta.api.events.SpawnerUpgradeEvent;
import mc.rellox.spawnermeta.api.spawner.Spawner;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.events.EventRegistry;
import mc.rellox.spawnermeta.prices.Group;
import mc.rellox.spawnermeta.prices.Price;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.spawner.UpgradeType;
import mc.rellox.spawnermeta.text.Text;
import mc.rellox.spawnermeta.text.content.Content;
import mc.rellox.spawnermeta.text.order.IOrder;
import mc.rellox.spawnermeta.utils.Messagable;
import mc.rellox.spawnermeta.utils.Utils;
import mc.rellox.spawnermeta.views.SpawnerViewLayout;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class SpawnerUpgrade
implements Listener {
    private static final Map<Block, SpawnerUpgrade> SPAWNERS = new HashMap<Block, SpawnerUpgrade>();
    private final List<Player> players = new ArrayList<Player>();
    private final Block block;
    private final Spawner spawner;
    private final Inventory v;
    private boolean t;
    private boolean enabled;

    public static void newUpgrade(Player player, Block block) {
        if (!(block.getState() instanceof CreatureSpawner)) {
            return;
        }
        SpawnerUpgrade su = SPAWNERS.get(block);
        if (su == null) {
            su = new SpawnerUpgrade(block);
            SPAWNERS.put(block, su);
        }
        su.open(player);
    }

    public static void newUpgrade(Player player, Block block, Inventory previous) {
        if (previous != null && previous.getViewers().contains(player)) {
            player.closeInventory();
        }
        SpawnerUpgrade.newUpgrade(player, block);
    }

    public static void removeUpgrade(Block block) {
        SPAWNERS.remove(block);
    }

    public static void close(Block block) {
        SpawnerUpgrade u = SPAWNERS.remove(block);
        if (u != null) {
            u.close();
        }
    }

    public static void update(Block block) {
        SpawnerUpgrade u = SPAWNERS.get(block);
        if (u != null) {
            u.update();
        }
    }

    public static void updateAll() {
        SPAWNERS.values().forEach(SpawnerUpgrade::update);
    }

    private SpawnerUpgrade(Block block) {
        this.block = block;
        this.spawner = Spawner.of(block);
        this.v = Bukkit.createInventory(null, (int)27, (String)Language.get("Inventory.upgrades.name", "type", (Object)this.spawner.getType().formated()).text());
        this.t = true;
        this.enabled = this.spawner.isEnabled();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SpawnerMeta.instance());
    }

    public void open(Player player) {
        this.players.add(player);
        player.openInventory(this.v);
        player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 2.0f, 2.0f);
        this.update();
    }

    public void close() {
        this.players.forEach(HumanEntity::closeInventory);
    }

    @EventHandler
    private void onClick(InventoryClickEvent event) {
        if (event.getInventory().equals(this.v)) {
            event.setCancelled(true);
        }
        Inventory c = event.getClickedInventory();
        Player player = (Player)event.getWhoClicked();
        Messagable m = new Messagable(player);
        if (c == null || !c.equals(this.v) || !this.players.contains(player)) {
            return;
        }
        try {
            int[] ms;
            UpgradeType upgrade;
            if (!this.t) {
                return;
            }
            this.t = false;
            new BukkitRunnable(){

                public void run() {
                    SpawnerUpgrade.this.t = true;
                }
            }.runTaskLater((Plugin)SpawnerMeta.instance(), 5L);
            int o = event.getSlot();
            if (SpawnerViewLayout.WL.is(SpawnerViewLayout.SlotType.STATS, o)) {
                if (!Settings.settings.spawner_switching) {
                    return;
                }
                SpawnerSwitchEvent call = EventRegistry.call(new SpawnerSwitchEvent(player, this.spawner, !this.enabled));
                if (call.cancelled()) {
                    return;
                }
                this.enabled = !this.enabled;
                this.spawner.setEnabled(this.enabled);
                player.playSound(player.getEyeLocation(), this.enabled ? Sound.ENTITY_ITEM_FRAME_ADD_ITEM : Sound.ENTITY_ITEM_FRAME_REMOVE_ITEM, 2.0f, 1.0f);
                this.spawner.setRotating(this.enabled);
                this.update();
                return;
            }
            if (SpawnerViewLayout.WL.is(SpawnerViewLayout.SlotType.UPGRADE_RANGE, o)) {
                upgrade = UpgradeType.RANGE;
            } else if (SpawnerViewLayout.WL.is(SpawnerViewLayout.SlotType.UPGRADE_DELAY, o)) {
                upgrade = UpgradeType.DELAY;
            } else if (SpawnerViewLayout.WL.is(SpawnerViewLayout.SlotType.UPGRADE_AMOUNT, o)) {
                upgrade = UpgradeType.AMOUNT;
            } else {
                if (Settings.settings.charges_enabled && SpawnerViewLayout.WL.is(SpawnerViewLayout.SlotType.CHARGES, o)) {
                    Price price;
                    SpawnerChargeEvent call;
                    int a;
                    ClickType ct = event.getClick();
                    SpawnerType type = this.spawner.getType();
                    int r = Settings.settings.charges_price(type, this.block);
                    if (ct.isShiftClick()) {
                        a = this.lowestCharges() / r;
                        if (a <= 0) {
                            return;
                        }
                    } else if (ct.isLeftClick()) {
                        a = Settings.settings.charges_buy_first;
                    } else if (ct.isRightClick()) {
                        a = Settings.settings.charges_buy_second;
                    } else {
                        return;
                    }
                    if ((call = EventRegistry.call(new SpawnerChargeEvent(player, this.spawner, price = Price.of(Group.charges, r * a), a))).cancelled()) {
                        return;
                    }
                    if (!call.withdraw(player)) {
                        return;
                    }
                    int charges = this.spawner.getCharges() + call.charges;
                    this.spawner.setCharges(charges);
                    m.send(Language.list("Inventory.upgrades.charges.purchase", "charges", (Object)call.charges));
                    player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 2.0f);
                    this.update();
                }
                return;
            }
            int i = upgrade.ordinal();
            if (!player.hasPermission("spawnermeta.upgrades.buy")) {
                m.send(Language.list("Spawners.upgrades.permission.purchase"));
                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
                return;
            }
            if (!this.allowed(i)) {
                m.send(Language.list("Inventory.upgrades.disabled-upgrade"));
                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
                return;
            }
            if (!Settings.settings.natural_can_upgrade && this.spawner.isNatural() && !player.hasPermission("spawnermeta.ownership.bypass.upgrading")) {
                m.send(Language.list("Spawners.natural.upgrading.warning"));
                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
                return;
            }
            if (!(Settings.settings.owned_can_upgrade || this.spawner.isOwner(player, true) || player.hasPermission("spawnermeta.ownership.bypass.upgrading"))) {
                m.send(Language.list("Spawners.ownership.upgrading.warning"));
                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
                return;
            }
            SpawnerType type = this.spawner.getType();
            int[] ls = this.spawner.getUpgradeLevels();
            if (ls[i] < (ms = Settings.settings.upgrades_levels.get(type))[i]) {
                Price price = this.price(type, ls[i], i);
                SpawnerUpgradeEvent call = EventRegistry.call(new SpawnerUpgradeEvent(player, this.spawner, upgrade, ls[i] + 1, ms[i], price));
                if (!price.has(player)) {
                    price = call.getUnsafePrice();
                    m.send(Language.list("Prices.insufficient", "insufficient", price.insufficient(), "price", price.requires(player)));
                    player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
                    return;
                }
                if (call.cancelled() || !call.withdraw(player)) {
                    return;
                }
                int u = call.upgrade_level;
                ls[i] = u < 1 ? 1 : (u > ms[i] ? ms[i] : u);
                this.spawner.setUpgradeLevels(ls);
                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 2.0f);
                UpgradeType ut = UpgradeType.of(i);
                m.send(Language.list("Inventory.upgrades.purchase." + ut.lower(), "level", (Object)Utils.roman(ls[i])));
                Particle.DustOptions d = new Particle.DustOptions(ut.color, 2.0f);
                player.spawnParticle(Particle.REDSTONE, Utils.center(this.block), 50, 0.25, 0.25, 0.25, 0.0, (Object)d);
                int[] a = this.spawner.getUpgradeAttributes();
                int n = i;
                a[n] = a[n] + Settings.settings.spawner_value_increase.get(type)[i];
                if (a[i] < 0) {
                    a[i] = 0;
                }
                this.spawner.setUpgradeAttributes(a);
                this.update();
            } else {
                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            }
        }
        catch (Exception e) {
            player.sendMessage(ChatColor.DARK_RED + "This upgrade inventory is invalid, closing!");
            player.closeInventory();
        }
    }

    @EventHandler
    private void onClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        this.players.remove(player);
        if (this.players.isEmpty()) {
            HandlerList.unregisterAll((Listener)this);
            SpawnerUpgrade.removeUpgrade(this.block);
        } else {
            this.update();
        }
    }

    public void update() {
        SpawnerType type = this.spawner.getType();
        int i = 0;
        while (i < 27) {
            SpawnerViewLayout.Slot s = SpawnerViewLayout.LAYOUT[i];
            if (s.t == SpawnerViewLayout.SlotType.BACKGROUND) {
                this.v.setItem(i, this.x(s));
            } else if (s.t == SpawnerViewLayout.SlotType.STATS) {
                this.v.setItem(i, this.stats(s));
            } else if (s.t == SpawnerViewLayout.SlotType.UPGRADE_RANGE) {
                this.v.setItem(i, this.allowed(0) ? this.upgrade(s, 0) : this.denied(0));
            } else if (s.t == SpawnerViewLayout.SlotType.UPGRADE_DELAY) {
                this.v.setItem(i, this.allowed(1) ? this.upgrade(s, 1) : this.denied(1));
            } else if (s.t == SpawnerViewLayout.SlotType.UPGRADE_AMOUNT) {
                this.v.setItem(i, this.allowed(2) ? this.upgrade(s, 2) : this.denied(2));
            } else if (s.t == SpawnerViewLayout.SlotType.CHARGES) {
                this.v.setItem(i, Settings.settings.charges_enabled ? this.charges(type, s) : this.x(SpawnerViewLayout.background_slot));
            }
            ++i;
        }
    }

    private ItemStack upgrade(SpawnerViewLayout.Slot slot, int i) {
        List<Content> name;
        ItemStack item = new ItemStack(slot.m);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        int[] levels = this.spawner.getUpgradeLevels();
        int level = levels[i];
        UpgradeType u = UpgradeType.of(i);
        meta.addItemFlags(ItemFlag.values());
        if (slot.g) {
            meta.addEnchant(Enchantment.ARROW_DAMAGE, 0, true);
        }
        if (slot.o > 0) {
            meta.setCustomModelData(Integer.valueOf(slot.o));
        }
        if ((name = Language.list("Inventory.upgrades.items.upgrade.name." + u.lower(), "level", (Object)Utils.roman(level))).size() > 0) {
            meta.setDisplayName(name.remove(0).text());
        }
        IOrder order = Settings.settings.order_upgrade.oderer();
        order.named(name);
        SpawnerType type = this.spawner.getType();
        int[] max_levels = Settings.settings.upgrades_levels.get(type);
        if (level < max_levels[i]) {
            order.submit("HELP", () -> Language.list("Inventory.upgrades.items.upgrade.help"));
        }
        order.submit("INFO", () -> Language.list("Inventory.upgrades.items.upgrade.info." + u.lower()));
        order.submit("CURRENT", () -> Language.list("Inventory.upgrades.items.upgrade.current." + u.lower(), "value", (Object)this.value(type, level, i)));
        if (level < max_levels[i]) {
            order.submit("NEXT", () -> Language.list("Inventory.upgrades.items.upgrade.next." + u.lower(), "value", (Object)this.value(type, level + 1, i)));
            order.submit("PRICE", () -> {
                Price price = this.price(type, level, i);
                return Language.list("Inventory.upgrades.items.upgrade.price", "price", (Object)price);
            });
        } else {
            order.submit("PRICE", () -> Language.list("Inventory.upgrades.items.upgrade.maximum-reached"));
        }
        meta.setLore(order.build());
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack denied(int i) {
        UpgradeType u = UpgradeType.of(i);
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        meta.addEnchant(Enchantment.ARROW_DAMAGE, 0, true);
        List<Content> name = Language.list("Inventory.upgrades.items.disabled-upgrade.name." + u.lower());
        if (name.size() > 0) {
            meta.setDisplayName(name.remove(0).text());
        }
        IOrder order = Settings.settings.order_disabled.oderer();
        order.named(name);
        int level = this.spawner.getUpgradeLevels()[i];
        SpawnerType type = this.spawner.getType();
        order.submit("HELP", () -> Language.list("Inventory.upgrades.items.disabled-upgrade.help"));
        order.submit("INFO", () -> Language.list("Inventory.upgrades.items.upgrade.info." + u.lower()));
        order.submit("CURRENT", () -> Language.list("Inventory.upgrades.items.disabled-upgrade.current." + u.lower(), "value", (Object)this.value(type, level, i)));
        meta.setLore(order.build());
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack stats(SpawnerViewLayout.Slot slot) {
        int c;
        int spawnable;
        List<Content> name;
        ItemStack item = new ItemStack(slot.m);
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(ItemFlag.values());
        if (slot.o > 0) {
            meta.setCustomModelData(Integer.valueOf(slot.o));
        }
        if (slot.g) {
            meta.addEnchant(Enchantment.ARROW_DAMAGE, 0, true);
        }
        if ((name = Language.list("Inventory.upgrades.items.stats.name", "type", (Object)this.spawner.getType())).size() > 0) {
            meta.setDisplayName(name.remove(0).text());
        }
        IOrder order = Settings.settings.order_stats.oderer();
        order.named(name);
        if (this.spawner.isEmpty()) {
            order.submit("EMPTY", () -> Language.list("Inventory.upgrades.items.stats.empty"));
        }
        if (Settings.settings.spawner_switching) {
            order.submit("SWITCHING", () -> this.enabled ? Language.list("Inventory.upgrades.items.stats.enabled") : Language.list("Inventory.upgrades.items.stats.disabled"));
        }
        int[] l = Utils.location(this.block);
        order.submit("LOCATION", () -> Language.list("Inventory.upgrades.items.stats.location", "x", this.c(l[0]), "y", l[1], "z", this.c(l[2])));
        int stack = this.spawner.getStack();
        if (Settings.settings.stacking_enabled) {
            order.submit("STACK", () -> {
                if (Settings.settings.stacking_ignore_limit) {
                    return Language.list("Inventory.upgrades.items.stats.stacking.infinite", "stack", (Object)stack);
                }
                return Language.list("Inventory.upgrades.items.stats.stacking.finite", "stack", stack, "limit", Settings.settings.stacking_spawner_limit);
            });
        }
        if (Settings.settings.spawnable_enabled && (spawnable = this.spawner.getSpawnable()) < 1000000000) {
            order.submit("SPAWNABLE", () -> Language.list("Inventory.upgrades.items.stats.spawnable", "spawnable", (Object)spawnable));
        }
        if (Settings.settings.charges_enabled && (c = this.spawner.getCharges()) <= 0) {
            boolean n;
            boolean bl = n = Settings.settings.charges_ignore_natural && this.spawner.isNatural();
            if (!n) {
                order.submit("WARNING", () -> Language.list("Inventory.upgrades.items.stats.charges.insufficient"));
            }
        }
        order.submit("INFO", () -> Language.list("Inventory.upgrades.items.stats.lore"));
        meta.setLore(order.build());
        item.setItemMeta(meta);
        return item;
    }

    private String c(int i) {
        return "" + (i < 0 ? (i == -1 ? "-0" : Integer.valueOf(i + 1)) : Integer.valueOf(i));
    }

    private int lowestCharges() {
        Price c = Price.of(Group.charges, 0);
        if (this.players.size() == 1) {
            return c.balance(this.players.get(0));
        }
        int b = -1;
        for (Player player : this.players) {
            int a = c.balance(player);
            if (b <= a && b >= 0) continue;
            b = a;
        }
        return b;
    }

    private ItemStack charges(SpawnerType type, SpawnerViewLayout.Slot slot) {
        ItemStack item = new ItemStack(slot.m);
        ItemMeta meta = item.getItemMeta();
        int c = this.spawner.getCharges();
        boolean b = c >= 1000000000;
        String charges = b ? "\u221e" : "" + this.spawner.getCharges();
        meta.setDisplayName(Language.get("Inventory.upgrades.items.charges.name", "charges", (Object)charges).text());
        meta.addItemFlags(ItemFlag.values());
        if (slot.g) {
            meta.addEnchant(Enchantment.ARROW_DAMAGE, 0, true);
        }
        if (slot.o > 0) {
            meta.setCustomModelData(Integer.valueOf(slot.o));
        }
        if (!b) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            int f0 = Settings.settings.charges_buy_first;
            int f1 = Settings.settings.charges_buy_second;
            int r = Settings.settings.charges_price(type, this.block);
            int c0 = r * f0;
            int c1 = r * f1;
            int a = this.lowestCharges() / r;
            int c2 = r * a;
            lore.addAll(Text.toText(Language.list("Inventory.upgrades.items.charges.purchase.first", "charges", f0, "price", Price.of(Group.charges, c0))));
            lore.addAll(Text.toText(Language.list("Inventory.upgrades.items.charges.purchase.second", "charges", f1, "price", Price.of(Group.charges, c1))));
            if (a > 0) {
                lore.addAll(Text.toText(Language.list("Inventory.upgrades.items.charges.purchase.all", "price", Price.of(Group.charges, c2), "charges", a)));
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack x(SpawnerViewLayout.Slot slot) {
        if (slot.m == null || slot.m == Material.AIR) {
            return null;
        }
        ItemStack item = new ItemStack(slot.m);
        ItemMeta meta = item.getItemMeta();
        if (slot.o > 0) {
            meta.setCustomModelData(Integer.valueOf(slot.o));
        }
        meta.addItemFlags(ItemFlag.values());
        if (slot.g) {
            meta.addEnchant(Enchantment.ARROW_DAMAGE, 0, true);
        }
        meta.setDisplayName(" ");
        item.setItemMeta(meta);
        return item;
    }

    private Price price(SpawnerType type, int level, int i) {
        int value = Settings.settings.upgrades_prices.get(type)[i];
        int increase = Settings.settings.upgrades_price_increase.get(type)[i];
        int j = 1;
        while (j < level) {
            value = Settings.settings.upgrade_increase_type.price(value, increase);
            ++j;
        }
        return Price.of(Group.upgrades, value * this.spawner.getStack());
    }

    private int value(SpawnerType type, int level, int i) {
        int value = Settings.settings.spawner_values.get(type)[i];
        int increase = Settings.settings.spawner_value_increase.get(type)[i];
        int j = 1;
        while (j < level) {
            value += increase;
            ++j;
        }
        return this.convert(value, i);
    }

    private int convert(int v, int i) {
        if (i == 0) {
            if (v <= 0) {
                return 1;
            }
            if (v > 512) {
                return 512;
            }
            return v;
        }
        if (i == 1) {
            if (v < 20) {
                return 1;
            }
            if (v > 12000) {
                return 600;
            }
            return (int)((double)v * 0.05);
        }
        if (i == 2) {
            int s = this.spawner.getStack();
            if (v <= 0) {
                return s;
            }
            if (v > 4048) {
                return 4048 * s;
            }
            return v * s;
        }
        return v;
    }

    private boolean allowed(int i) {
        SpawnerType type = this.spawner.getType();
        return Settings.settings.upgrades_upgradeable.get(type)[i];
    }
}

