/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.views;

import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.utils.Utils;
import mc.rellox.spawnermeta.views.SpawnerViewLayout;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class SpawnerEditor
implements Listener {
    private static Player editor;
    private static SpawnerEditor edit;
    private final Player player;
    private final Inventory v;

    public static void open(Player player) {
        if (editor != null && edit != null) {
            if (!editor.isOnline()) {
                editor = null;
            } else {
                Inventory t = editor.getOpenInventory().getTopInventory();
                if (t == null) {
                    editor = null;
                } else if (!t.equals(SpawnerEditor.edit.v)) {
                    editor = null;
                } else {
                    player.sendMessage(ChatColor.DARK_RED + "(!) " + ChatColor.GOLD + "There already is someone editing!");
                    player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
                    return;
                }
            }
        }
        editor = player;
        edit = new SpawnerEditor(editor);
        player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 2.0f, 2.0f);
        player.sendMessage(ChatColor.DARK_GREEN + "(!) " + ChatColor.DARK_AQUA + "Opening Spawner GUI Editor!");
    }

    private SpawnerEditor(Player player) {
        this.player = player;
        this.v = Bukkit.createInventory(null, (int)36, (String)"Spawner GUI Editor");
        SpawnerViewLayout.setEditor(this.v);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SpawnerMeta.instance());
        player.openInventory(this.v);
    }

    @EventHandler
    private void onClick(InventoryClickEvent event) {
        if (!this.check()) {
            return;
        }
        if (!this.player.equals(event.getWhoClicked())) {
            return;
        }
        Inventory c = event.getClickedInventory();
        if (c == null || !c.equals(this.v)) {
            return;
        }
        event.setCancelled(true);
        int s = event.getSlot();
        ClickType t = event.getClick();
        if (s >= 0 && s < 27) {
            SpawnerViewLayout.Slot l = SpawnerViewLayout.LAYOUT[s];
            if (!l.c) {
                return;
            }
            if (t == ClickType.RIGHT) {
                if (s == 26) {
                    return;
                }
                SpawnerViewLayout.LAYOUT[s] = SpawnerViewLayout.LAYOUT[s + 1];
                SpawnerViewLayout.LAYOUT[s + 1] = l;
                SpawnerViewLayout.updateLayout();
                this.player.playSound(this.player.getEyeLocation(), Sound.ENTITY_ITEM_FRAME_ROTATE_ITEM, 2.0f, 1.5f);
            } else if (t == ClickType.LEFT) {
                if (s == 0) {
                    return;
                }
                SpawnerViewLayout.LAYOUT[s] = SpawnerViewLayout.LAYOUT[s - 1];
                SpawnerViewLayout.LAYOUT[s - 1] = l;
                SpawnerViewLayout.updateLayout();
                this.player.playSound(this.player.getEyeLocation(), Sound.ENTITY_ITEM_FRAME_ROTATE_ITEM, 2.0f, 1.5f);
            } else if (t == ClickType.MIDDLE) {
                ItemMeta meta;
                ItemStack item = event.getCursor();
                if (Utils.nulled(item) || item.getType() == l.m) {
                    return;
                }
                l.m = item.getType();
                if (item.hasItemMeta() && (meta = item.getItemMeta()).hasCustomModelData()) {
                    l.o = meta.getCustomModelData();
                }
                this.player.playSound(this.player.getEyeLocation(), Sound.ENTITY_ITEM_FRAME_ADD_ITEM, 2.0f, 1.25f);
            } else if (t == ClickType.SHIFT_LEFT || t == ClickType.SHIFT_RIGHT) {
                l.g = !l.g;
                this.player.playSound(this.player.getEyeLocation(), l.g ? Sound.BLOCK_BEACON_ACTIVATE : Sound.BLOCK_BEACON_DEACTIVATE, 0.75f, 2.0f);
            }
        } else if (s == 31) {
            ItemStack item = event.getCursor();
            if (t.isShiftClick()) {
                if (SpawnerViewLayout.background == null) {
                    return;
                }
                SpawnerViewLayout.background = null;
                SpawnerViewLayout.background_model = 0;
            } else {
                ItemMeta meta;
                if (Utils.nulled(item) || item.getType() == SpawnerViewLayout.background) {
                    return;
                }
                SpawnerViewLayout.background = item.getType();
                if (item.hasItemMeta() && (meta = item.getItemMeta()).hasCustomModelData()) {
                    SpawnerViewLayout.background_model = meta.getCustomModelData();
                }
            }
            SpawnerViewLayout.setBackground();
            this.player.playSound(this.player.getEyeLocation(), Sound.ENTITY_ITEM_FRAME_ADD_ITEM, 2.0f, 1.25f);
        }
        SpawnerViewLayout.setEditor(this.v);
    }

    @EventHandler
    private void onClose(InventoryCloseEvent event) {
        if (!event.getPlayer().equals(this.player)) {
            return;
        }
        this.player.sendMessage(ChatColor.DARK_GREEN + "(!) " + ChatColor.DARK_AQUA + "Saving and closing editor!");
        this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.75f, 0.0f);
        this.unregister();
    }

    private boolean check() {
        boolean o = this.player.isOnline();
        if (!o) {
            this.unregister();
        }
        return o;
    }

    private void unregister() {
        HandlerList.unregisterAll((Listener)this);
        edit = null;
        editor = null;
        SpawnerViewLayout.saveSlots();
    }
}

