/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.function.Consumer;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.utils.Reflections;
import mc.rellox.spawnermeta.utils.Version;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class Utils {
    private static final Random R = new Random();

    public static boolean op(Player player) {
        return player.isOp() && player.getGameMode() == GameMode.CREATIVE;
    }

    public static void changeExp(Player player, int exp) {
        player.giveExp(exp);
    }

    public static int getExp(Player player) {
        int v = player.getLevel();
        int l = Utils.getExpAtLevel(v);
        int u = Utils.getExpToLevelUp(v);
        return l + Math.round((float)u * player.getExp());
    }

    public static int getExpAtLevel(int level) {
        int lq = level * level;
        if (level <= 16) {
            return lq + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)lq - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)lq - 162.5 * (double)level + 2220.0);
    }

    public static int getExpToLevelUp(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    public static Location center(Block block) {
        return block.getLocation().add(0.5, 0.5, 0.5);
    }

    public static int[] location(Block block) {
        return new int[]{block.getX(), block.getY(), block.getZ()};
    }

    public static String roman(int i) {
        if (i <= 0 || i > 5000) {
            return "" + i;
        }
        StringBuilder sb = new StringBuilder();
        if (i >= 1000) {
            do {
                sb.append("M");
            } while ((i -= 1000) >= 1000);
        }
        if (i >= 900) {
            i -= Utils.r(sb, "CM", 900);
        }
        if (i >= 500) {
            i -= Utils.r(sb, "D", 500);
        }
        if (i >= 400) {
            i -= Utils.r(sb, "CD", 400);
        }
        if (i >= 100) {
            do {
                sb.append("C");
            } while ((i -= 100) >= 100);
        }
        if (i >= 90) {
            i -= Utils.r(sb, "XC", 90);
        }
        if (i >= 50) {
            i -= Utils.r(sb, "L", 50);
        }
        if (i >= 40) {
            i -= Utils.r(sb, "XL", 40);
        }
        if (i >= 10) {
            do {
                sb.append("X");
            } while ((i -= 10) >= 10);
        }
        if (i >= 9) {
            i -= Utils.r(sb, "IX", 9);
        }
        if (i >= 5) {
            i -= Utils.r(sb, "V", 5);
        }
        if (i >= 4) {
            i -= Utils.r(sb, "IV", 4);
        }
        if (i >= 1) {
            do {
                sb.append("I");
            } while (--i >= 1);
        }
        return sb.toString();
    }

    private static int r(StringBuilder sb, String s, int i) {
        sb.append(s);
        return i;
    }

    public static String displayName(ItemStack item) {
        Class<?> c = Reflections.RF.craft("inventory.CraftItemStack");
        try {
            Method m = c.getMethod("asNMSCopy", ItemStack.class);
            Object o = m.invoke(null, item);
            c = o.getClass();
            if (Version.version == Version.VersionType.v_18_1) {
                m = c.getDeclaredMethod("v", new Class[0]);
                o = m.invoke(o, new Object[0]);
                m = o.getClass().getMethod("a", new Class[0]);
            } else if (Version.version == Version.VersionType.v_18_2) {
                m = c.getDeclaredMethod("w", new Class[0]);
                o = m.invoke(o, new Object[0]);
                m = o.getClass().getMethod("a", new Class[0]);
            } else if (Version.version == Version.VersionType.v_19_1 || Version.version == Version.VersionType.v_19_2 || Version.version == Version.VersionType.v_19_3) {
                m = c.getDeclaredMethod("x", new Class[0]);
                o = m.invoke(o, new Object[0]);
                m = o.getClass().getMethod("getString", new Class[0]);
            } else {
                m = c.getDeclaredMethod("getName", new Class[0]);
                o = m.invoke(o, new Object[0]);
                m = o.getClass().getMethod("getText", new Class[0]);
            }
            String name = (String)m.invoke(o, new Object[0]);
            if (name == null || name.isEmpty()) {
                m = o.getClass().getMethod("getString", new Class[0]);
                name = (String)m.invoke(o, new Object[0]);
            }
            return name;
        }
        catch (Exception e) {
            return "null";
        }
    }

    public static void hideCustomFlags(ItemMeta meta) {
        try {
            Class<?> craft_meta_class = Reflections.RF.craft("inventory.CraftMetaItem");
            Object craft_meta = craft_meta_class.cast(meta);
            if (!meta.getClass().equals(craft_meta_class)) {
                return;
            }
            Reflections.RF.Accessor<Integer> a = Reflections.RF.access(craft_meta, "hideFlag", Integer.TYPE);
            int h = a.field(0);
            a.set(h | 0x40 | 0x80);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double round(double d) {
        int i = (int)(d * 100.0);
        return (double)i / 100.0;
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInteger(String ... l) {
        if (l == null) {
            return false;
        }
        String[] stringArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!Utils.isInteger(s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean nulled(ItemStack item) {
        return item == null ? true : item.getType() == Material.AIR;
    }

    public static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isValid(String s) {
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Utils.isLetter(c) && !Utils.isNumber(c) && c != '_' && c != '.') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean chance(double chance) {
        return R.nextDouble() * 100.0 < chance;
    }

    public static int random(int r) {
        return R.nextInt(r);
    }

    public static <E> E random(List<E> list) {
        return list.get(R.nextInt(list.size()));
    }

    public static void check(final int id, final Consumer<String> action) {
        new BukkitRunnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try {
                        InputStream is = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + id).openStream();
                        try {
                            try (Scanner sc = new Scanner(is);){
                                if (sc.hasNext()) {
                                    action.accept(sc.next());
                                }
                            }
                            if (is == null) return;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (is == null) throw throwable;
                            is.close();
                            throw throwable;
                        }
                        is.close();
                        return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.runTaskLaterAsynchronously((Plugin)SpawnerMeta.instance(), 50L);
    }
}

