/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.utils.Version;

public final class Reflections {

    public static final class RF {
        private static final Invoker<?> I_NULL = o -> null;
        private static final Construct<?> C_NULL = o -> null;
        private static final Accessor<?> null_accessor = () -> null;

        public static void debug(Exception x) {
            if (Settings.settings.debug) {
                x.printStackTrace();
            }
        }

        public static Class<?> craft(String s) {
            try {
                return Class.forName("org.bukkit.craftbukkit." + Version.server + "." + s);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public static Class<?> nms(String s) {
            try {
                return Class.forName("net.minecraft.server." + Version.server + "." + s);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public static Class<?> get(String s) {
            try {
                return Class.forName(s);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public static <E extends Enum<E>> E enumerate(Class<E> c, String name) {
            return RF.enumerate(c, name, null);
        }

        public static <E extends Enum<E>> E enumerate(Class<E> c, String name, E e) {
            try {
                return Enum.valueOf(c, name);
            }
            catch (Exception exception) {
                return e;
            }
        }

        public static <E extends Enum<E>> E enumerates(Class<E> c, String ... names) {
            return (E)((Enum)Stream.of(names).map(name -> RF.enumerate(c, name)).filter(e -> e != null).findFirst().orElse(null));
        }

        public static <E extends Enum<E>> List<E> enumerate(Class<E> c, List<String> names) {
            return names.stream().map(name -> RF.enumerate(c, name)).filter(e -> e != null).collect(Collectors.toList());
        }

        public static Invoker<?> order(Object o, String m, Class<?> ... cs) {
            try {
                Method method = o.getClass().getMethod(m, cs);
                return os -> {
                    try {
                        return method.invoke(o, os);
                    }
                    catch (Exception e) {
                        RF.debug(e);
                        return null;
                    }
                };
            }
            catch (Exception e) {
                RF.debug(e);
                return I_NULL;
            }
        }

        public static Invoker<?> order(Class<?> c, String m, Class<?> ... cs) {
            try {
                Method method = c.getMethod(m, cs);
                return os -> {
                    try {
                        return method.invoke(null, os);
                    }
                    catch (Exception e) {
                        RF.debug(e);
                        return null;
                    }
                };
            }
            catch (Exception e) {
                RF.debug(e);
                return I_NULL;
            }
        }

        public static <R> Invoker<R> order(Object o, Class<R> cr, String m, Class<?> ... cs) {
            try {
                Method method = o.getClass().getMethod(m, cs);
                return os -> {
                    try {
                        return method.invoke(o, os);
                    }
                    catch (Exception e) {
                        RF.debug(e);
                        return null;
                    }
                };
            }
            catch (Exception e) {
                RF.debug(e);
                return I_NULL;
            }
        }

        public static <R> Construct<R> construct(Class<R> c, Class<?> ... cs) {
            try {
                Constructor constructor = c.getConstructor(cs);
                return os -> {
                    try {
                        return constructor.newInstance(os);
                    }
                    catch (Exception e) {
                        RF.debug(e);
                        return null;
                    }
                };
            }
            catch (Exception e) {
                RF.debug(e);
                return C_NULL;
            }
        }

        public static <R> Accessor<R> access(Object o, String f, Class<R> r) {
            try {
                Field field = RF.field(o.getClass(), f);
                field.setAccessible(true);
                return RF.of(field, o);
            }
            catch (Exception e) {
                RF.debug(e);
                return null_accessor;
            }
        }

        public static <R> Accessor<R> accessI(Object o, String f, Class<R> r) {
            try {
                Field field = RF.field(o.getClass(), f);
                field.setAccessible(true);
                return RF.ofI(field, o);
            }
            catch (Exception exception) {
                return null_accessor;
            }
        }

        private static Field field(Class<?> c, String n) throws Exception {
            try {
                return c.getField(n);
            }
            catch (Exception e) {
                return c.getDeclaredField(n);
            }
        }

        private static <R> Accessor<R> of(final Field field, final Object o) {
            return new Accessor<R>(){

                @Override
                public R field() {
                    try {
                        field.setAccessible(true);
                        return field.get(o);
                    }
                    catch (Exception e) {
                        RF.debug(e);
                        return null;
                    }
                }

                @Override
                public void set(R r) {
                    try {
                        field.setAccessible(true);
                        field.set(o, r);
                    }
                    catch (Exception e) {
                        RF.debug(e);
                    }
                }
            };
        }

        private static <R> Accessor<R> ofI(final Field field, final Object o) {
            return new Accessor<R>(){

                @Override
                public R field() {
                    try {
                        field.setAccessible(true);
                        return field.get(o);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                @Override
                public void set(R r) {
                    try {
                        field.setAccessible(true);
                        field.set(o, r);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
        }

        @FunctionalInterface
        public static interface Accessor<R> {
            public R field();

            default public R field(R d) {
                R r = this.field();
                return r == null ? d : r;
            }

            default public void set(R r) {
            }

            default public void force(Object o) {
                this.set(o);
            }
        }

        @FunctionalInterface
        public static interface Construct<R> {
            public R instance(Object ... var1);
        }

        @FunctionalInterface
        public static interface Invoker<R> {
            public R invoke(Object ... var1);

            default public R invoke(R d, Object ... os) {
                R r = this.invoke(os);
                return r == null ? d : r;
            }
        }
    }
}

