/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.utils;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public abstract class EntityBox {
    public final int x;
    public final int y;
    public final int z;

    public static EntityBox single() {
        return new EntityBoundsSingle();
    }

    public static EntityBox box(int x, int y, int z) {
        if (x == 1 && y == 1 && z == 1) {
            return EntityBox.single();
        }
        if (x == 1 && y > 1 && z == 1) {
            return new EntityBoundsHigh(y);
        }
        return new EntityBoundsLarge(x, y, z);
    }

    protected EntityBox(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public EntityBox multiply(int a) {
        return a <= 1 ? this : new EntityBoundsLarge(this.x * a, this.y * a, this.z * a);
    }

    public abstract Location check(Block var1, Block var2, boolean var3);

    private static boolean grass(Block block) {
        return switch (block.getType()) {
            case Material.COARSE_DIRT, Material.DIRT, Material.GRASS_BLOCK -> true;
            default -> false;
        };
    }

    private static boolean free(Block block, Block other) {
        Material type = other.getType();
        if (block.getType() == type) {
            return true;
        }
        return !type.isSolid();
    }

    private static class EntityBoundsHigh
    extends EntityBox {
        private EntityBoundsHigh(int y) {
            super(1, y, 1);
        }

        @Override
        public Location check(Block at, Block block, boolean grass) {
            if (grass && !EntityBox.grass(block.getRelative(0, -1, 0))) {
                return null;
            }
            int i = 0;
            do {
                if (EntityBox.free(at, block.getRelative(0, i, 0))) continue;
                return null;
            } while (++i < this.y);
            return block.getLocation().add(0.5, 0.0, 0.5);
        }
    }

    private static class EntityBoundsLarge
    extends EntityBox {
        private EntityBoundsLarge(int x, int y, int z) {
            super(x, y, z);
        }

        @Override
        public Location check(Block at, Block block, boolean grass) {
            int ix = 0;
            do {
                int iy = 0;
                do {
                    int iz = 0;
                    do {
                        Block b = block.getRelative(ix, iy, iz);
                        if (iy == 0 && grass && !EntityBox.grass(block.getRelative(ix, -1, iz))) {
                            return null;
                        }
                        if (EntityBox.free(at, b)) continue;
                        return null;
                    } while (++iz < this.z);
                } while (++iy < this.y);
            } while (++ix < this.x);
            return block.getLocation().add((double)this.x * 0.5, 0.0, (double)this.z * 0.5);
        }
    }

    private static class EntityBoundsSingle
    extends EntityBox {
        private EntityBoundsSingle() {
            super(1, 1, 1);
        }

        @Override
        public Location check(Block at, Block block, boolean grass) {
            if (grass && !EntityBox.grass(block.getRelative(0, -1, 0))) {
                return null;
            }
            if (!EntityBox.free(at, block)) {
                return null;
            }
            return block.getLocation().add(0.5, 0.0, 0.5);
        }
    }
}

