/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.api.spawner.FilledVirtualSpawner;
import mc.rellox.spawnermeta.api.spawner.VirtualSpawner;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.text.content.Content;
import mc.rellox.spawnermeta.text.order.IOrder;
import mc.rellox.spawnermeta.utils.Utils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class DataManager {
    private static NamespacedKey key_empty;
    private static NamespacedKey key_upgrades;
    private static NamespacedKey key_charges;
    private static NamespacedKey key_new;
    private static NamespacedKey key_default;
    private static NamespacedKey key_type;
    private static NamespacedKey key_stack;
    private static NamespacedKey key_attributes;
    private static NamespacedKey key_levels;
    private static NamespacedKey key_spawnable;
    private static NamespacedKey key_placed;
    private static NamespacedKey key_enabled;
    private static NamespacedKey key_owner;
    private static NamespacedKey key_spawned;

    public static void initialize() {
        key_empty = new NamespacedKey((Plugin)SpawnerMeta.instance(), "empty");
        key_upgrades = new NamespacedKey((Plugin)SpawnerMeta.instance(), "upgrades");
        key_charges = new NamespacedKey((Plugin)SpawnerMeta.instance(), "charges");
        key_spawnable = new NamespacedKey((Plugin)SpawnerMeta.instance(), "maximum");
        key_new = new NamespacedKey((Plugin)SpawnerMeta.instance(), "new");
        key_default = new NamespacedKey((Plugin)SpawnerMeta.instance(), "default");
        key_type = new NamespacedKey((Plugin)SpawnerMeta.instance(), "type");
        key_stack = new NamespacedKey((Plugin)SpawnerMeta.instance(), "stack");
        key_attributes = new NamespacedKey((Plugin)SpawnerMeta.instance(), "attributes");
        key_levels = new NamespacedKey((Plugin)SpawnerMeta.instance(), "levels");
        key_spawnable = new NamespacedKey((Plugin)SpawnerMeta.instance(), "maximum");
        key_placed = new NamespacedKey((Plugin)SpawnerMeta.instance(), "placed");
        key_enabled = new NamespacedKey((Plugin)SpawnerMeta.instance(), "enabled");
        key_owner = new NamespacedKey((Plugin)SpawnerMeta.instance(), "owner");
        key_spawned = new NamespacedKey((Plugin)SpawnerMeta.instance(), "spawned");
    }

    public static int[] i() {
        return new int[]{1, 1, 1};
    }

    public static ItemStack getSpawner(VirtualSpawner spawner, int a) {
        return DataManager.getSpawners(spawner.getType(), spawner.getUpgradeLevels(), spawner.getCharges(), spawner.getSpawnable(), a, spawner.isEmpty(), true).get(0);
    }

    public static ItemStack getSpawner(SpawnerType type, int amount) {
        return DataManager.getSpawners(type, DataManager.i(), 0, Settings.settings.spawnable_amount.get(type), amount, false, true).get(0);
    }

    public static List<ItemStack> getSpawners(Block block, boolean ignore) {
        return DataManager.getSpawners(DataManager.getType(block), DataManager.getUpgradeLevels(block), DataManager.getCharges(block), DataManager.getSpawnable(block), DataManager.getStack(block), DataManager.isEmpty(block), ignore);
    }

    public static List<ItemStack> getSpawners(SpawnerType type, int amount, boolean empty, boolean ignore) {
        return DataManager.getSpawners(type, DataManager.i(), 0, Settings.settings.spawnable_amount.get(type), amount, empty, ignore);
    }

    public static List<ItemStack> getSpawners(SpawnerType type, int[] levels, int charges, int spawnable, int amount, boolean empty, boolean ignore) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (type == null) {
            type = SpawnerType.PIG;
        }
        if (empty && !Settings.settings.empty_store_inside) {
            type = SpawnerType.EMPTY;
        }
        if (Settings.settings.spawnable_enabled) {
            if (spawnable <= 0 || amount <= 0) {
                return list;
            }
            if (amount > 1) {
                int e;
                if (ignore) {
                    list.addAll(DataManager.getSpawner(type, levels, charges, spawnable, amount, empty));
                    return list;
                }
                if (amount > spawnable) {
                    amount = spawnable;
                }
                if ((e = spawnable % amount) == 0) {
                    list.addAll(DataManager.getSpawner(type, levels, charges, spawnable / amount, amount, empty));
                } else {
                    int d = spawnable / amount;
                    list.addAll(DataManager.getSpawner(type, levels, charges, d, amount - 1, empty));
                    list.addAll(DataManager.getSpawner(type, levels, charges, e + d, 1, empty));
                }
            } else {
                list.addAll(DataManager.getSpawner(type, levels, charges, spawnable, amount, empty));
            }
        } else {
            list.addAll(DataManager.getSpawner(type, levels, charges, spawnable, amount, empty));
        }
        return list;
    }

    public static List<ItemStack> getSpawner(SpawnerType type, int[] levels, int charges, int spawnable, int amount, boolean empty) {
        ItemStack item = new ItemStack(Material.SPAWNER, 1);
        ItemMeta meta = item.getItemMeta();
        List<Content> name = empty ? (Settings.settings.empty_store_inside && type != SpawnerType.EMPTY ? Language.list("Spawners.item.empty-stored.name", "type", (Object)type) : Language.list("Spawners.item.empty.name")) : Language.list("Spawners.item.regular.name", "type", (Object)type);
        if (name.size() > 0) {
            meta.setDisplayName(name.remove(0).text());
        }
        IOrder order = Settings.settings.order_spawner.oderer();
        order.named(name);
        order.submit("HEADER", () -> Language.list("Spawners.item.header"));
        order.submit("RANGE", () -> Language.list("Spawners.item.upgrade.range", "level", (Object)Utils.roman(levels[0])));
        order.submit("DELAY", () -> Language.list("Spawners.item.upgrade.delay", "level", (Object)Utils.roman(levels[1])));
        order.submit("AMOUNT", () -> Language.list("Spawners.item.upgrade.amount", "level", (Object)Utils.roman(levels[2])));
        if (Settings.settings.charges_enabled) {
            boolean inf = charges >= 1000000000;
            order.submit("CHARGES", () -> Language.list("Spawners.item.charges", "charges", inf ? "\u221e" : Integer.valueOf(charges)));
        }
        if (Settings.settings.spawnable_enabled) {
            order.submit("SPAWNABLE", () -> Language.list("Spawners.item.spawnable", "spawnable", (Object)spawnable));
        }
        meta.setLore(order.build());
        meta.addItemFlags(ItemFlag.values());
        Utils.hideCustomFlags(meta);
        item.setItemMeta(meta);
        DataManager.modify(item, type, levels, charges, spawnable, empty);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(amount + 63 >> 6);
        while (amount > 0) {
            ItemStack clone = item.clone();
            clone.setAmount(amount >= 64 ? 64 : amount);
            list.add(clone);
            amount -= 64;
        }
        return list;
    }

    public static List<ItemStack> getSpawner(SpawnerType type, String values, int amount, boolean empty) {
        if (values == null || values.isEmpty() || !values.contains(";")) {
            return null;
        }
        String[] vs = values.split(";");
        if (vs.length != 5) {
            return null;
        }
        int[] is = new int[5];
        int i = 0;
        while (i < 5) {
            if (i > 2 && vs[i].equals("inf") || vs[i].equals("infinite")) {
                is[i] = 1500000000;
            } else if (vs[i].equals("-")) {
                is[i] = 0;
            } else if (Utils.isInteger(vs[i])) {
                is[i] = Integer.parseInt(vs[i]);
            } else {
                return null;
            }
            ++i;
        }
        int[] ls = Settings.settings.upgrades_levels.get(type);
        i = 0;
        while (i < 3) {
            if (is[i] < 1) {
                is[i] = 1;
            }
            if (is[i] > ls[i]) {
                is[i] = ls[i];
            }
            ++i;
        }
        if (is[3] < 0) {
            is[3] = 0;
        }
        if (is[4] <= 0) {
            is[4] = Settings.settings.spawnable_amount.get(type);
        }
        return DataManager.getSpawner(type, is, is[3], is[4], amount, empty);
    }

    public static void setNewSpawner(Player player, Block block, boolean empty) {
        if (DataManager.getNew(block) == 1) {
            return;
        }
        CreatureSpawner cs = (CreatureSpawner)block.getState();
        SpawnerType type = SpawnerType.of(cs.getSpawnedType());
        if (empty) {
            type = SpawnerType.EMPTY;
        }
        DataManager.setNewSpawner(player, block, type, DataManager.i(), 0, Settings.settings.spawnable_amount.get(type), empty);
    }

    public static void setNewSpawner(Player player, Block block, SpawnerType type, int[] levels, int charges, int spawnable, boolean empty) {
        DataManager.setOwner(block, player);
        DataManager.setNew(block);
        DataManager.setStack(block, 1);
        int[] r = DataManager.attributes(type, levels);
        DataManager.setUpgradeAttributes(block, r);
        DataManager.setUpgradeLevels(block, levels);
        DataManager.setDelayConstant(block, r[1]);
        DataManager.setSpawnable(block, spawnable);
        DataManager.setDefault(block);
        DataManager.setOneCount(block);
        DataManager.setNearbyLimit(block);
        DataManager.setType(block, type);
        DataManager.setEnabled(block, true);
        if (empty) {
            DataManager.setEmpty(block);
        }
        DataManager.setCharges(block, charges);
    }

    public static void updateValues(Block block) {
        SpawnerType type = DataManager.getType(block);
        int[] l = DataManager.getUpgradeLevels(block);
        int[] r = DataManager.attributes(type, l);
        DataManager.setUpgradeAttributes(block, r);
        DataManager.setUpgradeLevels(block, l);
        DataManager.setDelay(block, r[1]);
        DataManager.setDefault(block);
        DataManager.setOneCount(block);
        DataManager.setNearbyLimit(block);
    }

    public static void recalculate(Block block) {
        if (DataManager.getDefault(block) == Settings.settings.spawner_version) {
            return;
        }
        DataManager.updateValues(block);
    }

    public static boolean cancelledByOwner(Block block, Player player) {
        UUID owner = DataManager.getOwner(block);
        return owner != null && !player.getUniqueId().equals(owner);
    }

    private static int[] attributes(SpawnerType type, int[] l) {
        int[] r = Settings.settings.spawner_values.get(type);
        int[] n = Settings.settings.spawner_value_increase.get(type);
        int k = 0;
        while (k < 3) {
            int i = 1;
            while (i < l[k]) {
                int n2 = k;
                r[n2] = r[n2] + n[k];
                ++i;
            }
            ++k;
        }
        return r;
    }

    protected static void updateType(Block block) {
        DataManager.updateType(block, null);
    }

    protected static void updateType(Block block, SpawnerType type) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.setSpawnedType((type == null ? DataManager.getType(block) : type).entity());
        cs.update();
    }

    public static void modify(ItemStack item, SpawnerType type, int[] levels, int charges, int spawnable, boolean empty) {
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer p = meta.getPersistentDataContainer();
        p.set(key_type, PersistentDataType.STRING, (Object)type.name());
        p.set(key_upgrades, PersistentDataType.INTEGER_ARRAY, (Object)Arrays.copyOf(levels, 3));
        p.set(key_charges, PersistentDataType.INTEGER, (Object)charges);
        p.set(key_spawnable, PersistentDataType.INTEGER, (Object)spawnable);
        if (empty) {
            p.set(key_empty, PersistentDataType.INTEGER, (Object)1);
        }
        item.setItemMeta(meta);
    }

    /*
     * WARNING - void declaration
     */
    public static VirtualSpawner getSpawnerItem(ItemStack item) {
        int[] levels;
        void cs;
        CreatureSpawner creatureSpawner;
        void bsm;
        BlockStateMeta blockStateMeta;
        ItemMeta itemMeta;
        if (item == null || item.getType() != Material.SPAWNER) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer p = meta.getPersistentDataContainer();
        SpawnerType type = p.has(key_type, PersistentDataType.STRING) ? SpawnerType.of((String)p.get(key_type, PersistentDataType.STRING)) : ((itemMeta = meta) instanceof BlockStateMeta && (blockStateMeta = (BlockStateMeta)itemMeta) == (BlockStateMeta)itemMeta ? (( instanceOfPatternExpressionValue = bsm.getBlockState()) instanceof CreatureSpawner && (creatureSpawner = (CreatureSpawner) instanceOfPatternExpressionValue) == (CreatureSpawner) instanceOfPatternExpressionValue ? SpawnerType.of(cs.getSpawnedType()) : SpawnerType.PIG) : SpawnerType.PIG);
        if (type == null) {
            type = SpawnerType.PIG;
        }
        if ((levels = (int[])p.getOrDefault(key_upgrades, PersistentDataType.INTEGER_ARRAY, (Object)DataManager.i())).length > 3) {
            levels = Arrays.copyOf(levels, 3);
        }
        int charges = (Integer)p.getOrDefault(key_charges, PersistentDataType.INTEGER, (Object)0);
        int spawnable = (Integer)p.getOrDefault(key_spawnable, PersistentDataType.INTEGER, (Object)0);
        boolean empty = (Integer)p.getOrDefault(key_empty, PersistentDataType.INTEGER, (Object)0) >= 1;
        return new FilledVirtualSpawner(type, levels, charges, spawnable, empty);
    }

    public static VirtualSpawner getSpawnerItem(Block block) {
        if (block == null || block.getType() != Material.SPAWNER) {
            return null;
        }
        return new FilledVirtualSpawner(DataManager.getType(block), DataManager.getUpgradeLevels(block), DataManager.getCharges(block), DataManager.getSpawnable(block), DataManager.isEmpty(block));
    }

    public static void setNew(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.getPersistentDataContainer().set(key_new, PersistentDataType.INTEGER, (Object)1);
        cs.update();
    }

    public static int getNew(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return 0;
        }
        return (Integer)cs.getPersistentDataContainer().getOrDefault(key_new, PersistentDataType.INTEGER, (Object)0);
    }

    public static void setEnabled(Block block, boolean b) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.getPersistentDataContainer().set(key_enabled, PersistentDataType.INTEGER, (Object)(b ? 1 : 0));
        cs.update();
    }

    public static boolean isEnabled(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return false;
        }
        return (Integer)cs.getPersistentDataContainer().getOrDefault(key_enabled, PersistentDataType.INTEGER, (Object)1) >= 1;
    }

    public static void setEmpty(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.getPersistentDataContainer().set(key_empty, PersistentDataType.INTEGER, (Object)1);
        cs.update();
    }

    public static boolean isEmpty(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return false;
        }
        return (Integer)cs.getPersistentDataContainer().getOrDefault(key_empty, PersistentDataType.INTEGER, (Object)0) >= 1;
    }

    public static void setSpawned(Entity entity) {
        entity.getPersistentDataContainer().set(key_spawned, PersistentDataType.BYTE, (Object)1);
    }

    public static boolean isSpawned(Entity entity) {
        return (Byte)entity.getPersistentDataContainer().getOrDefault(key_spawned, PersistentDataType.BYTE, (Object)0) > 0;
    }

    private static void setOneCount(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.setSpawnCount(1);
        cs.update();
    }

    private static void setNearbyLimit(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.setMaxNearbyEntities(Settings.settings.nearby_entity_limit);
        cs.update();
    }

    public static boolean isItemSpawner(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return false;
        }
        return cs.getSpawnedType() == EntityType.DROPPED_ITEM;
    }

    public static void setType(Block block, SpawnerType type) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.getPersistentDataContainer().set(key_type, PersistentDataType.STRING, (Object)type.name());
        cs.setSpawnedType(type.entity());
        cs.update();
    }

    public static SpawnerType getType(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return SpawnerType.PIG;
        }
        String st = (String)cs.getPersistentDataContainer().get(key_type, PersistentDataType.STRING);
        SpawnerType type = st == null ? SpawnerType.of(cs.getSpawnedType()) : SpawnerType.of(st);
        return type == null ? SpawnerType.PIG : type;
    }

    public static boolean isEmptyType(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return true;
        }
        String st = (String)cs.getPersistentDataContainer().get(key_type, PersistentDataType.STRING);
        if (st == null || st.equalsIgnoreCase("EMPTY")) {
            return true;
        }
        return cs.getSpawnedType() == EntityType.AREA_EFFECT_CLOUD;
    }

    public static void setStack(Block block, int s) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.getPersistentDataContainer().set(key_stack, PersistentDataType.INTEGER, (Object)s);
        cs.update();
    }

    public static int getStack(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return 1;
        }
        return (Integer)cs.getPersistentDataContainer().getOrDefault(key_stack, PersistentDataType.INTEGER, (Object)1);
    }

    public static void setOwner(Block block, Player player) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null || player == null) {
            return;
        }
        cs.getPersistentDataContainer().set(key_owner, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
        cs.update();
    }

    public static void setOwner(Block block, UUID id) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.getPersistentDataContainer().set(key_owner, PersistentDataType.STRING, (Object)id.toString());
        cs.update();
    }

    public static UUID getOwner(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return null;
        }
        String id = (String)cs.getPersistentDataContainer().get(key_owner, PersistentDataType.STRING);
        if (id == null) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(id);
            return uuid;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getSpawnable(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return 0;
        }
        return (Integer)cs.getPersistentDataContainer().getOrDefault(key_spawnable, PersistentDataType.INTEGER, (Object)0);
    }

    public static void setSpawnable(Block block, int s) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.getPersistentDataContainer().set(key_spawnable, PersistentDataType.INTEGER, (Object)s);
        cs.update();
    }

    public static void setUpgradeAttributes(Block block, int[] s) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.getPersistentDataContainer().set(key_attributes, PersistentDataType.INTEGER_ARRAY, (Object)s);
        if (DataManager.isEnabled(block)) {
            cs.setRequiredPlayerRange(s[0]);
        }
        cs.update();
        DataManager.setDelayConstant(block, s[1] < 1 ? 1 : s[1]);
    }

    public static int[] getUpgradeAttributes(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        SpawnerType type = DataManager.getType(block);
        if (cs == null) {
            return Settings.settings.spawner_values.get(type);
        }
        return (int[])cs.getPersistentDataContainer().getOrDefault(key_attributes, PersistentDataType.INTEGER_ARRAY, (Object)Settings.settings.spawner_values.get(type));
    }

    public static boolean isRotating(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return false;
        }
        return cs.getRequiredPlayerRange() > 0;
    }

    public static void setRotating(Block block, boolean b) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        if (b) {
            int[] is = DataManager.getUpgradeAttributes(block);
            cs.setRequiredPlayerRange(is[0]);
        } else {
            cs.setRequiredPlayerRange(0);
        }
        cs.update();
    }

    public static void setUpgradeLevels(Block block, int[] s) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        if (s.length > 3) {
            s = Arrays.copyOf(s, 3);
        }
        cs.getPersistentDataContainer().set(key_levels, PersistentDataType.INTEGER_ARRAY, (Object)s);
        cs.update();
    }

    public static int[] getUpgradeLevels(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return DataManager.i();
        }
        int[] is = (int[])cs.getPersistentDataContainer().getOrDefault(key_levels, PersistentDataType.INTEGER_ARRAY, (Object)DataManager.i());
        return is.length > 3 ? Arrays.copyOf(is, 3) : is;
    }

    public static int getSpawnerLevel(Block block) {
        int r = 0;
        int i = 0;
        int[] s = DataManager.getUpgradeLevels(block);
        do {
            r += s[i++];
        } while (i < 3);
        return r - 3;
    }

    public static void setPlaced(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.getPersistentDataContainer().set(key_placed, PersistentDataType.INTEGER, (Object)1);
        cs.update();
    }

    public static boolean isPlaced(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return false;
        }
        return (Integer)cs.getPersistentDataContainer().getOrDefault(key_placed, PersistentDataType.INTEGER, (Object)0) != 0;
    }

    public static void resetDelay(Block block) {
        DataManager.setDelay(block, DataManager.getDelay(block));
    }

    public static void setDelayConstant(Block block, int s) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        int min = cs.getMinSpawnDelay();
        int max = cs.getMaxSpawnDelay();
        if (s < 1) {
            s = 1;
        }
        if (s > min && s < max || s < min) {
            cs.setMinSpawnDelay(s);
            cs.setMaxSpawnDelay(s);
        } else {
            cs.setMaxSpawnDelay(s);
            cs.setMinSpawnDelay(s);
        }
        cs.setDelay(s);
        cs.update();
    }

    public static int getDelay(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return 0;
        }
        return cs.getMaxSpawnDelay();
    }

    public static void setDelay(Block block, int s) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.setDelay(s);
        cs.update();
    }

    public static int getDefault(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return 0;
        }
        return (Integer)cs.getPersistentDataContainer().getOrDefault(key_default, PersistentDataType.INTEGER, (Object)0);
    }

    public static void setDefault(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return;
        }
        cs.getPersistentDataContainer().set(key_default, PersistentDataType.INTEGER, (Object)Settings.settings.spawner_version);
        cs.update();
    }

    public static void setCharges(Block block, int c) {
        CreatureSpawner cs;
        if (c < 0) {
            c = 0;
        }
        if ((cs = DataManager.cast(block)) == null) {
            return;
        }
        PersistentDataContainer p = cs.getPersistentDataContainer();
        p.set(key_charges, PersistentDataType.INTEGER, (Object)c);
        cs.update();
    }

    public static int getCharges(Block block) {
        CreatureSpawner cs = DataManager.cast(block);
        if (cs == null) {
            return 0;
        }
        return cs == null ? 0 : (Integer)cs.getPersistentDataContainer().getOrDefault(key_charges, PersistentDataType.INTEGER, (Object)0);
    }

    /*
     * WARNING - void declaration
     */
    private static CreatureSpawner cast(Block block) {
        void cs;
        void var2_1;
        CreatureSpawner creatureSpawner;
        BlockState blockState = block.getState();
        return blockState instanceof CreatureSpawner && (creatureSpawner = (CreatureSpawner)blockState) == (CreatureSpawner)var2_1 ? cs : null;
    }
}

