/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.text.order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mc.rellox.spawnermeta.text.Text;
import mc.rellox.spawnermeta.text.content.Content;
import mc.rellox.spawnermeta.text.order.OrderList;

public interface IOrder {
    public void submit(String var1, Supplier<List<Content>> var2);

    public List<String> build();

    public void named(List<Content> var1);

    public static class Orderer
    implements IOrder {
        private final OrderList list;
        private final Map<String, Supplier<List<Content>>> map;

        public Orderer(OrderList list) {
            this.list = list;
            this.map = new HashMap<String, Supplier<List<Content>>>();
        }

        @Override
        public void submit(String key, Supplier<List<Content>> supplier) {
            this.map.put(key, supplier);
        }

        @Override
        public void named(List<Content> name) {
            if (name.isEmpty()) {
                return;
            }
            this.map.put("NAMED", () -> name);
        }

        @Override
        public List<String> build() {
            ArrayList<String> build = new ArrayList<String>();
            this.list.keys().forEach(key -> {
                if (key.equals("!")) {
                    build.add("");
                } else {
                    Supplier<List<Content>> supplier = this.map.get(key);
                    if (supplier == null) {
                        return;
                    }
                    List<Content> contents = supplier.get();
                    if (contents == null || contents.isEmpty()) {
                        return;
                    }
                    List<String> text = Text.toText(contents);
                    if (text.isEmpty()) {
                        return;
                    }
                    build.addAll(text);
                }
            });
            Text.clean(build);
            return build;
        }
    }
}

