/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.text.content;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mc.rellox.spawnermeta.text.content.Colorer;
import mc.rellox.spawnermeta.text.content.Content;
import mc.rellox.spawnermeta.text.content.Format;

public final class ContentParser {
    protected static final Pattern colors = Pattern.compile("<(?:(?:#[a-f\\d]{6}(?:-#[a-f\\d]{6})*)|(?:![a-z]+))>", 2);
    protected static final Pattern variables = Pattern.compile("%[a-z_]+%", 2);
    private final String text;

    public static Content parse(String text) {
        return text == null || text.isEmpty() ? Content.empty() : new ContentParser(text).parse();
    }

    public static List<Content> parse(List<String> list) {
        return list == null || list.isEmpty() ? List.of() : list.stream().map(ContentParser::parse).collect(Collectors.toList());
    }

    private ContentParser(String text) {
        this.text = text;
    }

    public Content parse() {
        if (this.text == null || this.text.isEmpty()) {
            return Content.empty();
        }
        List<Text> list = this.text();
        ArrayList<Content> result = new ArrayList<Content>();
        ContentBuilder builder = new ContentBuilder();
        for (Text t : list) {
            if (t.type == Type.text) {
                Content input = this.variabled(t.text);
                result.add(builder.build(input));
                builder.reset();
                continue;
            }
            if (t.type == Type.color) {
                builder.color(t.text);
                continue;
            }
            if (t.type == Type.gradient) {
                builder.gradient(t.text);
                continue;
            }
            builder.format(t.text);
        }
        return result.isEmpty() ? Content.empty() : (result.size() == 1 ? (Content)result.get(0) : Content.of(result));
    }

    private List<Text> text() {
        ArrayList<Text> list = new ArrayList<Text>();
        Matcher m = colors.matcher(this.text);
        int e = 0;
        while (m.find()) {
            int s = m.start();
            if (s > e) {
                list.add(new Text(this.text.substring(e, s), Type.text));
            }
            e = m.end();
            String t = m.group();
            String g = t.substring(1, t.length() - 1);
            if (g.indexOf(45) >= 0) {
                list.add(new Text(g, Type.gradient));
                continue;
            }
            if (g.indexOf(33) == 0) {
                list.add(new Text(g, Type.format));
                continue;
            }
            if (g.indexOf(35) == 0) {
                list.add(new Text(g, Type.color));
                continue;
            }
            list.add(new Text(t, Type.text));
        }
        if (e < this.text.length()) {
            list.add(new Text(this.text.substring(e), Type.text));
        }
        return list;
    }

    private Content variabled(String t) {
        if (t.isEmpty()) {
            return Content.empty();
        }
        ArrayList<Content> list = new ArrayList<Content>();
        Matcher m = variables.matcher(t);
        int e = 0;
        while (m.find()) {
            int s = m.start();
            if (s > e) {
                list.add(Content.of(t.substring(e, s)));
            }
            e = m.end();
            String g = m.group();
            list.add(Content.of(Content.Variable.of(g.substring(1, g.length() - 1))));
        }
        if (e < t.length()) {
            list.add(Content.of(t.substring(e)));
        }
        return list.size() == 1 ? (Content)list.get(0) : Content.of(list);
    }

    private class ContentBuilder {
        private int[] is;
        private final List<Format> fs = new ArrayList<Format>();

        private ContentBuilder() {
        }

        private void reset() {
            this.is = null;
            this.fs.clear();
        }

        private void color(String s) {
            try {
                this.is = new int[]{Integer.parseInt(s.substring(1), 16)};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void gradient(String s) {
            try {
                this.is = Stream.of(s.split("-")).mapToInt(t -> Integer.parseInt(t.substring(1), 16)).toArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void format(String s) {
            Format f;
            switch (s.substring(1)) {
                case "b": 
                case "bold": {
                    Format format = Format.bold;
                    break;
                }
                case "italic": 
                case "i": {
                    Format format = Format.italic;
                    break;
                }
                case "o": 
                case "obfuscated": {
                    Format format = Format.obfuscated;
                    break;
                }
                case "strikethrough": 
                case "s": {
                    Format format = Format.strikethrough;
                    break;
                }
                case "underline": 
                case "u": {
                    Format format = Format.underline;
                    break;
                }
                default: {
                    Format format = f = null;
                }
            }
            if (f != null) {
                this.fs.add(f);
            }
        }

        private Content build(Content input) {
            Colorer color = this.is != null ? (this.is.length == 1 ? (this.fs.isEmpty() ? Colorer.of(this.is[0]) : Colorer.of(this.is[0], Format.of(this.fs))) : (this.fs.isEmpty() ? Colorer.of(Colorer.Colors.of(this.is)) : Colorer.of(Colorer.Colors.of(this.is), Format.of(this.fs)))) : (!this.fs.isEmpty() ? Colorer.of(0xFFFFFF, Format.of(this.fs)) : null);
            return color == null ? input : Content.of(color, input);
        }
    }

    private record Text(String text, Type type) {
    }

    private static enum Type {
        text,
        color,
        gradient,
        format;

    }
}

