/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.text.content;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mc.rellox.spawnermeta.prices.Price;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.text.content.Colorer;
import mc.rellox.spawnermeta.text.content.Format;

public interface Content {
    public static Content empty() {
        return EmptyContent.empty;
    }

    public static Content empty(int e) {
        String m = " ".repeat(e);
        return Content.wrap(v -> m);
    }

    public static Content of(List<Content> list) {
        return Content.wrap(v -> list.stream().map(c -> c.text(v)).collect(Collectors.joining()));
    }

    public static Content of(Content ... cs) {
        return Content.wrap(v -> Stream.of(cs).map(c -> c.text(v)).collect(Collectors.joining()));
    }

    public static Content of(Colorer colorer, Content content) {
        return new ContentText(colorer, content);
    }

    public static Content of(String text) {
        return Content.wrap(v -> text);
    }

    public static Content of(Variable variable) {
        return new ContentVariable(variable.key);
    }

    public static Content of(int rgb, Object o) {
        return Content.of(Colorer.of(rgb), Content.of(o.toString()));
    }

    public static Content of(int rgb, String text) {
        return Content.of(Colorer.of(rgb), Content.of(text));
    }

    public static Content of(int rgb, Format format, String text) {
        return Content.of(Colorer.of(rgb, format), Content.of(text));
    }

    public static Content of(String text, int ... rgb) {
        return Content.of(Colorer.of(Colorer.Colors.of(rgb)), Content.of(text));
    }

    public static Content of(String text, Format format, int ... rgb) {
        return Content.of(Colorer.of(Colorer.Colors.of(rgb), format), Content.of(text));
    }

    public static Content of(int rgb0, String t0, int rgb1, String t1) {
        return Content.of(Content.of(rgb0, t0), Content.of(rgb1, t1));
    }

    public static Content of(int rgb0, String t0, int rgb1, String t1, int rgb2, String t2) {
        return Content.of(Content.of(rgb0, t0), Content.of(rgb1, t1), Content.of(rgb2, t2));
    }

    private static Content wrap(Content content) {
        return new WrappedContent(content);
    }

    public String text(Variables var1);

    default public String text() {
        return this.text(Variables.empty);
    }

    default public Content modified(Variables variables) {
        return Content.wrap(v -> this.text(variables));
    }

    public record ContentText(Colorer colorer, Content content) implements Content
    {
        @Override
        public String text(Variables variables) {
            return this.colorer.color(this.content.text(variables));
        }

        @Override
        public String toString() {
            return this.text();
        }
    }

    public record ContentVariable(String key) implements Content
    {
        @Override
        public String text(Variables variables) {
            return variables.get(this.key);
        }

        @Override
        public String toString() {
            return this.text();
        }
    }

    public static class EmptyContent
    implements Content {
        private static final EmptyContent empty = new EmptyContent();

        @Override
        public String text(Variables variables) {
            return "";
        }

        public String toString() {
            return "";
        }
    }

    public record Variable(String key) {
        public static Variable of(String key) {
            return new Variable(key);
        }
    }

    @FunctionalInterface
    public static interface Variables {
        public static final Variables empty = k -> k;

        public static Variables with(String k, Object o) {
            return v -> v.equals(k) ? Variables.convert(o) : v;
        }

        public static Variables with(Object ... vs) {
            if (vs.length == 2) {
                return v -> v.equals(vs[0]) ? Variables.convert(vs[1]) : v;
            }
            return v -> {
                int i = 0;
                int m = vs.length;
                do {
                    if (!v.equals(vs[i])) continue;
                    return Variables.convert(vs[i + 1]);
                } while ((i += 2) < m);
                return v;
            };
        }

        public String get(String var1);

        private static String convert(Object o) {
            Object object = o;
            if (object instanceof Content && (var1_2 = (Content)object) == (Content)var2_1) {
                return c.text();
            }
            if (o instanceof SpawnerType var3_4) {
                return s.formated().text();
            }
            if (o instanceof Price var5_6) {
                return p.text().text();
            }
            return o.toString();
        }
    }

    public record WrappedContent(Content content) implements Content
    {
        @Override
        public String text(Variables variables) {
            return this.content.text(variables);
        }

        @Override
        public String toString() {
            return this.text();
        }
    }
}

