/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.text.content;

import mc.rellox.spawnermeta.text.Text;
import mc.rellox.spawnermeta.text.content.Format;

public interface Colorer {
    public static Colorer of(int rgb) {
        return new ColorerRegular(rgb, Format.none);
    }

    public static Colorer of(int rgb, Format format) {
        return new ColorerRegular(rgb, format);
    }

    public static Colorer of(Colors colors) {
        return new Gradient(colors.rgb);
    }

    public static Colorer of(Colors colors, Format format) {
        return new GradientFormatted(colors.rgb, format);
    }

    public static Colorer reset() {
        return text -> "\u00a7r" + text;
    }

    public String color(String var1);

    public static class ColorerRegular
    implements Colorer {
        private final String color;
        private final Format format;

        public ColorerRegular(int rgb, Format format) {
            this.color = Text.color(rgb);
            this.format = format;
        }

        @Override
        public String color(String text) {
            return String.valueOf(this.color) + this.format + text;
        }
    }

    public record Colors(int[] rgb) {
        public static final int red = 0xFF0000;
        public static final int red_50 = 0x800000;
        public static final int green = 65280;
        public static final int green_50 = 32768;
        public static final int blue = 255;
        public static final int blue_50 = 128;
        public static final int yellow = 0xFFFF00;
        public static final int purple = 0xFF00FF;
        public static final int purple_50 = 0x800080;
        public static final int orange = 0xFF8000;
        public static final int aqua = 65535;
        public static final int aqua_50 = 32896;
        public static final int mint = 65408;
        public static final int mint_50 = 32832;
        public static final int lime = 0x80FF00;
        public static final int gray_75 = 0xC4C4C4;
        public static final int gray_50 = 0x808080;
        public static final int gray_25 = 0x404040;
        public static final int white = 0xFFFFFF;

        public static Colors of(int ... rgb) {
            return new Colors(rgb);
        }
    }

    public static class Gradient
    implements Colorer {
        protected final int[] rgb;

        public Gradient(int[] rgb) {
            this.rgb = rgb;
        }

        @Override
        public String color(String text) {
            StringBuilder sb = new StringBuilder();
            int l = text.length();
            double v = 1.0 / (double)(l - 1);
            int i = 0;
            while (i < l) {
                sb.append(Text.color(this.merge(v * (double)i, this.rgb))).append(text.charAt(i));
                ++i;
            }
            return sb.toString();
        }

        protected int merge(double r, int ... os) {
            if (r <= 0.0) {
                return os[0];
            }
            if (r >= 1.0) {
                return os[os.length - 1];
            }
            int l = os.length - 1;
            int m = (int)(r *= (double)l);
            int a = os[m];
            int b = os[m + 1];
            double i = 1.0 - (r -= (double)m);
            int[] as = new int[]{a & 0xFF, a >> 8 & 0xFF, a >> 16 & 0xFF, b & 0xFF, b >> 8 & 0xFF, b >> 16 & 0xFF};
            int[] cs = new int[]{(int)((double)as[0] * i + (double)as[3] * r), (int)((double)as[1] * i + (double)as[4] * r), (int)((double)as[2] * i + (double)as[5] * r)};
            return cs[0] | cs[1] << 8 | cs[2] << 16;
        }
    }

    public static class GradientFormatted
    extends Gradient {
        private final Format format;

        public GradientFormatted(int[] rgb, Format format) {
            super(rgb);
            this.format = format;
        }

        @Override
        public String color(String text) {
            StringBuilder sb = new StringBuilder();
            int l = text.length();
            double v = 1.0 / (double)(l - 1);
            int i = 0;
            while (i < l) {
                sb.append(Text.color(this.merge(v * (double)i, this.rgb))).append(this.format.toString()).append(text.charAt(i));
                ++i;
            }
            return sb.toString();
        }
    }
}

