/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.text;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import mc.rellox.spawnermeta.text.content.Content;

public final class Text {
    public static final String infinity = "\u221e";

    public static List<String> toText(List<Content> list) {
        return list.stream().map(Content::text).collect(Collectors.toList());
    }

    public static String color(String hex) {
        String s = "\u00a7x";
        char[] cArray = hex.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            s = String.valueOf(s) + "\u00a7" + c;
            ++n2;
        }
        return s;
    }

    public static String color(int rgb) {
        return Text.color(String.format("%06x", rgb));
    }

    public static void clean(List<String> list) {
        int last;
        boolean n = false;
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            if (it.next().isEmpty()) {
                if (n) {
                    it.remove();
                }
                n = true;
                continue;
            }
            n = false;
        }
        if (!list.isEmpty() && list.get(last = list.size() - 1).isEmpty()) {
            list.remove(last);
        }
    }

    public static List<String> fromLegacy(List<String> list) {
        return list.stream().map(Text::fromLegacy).collect(Collectors.toList());
    }

    public static String fromLegacy(String s) {
        StringBuilder sb = new StringBuilder();
        boolean l = false;
        boolean h = false;
        boolean i = false;
        String x = "";
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '<') {
                i = true;
            } else if (c == '&') {
                l = true;
            } else if (c == '#') {
                h = true;
            } else if (l) {
                String o = switch (c) {
                    case 'a' -> "<#00ff00>";
                    case 'b' -> "<#00ffff>";
                    case 'c' -> "<#ff0000>";
                    case 'd' -> "<#ff00ff>";
                    case 'e' -> "<#ffff00>";
                    case 'f' -> "<#ffffff>";
                    case '1' -> "<#000080>";
                    case '2' -> "<#008000>";
                    case '3' -> "<#008080>";
                    case '4' -> "<#800000>";
                    case '5' -> "<#800080>";
                    case '6' -> "<#ff8000>";
                    case '7' -> "<#c4c4c4>";
                    case '8' -> "<#595959>";
                    case '9' -> "<#0000ff>";
                    case '0' -> "<#000000>";
                    case 'k' -> "<!obfuscated>";
                    case 'l' -> "<!bold>";
                    case 'm' -> "<!strikethrough>";
                    case 'n' -> "<!underline>";
                    case 'o' -> "<!italic>";
                    default -> "";
                };
                sb.append(o);
                l = false;
            } else if (h) {
                if ((x = String.valueOf(x) + c).length() >= 6) {
                    sb.append("<#").append(x).append('>');
                    x = "";
                    h = false;
                }
            } else {
                sb.append(c);
            }
            if (i && l || h) {
                return s;
            }
            i = false;
            ++n2;
        }
        return sb.toString();
    }
}

