/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.spawner;

import java.util.ArrayList;
import java.util.List;
import mc.rellox.spawnermeta.utils.EntityBox;
import mc.rellox.spawnermeta.utils.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public interface SpawnerSpawning {
    public void set(Block var1, Block var2, EntityBox var3);

    public Location get();

    public void clear();

    public static enum SpawningType {
        SINGLE{

            @Override
            public SpawnerSpawning spread(final int r) {
                return new SpawnerSpawning(){
                    Location loc;

                    @Override
                    public void set(Block block, Block at, EntityBox box) {
                        boolean g = at.getRelative(0, -1, 0).getType() == Material.GRASS_BLOCK;
                        ArrayList<Location> list = new ArrayList<Location>();
                        int i = -r;
                        while (i <= r) {
                            int j = -r;
                            while (j <= r) {
                                int k = -r;
                                while (k <= r) {
                                    Block b = block.getRelative(i, j, k);
                                    Location l = box.check(at, b, g);
                                    if (l != null) {
                                        list.add(l);
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        this.loc = list.isEmpty() ? at.getLocation().add(0.5, 0.0, 0.5) : (Location)Utils.random(list);
                    }

                    @Override
                    public Location get() {
                        return this.loc;
                    }

                    @Override
                    public void clear() {
                        this.loc = null;
                    }
                };
            }
        }
        ,
        SPREAD{

            @Override
            public SpawnerSpawning spread(final int r) {
                return new SpawnerSpawning(){
                    final List<Location> list = new ArrayList<Location>();
                    Block at;

                    @Override
                    public void set(Block block, Block at, EntityBox box) {
                        this.at = at;
                        boolean g = at.getRelative(0, -1, 0).getType() == Material.GRASS_BLOCK;
                        int i = -r;
                        while (i <= r) {
                            int j = -r;
                            while (j <= r) {
                                int k = -r;
                                while (k <= r) {
                                    Block b = block.getRelative(i, j, k);
                                    Location l = box.check(at, b, g);
                                    if (l != null) {
                                        this.list.add(l);
                                    }
                                    ++k;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }

                    @Override
                    public Location get() {
                        return this.list.isEmpty() ? this.at.getLocation().add(0.5, 0.0, 0.5) : Utils.random(this.list);
                    }

                    @Override
                    public void clear() {
                        this.list.clear();
                    }
                };
            }
        };


        public abstract SpawnerSpawning spread(int var1);

        public static SpawningType of(String name) {
            try {
                return SpawningType.valueOf(name.toUpperCase());
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

