/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.shop;

import java.util.LinkedList;
import java.util.List;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.shop.PrivateSell;
import mc.rellox.spawnermeta.shop.SellGroup;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;

public class SpawnerShopSell
implements Listener {
    protected final SellGroup group;
    private final List<PrivateSell> list;

    public SpawnerShopSell(SellGroup group) {
        this.group = group;
        this.list = new LinkedList<PrivateSell>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SpawnerMeta.instance());
    }

    public void open(Player player) {
        if (!player.hasPermission("spawnermeta.shop.sell.open")) {
            player.sendMessage(Language.get("Inventory.sell-shop.permission.opening").text());
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        PrivateSell p = new PrivateSell(player, this);
        p.open();
        this.list.add(p);
    }

    protected void remove(Player player) {
        this.list.removeIf(p -> p.player.equals(player));
    }

    @EventHandler
    private void onClick(InventoryClickEvent event) {
        try {
            for (PrivateSell p : this.list) {
                if (!p.click(event)) continue;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler
    private void onClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        this.list.removeIf(p -> p.close(player));
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }
}

