/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.shop;

import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.prices.Group;
import mc.rellox.spawnermeta.prices.Price;
import mc.rellox.spawnermeta.shop.BuyData;
import mc.rellox.spawnermeta.shop.ShopRegistry;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class SpawnerShopBuy
implements Listener {
    private final BuyData[] data;
    private final boolean[] bs;
    private final Inventory[] vs;
    private final int r0;
    private final int r1;

    public SpawnerShopBuy(Material filler, int rows, boolean[] bs, BuyData ... data) {
        this.r1 = rows * 9;
        this.r0 = this.r1 - 9;
        this.data = data;
        this.bs = bs;
        int l = data.length;
        int i = l > this.r1 ? l / this.r0 + 1 : 1;
        this.vs = new Inventory[i];
        i = 0;
        while (i < this.vs.length) {
            this.vs[i] = Bukkit.createInventory(null, (int)this.r1, (String)Language.get("Inventory.buy-shop.name", "page_current", i + 1, "page_total", this.vs.length).text());
            ++i;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SpawnerMeta.instance());
        this.update(filler);
    }

    private void update(Material filler) {
        int k = 0;
        ItemStack x = this.x(filler);
        if (this.vs.length == 1) {
            int i = 0;
            while (i < this.r1) {
                this.vs[0].setItem(i, x);
                ++i;
            }
            do {
                this.vs[0].setItem(k, this.data[k].info(this.bs));
            } while (++k < this.data.length);
        } else {
            int p = 0;
            Inventory[] inventoryArray = this.vs;
            int n = this.vs.length;
            int n2 = 0;
            while (n2 < n) {
                Inventory v = inventoryArray[n2];
                int i = 0;
                while (i < this.r1) {
                    v.setItem(i, x);
                    ++i;
                }
                int m = Math.min(k + this.r0, this.data.length);
                int r = this.r0 * p;
                do {
                    v.setItem(k - r, this.data[k].info(this.bs));
                } while (++k < m);
                if (this.vs.length > 1) {
                    if (p < this.vs.length - 1) {
                        v.setItem(v.getSize() - 1, this.next());
                    }
                    if (p > 0) {
                        v.setItem(v.getSize() - 9, this.previous());
                    }
                    v.setItem(v.getSize() - 5, this.page(p + 1));
                }
                ++p;
                ++n2;
            }
        }
    }

    public void open(Player player) {
        this.open(player, 0);
    }

    private void open(Player player, int i) {
        if (!player.hasPermission("spawnermeta.shop.buy.open")) {
            player.sendMessage(Language.get("Inventory.buy-shop.permission.opening").text());
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (i >= this.vs.length) {
            return;
        }
        player.openInventory(this.vs[i]);
        player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 2.0f, 2.0f);
    }

    @EventHandler
    private void onClick(InventoryClickEvent event) {
        try {
            Inventory c = event.getClickedInventory();
            if (c == null) {
                return;
            }
            int p = 0;
            Inventory[] inventoryArray = this.vs;
            int n = this.vs.length;
            int n2 = 0;
            while (n2 < n) {
                Inventory v = inventoryArray[n2];
                if (!v.equals(c)) {
                    ++p;
                } else {
                    event.setCancelled(true);
                    Player player = (Player)event.getWhoClicked();
                    int s = event.getSlot();
                    int o = s + p * this.r0;
                    if (s < (this.vs.length > 1 ? this.r0 : this.r1) && o < this.data.length) {
                        if (!player.hasPermission("spawnermeta.shop.buy.purchase")) {
                            player.sendMessage(Language.get("Inventory.buy-shop.permission.purchase").text());
                            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
                            return;
                        }
                        BuyData sd = this.data[o];
                        if (sd == null) {
                            return;
                        }
                        if (!ShopRegistry.canBuy(player, sd.type())) {
                            player.sendMessage(Language.get("Inventory.buy-shop.permission.purchase").text());
                            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
                            return;
                        }
                        ClickType click = event.getClick();
                        if (click == ClickType.SHIFT_LEFT) {
                            if (!this.bs[2]) {
                                return;
                            }
                            sd.buy(player, 16);
                        } else if (click == ClickType.SHIFT_RIGHT) {
                            if (!this.bs[3]) {
                                return;
                            }
                            int b = Price.of(Group.shop, 0).balance(player);
                            int a = b / sd.value();
                            if (a <= 0) {
                                return;
                            }
                            sd.buy(player, a);
                        } else if (click == ClickType.LEFT) {
                            if (!this.bs[0]) {
                                return;
                            }
                            sd.buy(player, 1);
                        } else if (click == ClickType.RIGHT) {
                            if (!this.bs[1]) {
                                return;
                            }
                            sd.buy(player, 4);
                        }
                    } else if (s == v.getSize() - 9 && p > 0) {
                        this.open(player, p - 1);
                    } else if (s == v.getSize() - 1 && p < this.vs.length - 1) {
                        this.open(player, p + 1);
                    }
                    return;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ItemStack next() {
        ItemStack item = new ItemStack(Material.SPECTRAL_ARROW);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.buy-shop.items.page.next").text());
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack page(int p) {
        ItemStack item = new ItemStack(Material.PAPER, p);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.buy-shop.items.page.current", "page", (Object)p).text());
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack previous() {
        ItemStack item = new ItemStack(Material.SPECTRAL_ARROW);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.buy-shop.items.page.previous").text());
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack x(Material m) {
        ItemStack item = new ItemStack(m);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(" ");
        item.setItemMeta(meta);
        return item;
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }
}

