/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.shop;

import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.shop.SpawnerShopBuy;
import mc.rellox.spawnermeta.shop.SpawnerShopSell;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ShopSelection
implements Listener {
    private final SpawnerShopBuy buy;
    private final SpawnerShopSell sell;
    private final Inventory v;

    public ShopSelection(SpawnerShopBuy buy, SpawnerShopSell sell, Material filler, Material mbuy, Material msell) {
        this.buy = buy;
        this.sell = sell;
        this.v = Bukkit.createInventory(null, (int)9, (String)Language.get("Inventory.select-shop.name").text());
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SpawnerMeta.instance());
        this.update(filler, mbuy, msell);
    }

    public void open(Player player) {
        if (!player.hasPermission("spawnermeta.shop.selection.open")) {
            player.sendMessage(Language.get("Inventory.select-shop.permission.opening").text());
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        player.openInventory(this.v);
        player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 2.0f, 2.0f);
    }

    @EventHandler
    private void onClick(InventoryClickEvent event) {
        if (!this.v.equals(event.getClickedInventory())) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        int s = event.getSlot();
        if (s == 2) {
            this.buy.open(player);
        } else if (s == 6) {
            this.sell.open(player);
        }
    }

    private void update(Material filler, Material mbuy, Material msell) {
        ItemStack x = this.x(filler);
        int i = 0;
        while (i < this.v.getSize()) {
            this.v.setItem(i, x);
            ++i;
        }
        this.v.setItem(2, this.buy(mbuy));
        this.v.setItem(6, this.sell(msell));
    }

    private ItemStack buy(Material m) {
        ItemStack item = new ItemStack(m);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.select-shop.buy-shop").text());
        meta.addItemFlags(ItemFlag.values());
        meta.addEnchant(Enchantment.ARROW_DAMAGE, 0, true);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack sell(Material m) {
        ItemStack item = new ItemStack(m);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.select-shop.sell-shop").text());
        meta.addItemFlags(ItemFlag.values());
        meta.addEnchant(Enchantment.ARROW_DAMAGE, 0, true);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack x(Material m) {
        ItemStack item = new ItemStack(m);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(" ");
        item.setItemMeta(meta);
        return item;
    }

    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }
}

