/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.shop;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.shop.BuyData;
import mc.rellox.spawnermeta.shop.SellData;
import mc.rellox.spawnermeta.shop.SellGroup;
import mc.rellox.spawnermeta.shop.ShopSelection;
import mc.rellox.spawnermeta.shop.SpawnerShopBuy;
import mc.rellox.spawnermeta.shop.SpawnerShopSell;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.utils.Reflections;
import mc.rellox.spawnermeta.utils.Version;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public final class ShopRegistry {
    private static File lf;
    private static FileConfiguration file;
    private static SpawnerShopBuy shop_buy;
    private static SpawnerShopSell shop_sell;
    private static ShopSelection shop_selection;
    public static int first;
    public static int second;
    public static int third;
    private static final Map<String, PermissionHolder> BUY_PERMISSIONS;
    private static final Map<String, PermissionHolder> SELL_PERMISSIONS;

    static {
        BUY_PERMISSIONS = new HashMap<String, PermissionHolder>();
        SELL_PERMISSIONS = new HashMap<String, PermissionHolder>();
    }

    public static void initialize() {
        ShopRegistry.initializeConfig();
        ShopRegistry.loadValues();
        ShopRegistry.loadBuy();
        ShopRegistry.loadSell();
        ShopRegistry.loadSelection();
        ShopRegistry.loadPermissions();
    }

    private static void loadValues() {
        first = file.getInt("Settings.Buy.Amount.First");
        second = file.getInt("Settings.Buy.Amount.Second");
        third = file.getInt("Settings.Buy.Amount.Third");
    }

    private static void loadBuy() {
        if (shop_buy != null) {
            shop_buy.unregister();
        }
        shop_buy = null;
        if (!file.getBoolean("Settings.Buy.Enabled")) {
            return;
        }
        int rows = file.getInt("Settings.Buy.Rows");
        if (rows <= 1 && rows > 6) {
            ShopRegistry.log("Unable to create buy shop, invalid row amount (" + rows + ")! " + "Rows must be greater than 1 and less or equal than 6!");
            return;
        }
        ArrayList<BuyData> list = new ArrayList<BuyData>();
        SpawnerType[] spawnerTypeArray = SpawnerType.values();
        int n = spawnerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpawnerType type = spawnerTypeArray[n2];
            if (type.exists() && file.getBoolean("Shop.Buy." + type.name() + ".Toggle")) {
                int cost = file.getInt("Shop.Buy." + type.name() + ".Cost");
                if (cost <= 0) {
                    ShopRegistry.log("Unable to create buy shop, invalid spawner (" + type.formated() + ") cost (" + cost + ")!");
                } else {
                    list.add(new BuyData(type, cost));
                }
            }
            ++n2;
        }
        if (list.isEmpty()) {
            ShopRegistry.log("Unable to create buy shop, no spawners to sell!");
            return;
        }
        Material filler = Reflections.RF.enumerate(Material.class, file.getString("Settings.Buy.Filler"));
        if (filler == null) {
            ShopRegistry.log("Unable to create buy shop, invalid inventory filler!");
            return;
        }
        boolean[] bs = new boolean[]{file.getBoolean("Settings.Buy.Buyable.First"), file.getBoolean("Settings.Buy.Buyable.Second"), file.getBoolean("Settings.Buy.Buyable.Third"), file.getBoolean("Settings.Buy.Buyable.Maximum")};
        boolean f = false;
        boolean[] blArray = bs;
        int n3 = bs.length;
        int n4 = 0;
        while (n4 < n3) {
            boolean b = blArray[n4];
            if (f |= b) break;
            ++n4;
        }
        if (!f) {
            ShopRegistry.log("Unable to create buy shop, shop must allow at least one buying option!");
            return;
        }
        ShopRegistry.order(list);
        shop_buy = new SpawnerShopBuy(filler, rows, bs, (BuyData[])list.toArray(BuyData[]::new));
    }

    private static void order(List<BuyData> list) {
        List<SpawnerType> order = Reflections.RF.enumerate(SpawnerType.class, file.getStringList("Settings.Buy.Order"));
        if (order.isEmpty()) {
            return;
        }
        ArrayList<BuyData> newest = new ArrayList<BuyData>();
        block0: for (SpawnerType type : order) {
            int i = 0;
            while (i < list.size()) {
                BuyData bd = list.get(i);
                if (bd.type() == type) {
                    newest.add(bd);
                    list.remove(i);
                    continue block0;
                }
                ++i;
            }
        }
        list.addAll(0, newest);
    }

    private static void loadSell() {
        if (shop_sell != null) {
            shop_sell.unregister();
        }
        shop_sell = null;
        if (!file.getBoolean("Settings.Sell.Enabled")) {
            return;
        }
        int rows = file.getInt("Settings.Sell.Rows");
        if (rows <= 1 && rows > 6) {
            ShopRegistry.log("Unable to create sell shop, invalid row amount (" + rows + ")! " + "Rows must be greater than 1 and less or equal than 6!");
            return;
        }
        Material filler = Reflections.RF.enumerate(Material.class, file.getString("Settings.Sell.Filler"));
        if (filler == null) {
            ShopRegistry.log("Unable to create sell shop, invalid inventory filler!");
            return;
        }
        Material sell = Reflections.RF.enumerate(Material.class, file.getString("Settings.Sell.Sell"));
        if (sell == null) {
            ShopRegistry.log("Unable to create sell shop, invalid sell material!");
            return;
        }
        Material close = Reflections.RF.enumerate(Material.class, file.getString("Settings.Sell.Close"));
        if (close == null) {
            ShopRegistry.log("Unable to create sell shop, invalid close material!");
            return;
        }
        ArrayList<SellData> list = new ArrayList<SellData>();
        SpawnerType[] spawnerTypeArray = SpawnerType.values();
        int n = spawnerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpawnerType type = spawnerTypeArray[n2];
            if (type.exists() && file.getBoolean("Shop.Sell." + type.name() + ".Toggle")) {
                int refund = file.getInt("Shop.Sell." + type.name() + ".Refund");
                if (refund <= 0) {
                    ShopRegistry.log("Unable to create sell shop, refund amount must be greater than 0 (" + type.name() + ")!");
                    return;
                }
                double up = file.getDouble("Shop.Sell." + type.name() + ".Upgrades");
                if (up < 0.0 || up > 1.0) {
                    ShopRegistry.log("Unable to create sell shop, upgrade refund percentage must be greater or equal than 0 and less or equal than 1 (" + type.name() + ")!");
                    return;
                }
                list.add(new SellData(type, refund, up));
            }
            ++n2;
        }
        SellGroup group = new SellGroup(filler, sell, close, rows, (SellData[])list.toArray(SellData[]::new));
        shop_sell = new SpawnerShopSell(group);
    }

    private static void loadSelection() {
        if (shop_buy == null || shop_sell == null) {
            shop_selection = null;
            return;
        }
        Material filler = Reflections.RF.enumerate(Material.class, file.getString("Settings.Selection.Filler"));
        if (filler == null) {
            ShopRegistry.log("Unable to create selection shop, invalid inventory filler!");
            return;
        }
        Material mbuy = Reflections.RF.enumerate(Material.class, file.getString("Settings.Selection.Buy"));
        if (mbuy == null) {
            ShopRegistry.log("Unable to create selection shop, invalid buy material!");
            return;
        }
        Material msell = Reflections.RF.enumerate(Material.class, file.getString("Settings.Selection.Sell"));
        if (msell == null) {
            ShopRegistry.log("Unable to create selection shop, invalid sell material!");
            return;
        }
        shop_selection = new ShopSelection(shop_buy, shop_sell, filler, mbuy, msell);
    }

    public static boolean open(Player player) {
        if (shop_selection != null) {
            shop_selection.open(player);
        } else if (shop_buy != null) {
            shop_buy.open(player);
        } else if (shop_sell != null) {
            shop_sell.open(player);
        } else {
            return false;
        }
        return true;
    }

    private static void loadPermissions() {
        Set keys;
        String path;
        BUY_PERMISSIONS.clear();
        SELL_PERMISSIONS.clear();
        ConfigurationSection cs = file.getConfigurationSection("Permissions.buy");
        if (cs != null) {
            path = "Permissions.buy";
            keys = cs.getKeys(false);
            keys.forEach(key -> {
                String p = String.valueOf(path) + "." + key;
                List list = file.getStringList(String.valueOf(p) + ".entities");
                if (list.isEmpty()) {
                    ShopRegistry.log("Missing entity list for shop buy permission (" + key + ")");
                    return;
                }
                HashSet<SpawnerType> set = list.contains("ALL") ? Set.of(SpawnerType.values()) : new HashSet<SpawnerType>(Reflections.RF.enumerate(SpawnerType.class, list));
                String sub = file.getString(String.valueOf(p) + ".sub-permission");
                BUY_PERMISSIONS.put("spawnermeta.shop.buy.permission." + key, new PermissionHolder(set, sub));
            });
        }
        if ((cs = file.getConfigurationSection("Permissions.sell")) != null) {
            path = "Permissions.sell";
            keys = cs.getKeys(false);
            keys.forEach(key -> {
                String p = String.valueOf(path) + "." + key;
                List list = file.getStringList(String.valueOf(p) + ".entities");
                if (list.isEmpty()) {
                    ShopRegistry.log("Missing entity list for shop sell permission (" + key + ")");
                    return;
                }
                HashSet<SpawnerType> set = list.contains("ALL") ? Set.of(SpawnerType.values()) : new HashSet<SpawnerType>(Reflections.RF.enumerate(SpawnerType.class, list));
                String sub = file.getString(String.valueOf(p) + ".sub-permission");
                SELL_PERMISSIONS.put("spawnermeta.shop.sell.permission." + key, new PermissionHolder(set, sub));
            });
        }
    }

    public static boolean canBuy(Player player, SpawnerType type) {
        return ShopRegistry.permissions(player, type, BUY_PERMISSIONS);
    }

    public static boolean canSell(Player player, SpawnerType type) {
        return ShopRegistry.permissions(player, type, SELL_PERMISSIONS);
    }

    private static boolean permissions(Player player, SpawnerType type, Map<String, PermissionHolder> map) {
        if (map.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, PermissionHolder> e : map.entrySet()) {
            String perm = e.getKey();
            if (!player.isPermissionSet(perm) || !player.hasPermission(perm) || !e.getValue().is(type, map)) continue;
            return true;
        }
        return false;
    }

    private static void log(String s) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "SM" + ChatColor.DARK_PURPLE + "] " + ChatColor.RED + s);
    }

    private static void initializeConfig() {
        lf = new File(SpawnerMeta.instance().getDataFolder(), "shop.yml");
        if (!lf.getParentFile().exists()) {
            lf.getParentFile().mkdirs();
        }
        if (lf.exists()) {
            file = YamlConfiguration.loadConfiguration((File)lf);
        } else {
            try {
                lf.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            file = YamlConfiguration.loadConfiguration((File)lf);
        }
        HashMap<Integer, SpawnerType[]> map = new HashMap<Integer, SpawnerType[]>();
        map.put(500, new SpawnerType[]{SpawnerType.AXOLOTL, SpawnerType.BAT, SpawnerType.BEE, SpawnerType.CAT, SpawnerType.CHICKEN, SpawnerType.COD, SpawnerType.COW, SpawnerType.DOLPHIN, SpawnerType.DONKEY, SpawnerType.ENDERMITE, SpawnerType.FOX, SpawnerType.GLOW_SQUID, SpawnerType.GOAT, SpawnerType.HOGLIN, SpawnerType.HORSE, SpawnerType.LLAMA, SpawnerType.MULE, SpawnerType.MUSHROOM_COW, SpawnerType.OCELOT, SpawnerType.PANDA, SpawnerType.PARROT, SpawnerType.PIG, SpawnerType.POLAR_BEAR, SpawnerType.PUFFERFISH, SpawnerType.RABBIT, SpawnerType.SALMON, SpawnerType.SHEEP, SpawnerType.SILVERFISH, SpawnerType.SQUID, SpawnerType.STRIDER, SpawnerType.TROPICAL_FISH, SpawnerType.TURTLE, SpawnerType.WOLF, SpawnerType.ZOGLIN});
        map.put(1000, new SpawnerType[]{SpawnerType.BLAZE, SpawnerType.CAVE_SPIDER, SpawnerType.CREEPER, SpawnerType.DROWNED, SpawnerType.ENDERMAN, SpawnerType.EVOKER, SpawnerType.GHAST, SpawnerType.GUARDIAN, SpawnerType.HUSK, SpawnerType.IRON_GOLEM, SpawnerType.MAGMA_CUBE, SpawnerType.PHANTOM, SpawnerType.PIG_ZOMBIE, SpawnerType.PIGLIN, SpawnerType.PIGLIN_BRUTE, SpawnerType.PILLAGER, SpawnerType.RAVAGER, SpawnerType.SHULKER, SpawnerType.SKELETON, SpawnerType.SLIME, SpawnerType.SPIDER, SpawnerType.STRAY, SpawnerType.VEX, SpawnerType.VINDICATOR, SpawnerType.WITCH, SpawnerType.WITHER_SKELETON, SpawnerType.ZOMBIE, SpawnerType.ZOMBIFIED_PIGLIN});
        map.forEach((i, ts) -> {
            SpawnerType[] spawnerTypeArray = ts;
            int n = ((SpawnerType[])ts).length;
            int n2 = 0;
            while (n2 < n) {
                SpawnerType t = spawnerTypeArray[n2];
                String old_path = "Shop." + t.name();
                String new_path = "Shop.Buy." + t.name();
                if (file.isBoolean(String.valueOf(old_path) + ".Toggle")) {
                    boolean b = file.getBoolean(String.valueOf(old_path) + ".Toggle");
                    file.set(String.valueOf(new_path) + ".Toggle", (Object)b);
                    file.set(String.valueOf(old_path) + ".Toggle", null);
                } else {
                    file.addDefault(String.valueOf(new_path) + ".Toggle", (Object)true);
                }
                if (file.isInt(String.valueOf(old_path) + ".Cost")) {
                    int c = file.getInt(String.valueOf(old_path) + ".Cost");
                    file.set(String.valueOf(new_path) + ".Cost", (Object)c);
                    file.set(String.valueOf(old_path) + ".Cost", null);
                } else {
                    file.addDefault(String.valueOf(new_path) + ".Cost", i);
                }
                file.set("Shop." + t.name(), null);
                ++n2;
            }
        });
        file.addDefault("Settings.Buy.Enabled", (Object)true);
        if (file.isInt("Rows")) {
            int r = file.getInt("Rows");
            file.set("Settings.Buy.Rows", (Object)r);
            file.set("Rows", null);
        } else {
            file.addDefault("Settings.Buy.Rows", (Object)6);
        }
        if (file.isString("Filler")) {
            String s = file.getString("Filler");
            file.set("Settings.Buy.Filler", (Object)s);
            file.set("Filler", null);
        } else {
            file.addDefault("Settings.Buy.Filler", (Object)Material.PURPLE_STAINED_GLASS_PANE.name());
        }
        Object o = file.get("Settings.Buy.Buyable.BUY_1");
        if (o != null) {
            file.set("Settings.Buy.Buyable.First", o);
            file.set("Settings.Buy.Buyable.BUY_1", null);
        } else {
            file.addDefault("Settings.Buy.Buyable.First", (Object)true);
        }
        o = file.get("Settings.Buy.Buyable.BUY_4");
        if (o != null) {
            file.set("Settings.Buy.Buyable.Second", o);
            file.set("Settings.Buy.Buyable.BUY_4", null);
        } else {
            file.addDefault("Settings.Buy.Buyable.Second", (Object)true);
        }
        o = file.get("Settings.Buy.Buyable.BUY_16");
        if (o != null) {
            file.set("Settings.Buy.Buyable.Third", o);
            file.set("Settings.Buy.Buyable.BUY_16", null);
        } else {
            file.addDefault("Settings.Buy.Buyable.Third", (Object)true);
        }
        o = file.get("Settings.Buy.Buyable.BUY_MAX");
        if (o != null) {
            file.set("Settings.Buy.Buyable.Maximum", o);
            file.set("Settings.Buy.Buyable.BUY_MAX", null);
        } else {
            file.addDefault("Settings.Buy.Buyable.Maximum", (Object)true);
        }
        file.addDefault("Settings.Buy.Amount.First", (Object)1);
        file.addDefault("Settings.Buy.Amount.Second", (Object)4);
        file.addDefault("Settings.Buy.Amount.Third", (Object)16);
        map.clear();
        map.put(250, new SpawnerType[]{SpawnerType.AXOLOTL, SpawnerType.BAT, SpawnerType.BEE, SpawnerType.CAT, SpawnerType.CHICKEN, SpawnerType.COD, SpawnerType.COW, SpawnerType.DOLPHIN, SpawnerType.DONKEY, SpawnerType.ENDERMITE, SpawnerType.FOX, SpawnerType.GLOW_SQUID, SpawnerType.GOAT, SpawnerType.HOGLIN, SpawnerType.HORSE, SpawnerType.LLAMA, SpawnerType.MULE, SpawnerType.MUSHROOM_COW, SpawnerType.OCELOT, SpawnerType.PANDA, SpawnerType.PARROT, SpawnerType.PIG, SpawnerType.POLAR_BEAR, SpawnerType.PUFFERFISH, SpawnerType.RABBIT, SpawnerType.SALMON, SpawnerType.SHEEP, SpawnerType.SILVERFISH, SpawnerType.SQUID, SpawnerType.STRIDER, SpawnerType.TROPICAL_FISH, SpawnerType.TURTLE, SpawnerType.WOLF, SpawnerType.ZOGLIN});
        map.put(500, new SpawnerType[]{SpawnerType.BLAZE, SpawnerType.CAVE_SPIDER, SpawnerType.CREEPER, SpawnerType.DROWNED, SpawnerType.ENDERMAN, SpawnerType.EVOKER, SpawnerType.GHAST, SpawnerType.GUARDIAN, SpawnerType.HUSK, SpawnerType.IRON_GOLEM, SpawnerType.MAGMA_CUBE, SpawnerType.PHANTOM, SpawnerType.PIG_ZOMBIE, SpawnerType.PIGLIN, SpawnerType.PIGLIN_BRUTE, SpawnerType.PILLAGER, SpawnerType.RAVAGER, SpawnerType.SHULKER, SpawnerType.SKELETON, SpawnerType.SLIME, SpawnerType.SPIDER, SpawnerType.STRAY, SpawnerType.VEX, SpawnerType.VINDICATOR, SpawnerType.WITCH, SpawnerType.WITHER_SKELETON, SpawnerType.ZOMBIE, SpawnerType.ZOMBIFIED_PIGLIN});
        file.addDefault("Settings.Buy.Order", new ArrayList());
        map.forEach((i, ts) -> {
            SpawnerType[] spawnerTypeArray = ts;
            int n = ((SpawnerType[])ts).length;
            int n2 = 0;
            while (n2 < n) {
                SpawnerType t = spawnerTypeArray[n2];
                String path = "Shop.Sell." + t.name();
                file.addDefault(String.valueOf(path) + ".Toggle", (Object)true);
                file.addDefault(String.valueOf(path) + ".Refund", i);
                file.addDefault(String.valueOf(path) + ".Upgrades", (Object)0.5);
                ++n2;
            }
        });
        file.addDefault("Settings.Sell.Enabled", (Object)false);
        file.addDefault("Settings.Sell.Filler", (Object)Material.LIME_STAINED_GLASS_PANE.name());
        file.addDefault("Settings.Sell.Sell", (Object)Material.EMERALD.name());
        file.addDefault("Settings.Sell.Close", (Object)Material.REDSTONE.name());
        file.addDefault("Settings.Sell.Rows", (Object)4);
        file.addDefault("Settings.Selection.Filler", (Object)Material.LIGHT_BLUE_STAINED_GLASS_PANE.name());
        file.addDefault("Settings.Selection.Buy", (Object)Material.GOLD_BLOCK.name());
        file.addDefault("Settings.Selection.Sell", (Object)Material.EMERALD_BLOCK.name());
        file.addDefault("Permissions.buy", new ArrayList());
        file.addDefault("Permissions.sell", new ArrayList());
        file.options().copyDefaults(true);
        Commenter c = ShopRegistry.commenter();
        if (c != null) {
            c.comment("Shop.Sell", "There are 3 options for each entity type:", "  Toggle - can this entity spawner be sold", "  Refund - the price that is refunded for the spawner", "  Upgrades - refunded percentage of upgrade value ( 0.5 -> 50% )");
            c.comment("Permissions.Buy", "Shop buy permissions can be created:", "  <permission name>:", "    # List of allowed entities.", "    # Use ALL to allow all entities.", "    entities:", "    - PIG", "    - ...", "    # Previous permission, this permission will", "    # include all sub-permission entities.", "    sub-permission: <permission name>", "", "Final permission name - spawnermeta.shop.buy.permission.<permission name>");
            c.comment("Permissions.Sell", "Shop sell permissions can be created:", "  <permission name>:", "    # List of allowed entities.", "    # Use ALL to allow all entities.", "    entities:", "    - PIG", "    - ...", "    # Previous permission, this permission will", "    # include all sub-permission entities.", "    sub-permission: <permission name>", "", "Final permission name - spawnermeta.shop.sell.permission.<permission name>");
        }
        ShopRegistry.save();
    }

    protected static Commenter commenter() {
        return Version.version.high(Version.VersionType.v_18_1) ? new Commenter() : null;
    }

    public static void save() {
        try {
            file.save(lf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static class Commenter {
        protected Commenter() {
        }

        protected void comment(String path, String ... cs) {
            Reflections.RF.order((Object)file, "setComments", String.class, List.class).invoke(new Object[]{path, Arrays.asList(cs)});
        }
    }

    private static class PermissionHolder {
        private final Set<SpawnerType> set;
        private final String sub;

        public PermissionHolder(Set<SpawnerType> list, String sub) {
            this.set = list;
            this.sub = sub;
        }

        public boolean is(SpawnerType type, Map<String, PermissionHolder> map) {
            if (this.set.contains((Object)type)) {
                return true;
            }
            if (this.sub != null) {
                PermissionHolder subholder = map.get(this.sub);
                return subholder == null ? false : subholder.is(type, map);
            }
            return false;
        }
    }
}

