/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.shop;

import java.util.ArrayList;
import java.util.List;
import mc.rellox.spawnermeta.api.spawner.VirtualSpawner;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.items.ItemMatcher;
import mc.rellox.spawnermeta.prices.Group;
import mc.rellox.spawnermeta.prices.Price;
import mc.rellox.spawnermeta.shop.SellData;
import mc.rellox.spawnermeta.shop.SellGroup;
import mc.rellox.spawnermeta.shop.ShopRegistry;
import mc.rellox.spawnermeta.shop.SpawnerShopSell;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.utils.DataManager;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PrivateSell {
    protected final Player player;
    private final SpawnerShopSell sell;
    private final SellGroup group;
    private final List<SpawnerItem> spawners;
    private final Inventory v;

    public PrivateSell(Player player, SpawnerShopSell sell) {
        this.player = player;
        this.sell = sell;
        this.group = sell.group;
        this.spawners = new ArrayList<SpawnerItem>();
        this.v = this.group.create();
        this.update();
    }

    public void open() {
        this.player.openInventory(this.v);
        this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 2.0f, 2.0f);
    }

    protected boolean click(InventoryClickEvent event) {
        if (!this.player.equals(event.getWhoClicked())) {
            return false;
        }
        Inventory n = event.getInventory();
        if (!this.v.equals(n)) {
            return false;
        }
        event.setCancelled(true);
        Inventory c = event.getClickedInventory();
        if (c == null) {
            return false;
        }
        int s = event.getSlot();
        if (c.equals(this.v)) {
            if (s == this.v.getSize() - 6) {
                this.give();
                this.sell.remove(this.player);
                this.player.closeInventory();
                this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            } else if (s == this.v.getSize() - 4) {
                Price[] cs;
                if (this.spawners.isEmpty()) {
                    this.player.sendMessage(Language.get("Inventory.sell-shop.selling.empty").text());
                    return true;
                }
                this.player.sendMessage(Language.get("Inventory.sell-shop.selling.success").text());
                Price[] priceArray = cs = this.total();
                int n2 = cs.length;
                int n3 = 0;
                while (n3 < n2) {
                    Price cc = priceArray[n3];
                    this.player.sendMessage(Language.get("Inventory.sell-shop.items.selling.price", "price", (Object)cc).text());
                    ++n3;
                }
                this.spawners.forEach(si -> si.refund(this.player));
                this.spawners.clear();
                this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_GRINDSTONE_USE, 2.0f, 1.5f);
                this.sell.remove(this.player);
                this.player.closeInventory();
            } else if (!this.spawners.isEmpty() && s >= 9 && s < 9 + this.spawners.size()) {
                int i = s - 9;
                SpawnerItem si2 = this.spawners.remove(i);
                ItemMatcher.add(this.player, si2.item);
                this.player.playSound(this.player.getEyeLocation(), Sound.ENTITY_ITEM_FRAME_REMOVE_ITEM, 2.0f, 1.0f);
                this.update();
            }
        } else {
            int a;
            if (this.spawners.size() >= this.v.getSize() - 18) {
                return true;
            }
            ItemStack item = c.getItem(s);
            VirtualSpawner sd = DataManager.getSpawnerItem(item);
            if (sd == null) {
                return true;
            }
            if (sd.isEmpty()) {
                this.player.sendMessage(Language.get("Inventory.sell-shop.selling.unable").text());
                return true;
            }
            SellData sell = this.group.get(sd.getType());
            if (sell == null) {
                this.player.sendMessage(Language.get("Inventory.sell-shop.selling.unable").text());
                return true;
            }
            if (!ShopRegistry.canSell(this.player, sell.type)) {
                this.player.sendMessage(Language.get("Inventory.sell-shop.permission.selling").text());
                this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
                return true;
            }
            int m = item.getAmount();
            if (event.isShiftClick()) {
                a = m;
                c.setItem(s, null);
            } else {
                a = 1;
                if (m > 1) {
                    ItemStack clone = item.clone();
                    clone.setAmount(m - 1);
                    c.setItem(s, clone);
                } else {
                    c.setItem(s, null);
                }
            }
            this.spawners.add(new SpawnerItem(sell, item.clone(), sd, a));
            this.player.playSound(this.player.getEyeLocation(), Sound.ENTITY_ITEM_FRAME_PLACE, 2.0f, 1.5f);
            this.update();
        }
        return true;
    }

    private Price[] total() {
        int[] rs = new int[2];
        for (SpawnerItem si : this.spawners) {
            rs[0] = rs[0] + si.refund[0];
            rs[1] = rs[1] + si.refund[1];
        }
        if (rs[0] <= 0) {
            return null;
        }
        Price c0 = Price.of(Group.shop, rs[0]);
        if (rs[1] > 0) {
            Price c1 = Price.of(Group.upgrades, rs[1]);
            if (c0.type == c1.type) {
                return new Price[]{Price.of(Group.shop, rs[0] + rs[1])};
            }
            return new Price[]{c0, c1};
        }
        return new Price[]{c0};
    }

    private void give() {
        if (!this.spawners.isEmpty()) {
            this.spawners.forEach(si -> ItemMatcher.add(this.player, si.item));
            this.spawners.clear();
        }
    }

    protected boolean close(Player player) {
        this.give();
        return this.player.equals(player) || this.v.getViewers().size() == 0;
    }

    private void update() {
        ItemStack x = this.group.x();
        int i = 0;
        while (i < 9) {
            this.v.setItem(i, x);
            ++i;
        }
        i = this.v.getSize() - 9;
        while (i < this.v.getSize()) {
            this.v.setItem(i, x);
            ++i;
        }
        int j = 9;
        for (SpawnerItem si : this.spawners) {
            this.v.setItem(j++, si.show());
        }
        int e = this.v.getSize() - 9;
        while (j < e) {
            this.v.setItem(j, null);
            ++j;
        }
        this.v.setItem(this.v.getSize() - 6, this.close());
        this.v.setItem(this.v.getSize() - 4, this.sell());
    }

    private ItemStack sell() {
        ItemStack item = new ItemStack(this.group.sell());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.sell-shop.accept").text());
        Price[] cs = this.total();
        if (cs != null) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            lore.add(Language.get("Inventory.sell-shop.items.selling.name").text());
            Price[] priceArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                Price c = priceArray[n2];
                lore.add(Language.get("Inventory.sell-shop.items.selling.price", "price", (Object)c).text());
                ++n2;
            }
            meta.setLore(lore);
        }
        meta.addItemFlags(ItemFlag.values());
        meta.addEnchant(Enchantment.ARROW_DAMAGE, 0, true);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack close() {
        ItemStack item = new ItemStack(this.group.close());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.sell-shop.cancel").text());
        meta.addItemFlags(ItemFlag.values());
        meta.addEnchant(Enchantment.ARROW_DAMAGE, 0, true);
        item.setItemMeta(meta);
        return item;
    }

    private class SpawnerItem {
        private final SellData sell;
        public final ItemStack item;
        public final VirtualSpawner spawner;
        private final int amount;
        public final int[] refund;

        public SpawnerItem(SellData sell, ItemStack item, VirtualSpawner spawner, int amount) {
            this.sell = sell;
            this.item = item;
            item.setAmount(amount);
            this.spawner = spawner;
            this.amount = amount;
            this.refund = this.refund();
        }

        public ItemStack show() {
            Price[] cs;
            ItemStack clone = this.item.clone();
            ItemMeta meta = clone.getItemMeta();
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.add("");
            lore.add(Language.get("Inventory.sell-shop.items.selling.name").text());
            Price[] priceArray = cs = this.prices();
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                Price c = priceArray[n2];
                lore.add(Language.get("Inventory.sell-shop.items.selling.price", "price", (Object)c).text());
                ++n2;
            }
            meta.setLore(lore);
            clone.setItemMeta(meta);
            return clone;
        }

        public Price[] prices() {
            Price c0 = Price.of(Group.shop, this.refund[0]);
            if (this.refund[1] > 0) {
                Price c1 = Price.of(Group.upgrades, this.refund[1]);
                if (c0.type == c1.type) {
                    return new Price[]{Price.of(Group.shop, c0.value + c1.value)};
                }
                return new Price[]{c0, c1};
            }
            return new Price[]{c0};
        }

        public void refund(Player player) {
            Price[] cs;
            Price[] priceArray = cs = this.prices();
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                Price c = priceArray[n2];
                c.refund(player);
                ++n2;
            }
        }

        private int[] refund() {
            int t = this.sell.refund;
            SpawnerType type = this.spawner.getType();
            boolean[] bs = Settings.settings.upgrades_upgradeable.get(type);
            int[] vs = Settings.settings.upgrades_prices.get(type);
            int[] is = Settings.settings.spawner_value_increase.get(type);
            int[] ls = this.spawner.getUpgradeLevels();
            int a = 0;
            int i = 0;
            while (i < 3) {
                if (bs[i]) {
                    int c = vs[i];
                    int j = 1;
                    while (j < ls[i]) {
                        a += c;
                        c = Settings.settings.upgrade_increase_type.price(c, is[i]);
                        ++j;
                    }
                }
                ++i;
            }
            return new int[]{t * this.amount, (int)((double)a * this.sell.up) * this.amount};
        }
    }
}

