/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.shop;

import java.util.ArrayList;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.items.ItemMatcher;
import mc.rellox.spawnermeta.prices.Group;
import mc.rellox.spawnermeta.prices.Price;
import mc.rellox.spawnermeta.shop.ShopRegistry;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.utils.DataManager;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public record BuyData(SpawnerType type, int value) {
    public void buy(Player player, int a) {
        Price price = Price.of(Group.shop, this.value * a);
        if (!price.has(player)) {
            player.sendMessage(Language.get("Prices.insufficient", "insufficient", price.insufficient(), "price", price.requires(player)).text());
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        price.remove(player);
        ItemStack item = DataManager.getSpawners(this.type, a, false, true).get(0);
        ItemMatcher.add(player, item);
        player.sendMessage(Language.get("Inventory.buy-shop.purchase.success", new Object[]{"amount", a, "type", this.type}).text());
        player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 2.0f);
    }

    public ItemStack info(boolean[] bs) {
        ItemStack item = new ItemStack(Material.SPAWNER);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.buy-shop.items.spawner.name", "type", (Object)this.type).text());
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        lore.add(Language.get("Inventory.buy-shop.items.spawner.price", "price", (Object)Price.of(Group.shop, this.value)).text());
        lore.add("");
        if (bs[0]) {
            lore.add(Language.get("Inventory.buy-shop.items.spawner.purchase.first", "amount", (Object)ShopRegistry.first).text());
        }
        if (bs[1]) {
            lore.add(Language.get("Inventory.buy-shop.items.spawner.purchase.second", "amount", (Object)ShopRegistry.second).text());
        }
        if (bs[2]) {
            lore.add(Language.get("Inventory.buy-shop.items.spawner.purchase.third", "amount", (Object)ShopRegistry.third).text());
        }
        if (bs[3]) {
            lore.add(Language.get("Inventory.buy-shop.items.spawner.purchase.all").text());
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }
}

