/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.prices;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.configuration.Configuration;
import mc.rellox.spawnermeta.items.ItemMatcher;
import mc.rellox.spawnermeta.prices.Group;
import mc.rellox.spawnermeta.prices.Price;
import mc.rellox.spawnermeta.prices.PriceType;

public final class PriceManager {
    private static final Map<Group, IPrice> PRICES = new HashMap<Group, IPrice>();

    public static IPrice of(Group group) {
        return PRICES.get((Object)group);
    }

    public static Price price(Group group, int i) {
        return PriceManager.of(group).of(i);
    }

    public static void reload() {
        PRICES.clear();
        Stream.of(Group.values()).forEach(group -> {
            IPrice price;
            String path = "Prices." + group.name();
            String type_name = Configuration.CF.s.getString(String.valueOf(path) + ".price-type");
            PriceType type = PriceType.of(type_name);
            if (type == null) {
                type = PriceType.EXPERIENCE;
            } else if (type == PriceType.ECONOMY && SpawnerMeta.ECONOMY.get() == null) {
                type = PriceType.EXPERIENCE;
            }
            if (type == PriceType.EXPERIENCE) {
                price = Price.PriceExperience::new;
            } else if (type == PriceType.LEVELS) {
                price = Price.PriceLevels::new;
            } else if (type == PriceType.ECONOMY) {
                price = Price.PriceEconomy::new;
            } else {
                ItemMatcher matcher = Configuration.CF.s.getMatcher(String.valueOf(path) + ".item");
                price = i -> new Price.PriceMaterial(i, matcher);
            }
            PRICES.put((Group)((Object)group), price);
        });
    }

    public static interface IPrice {
        public Price of(int var1);
    }
}

