/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.prices;

import java.util.stream.IntStream;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.items.ItemMatcher;
import mc.rellox.spawnermeta.prices.Group;
import mc.rellox.spawnermeta.prices.PriceManager;
import mc.rellox.spawnermeta.prices.PriceType;
import mc.rellox.spawnermeta.text.content.Content;
import mc.rellox.spawnermeta.utils.Utils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public abstract class Price {
    public final PriceType type;
    public final int value;

    public static Price of(Group group, int value) {
        return PriceManager.price(group, value);
    }

    public abstract int balance(Player var1);

    public Price(PriceType type, int value) {
        this.type = type;
        this.value = value;
    }

    public abstract boolean has(Player var1);

    public abstract void remove(Player var1);

    public abstract Content insufficient();

    public abstract Content text();

    public abstract Content requires(Player var1);

    public abstract void refund(Player var1);

    public static class PriceEconomy
    extends Price {
        public PriceEconomy(int value) {
            super(PriceType.ECONOMY, value);
            if (SpawnerMeta.ECONOMY.get() == null) {
                throw new IllegalStateException("Cannot construct price of type ECONOMY, due to economy not being enabled");
            }
        }

        @Override
        public boolean has(Player player) {
            return Utils.op(player) || SpawnerMeta.ECONOMY.get().has((OfflinePlayer)player, (double)this.value);
        }

        @Override
        public void remove(Player player) {
            if (Utils.op(player)) {
                return;
            }
            SpawnerMeta.ECONOMY.get().withdrawPlayer((OfflinePlayer)player, (double)this.value);
        }

        @Override
        public Content insufficient() {
            return Language.get("Prices.type.economy.insufficient");
        }

        @Override
        public Content text() {
            return Language.get("Prices.type.economy.amount", "amount", (Object)String.format("%.2f", this.value));
        }

        @Override
        public Content requires(Player player) {
            double require = this.value - this.balance(player);
            return Language.get("Prices.type.economy.amount", "amount", (Object)String.format("%.2f", require));
        }

        @Override
        public int balance(Player player) {
            return (int)SpawnerMeta.ECONOMY.get().getBalance((OfflinePlayer)player);
        }

        @Override
        public void refund(Player player) {
            SpawnerMeta.ECONOMY.get().depositPlayer((OfflinePlayer)player, (double)this.value);
        }
    }

    public static class PriceExperience
    extends Price {
        public PriceExperience(int value) {
            super(PriceType.EXPERIENCE, value);
        }

        @Override
        public boolean has(Player player) {
            return Utils.op(player) || Utils.getExp(player) >= this.value;
        }

        @Override
        public void remove(Player player) {
            if (Utils.op(player)) {
                return;
            }
            Utils.changeExp(player, -this.value);
        }

        @Override
        public Content insufficient() {
            return Language.get("Prices.experience.insufficient");
        }

        @Override
        public Content text() {
            return Language.get("Prices.type.experience.amount", "amount", (Object)this.value);
        }

        @Override
        public Content requires(Player player) {
            int require = this.value - this.balance(player);
            return Language.get("Prices.type.experience.amount", "amount", (Object)require);
        }

        @Override
        public int balance(Player player) {
            return Utils.getExp(player);
        }

        @Override
        public void refund(Player player) {
            Utils.changeExp(player, this.value);
        }
    }

    public static class PriceLevels
    extends Price {
        public PriceLevels(int value) {
            super(PriceType.LEVELS, value);
        }

        @Override
        public boolean has(Player player) {
            return Utils.op(player) || player.getLevel() >= this.value;
        }

        @Override
        public void remove(Player player) {
            if (Utils.op(player)) {
                return;
            }
            player.setLevel(player.getLevel() - this.value);
        }

        @Override
        public Content insufficient() {
            return Language.get("Prices.type.levels.insufficient");
        }

        @Override
        public Content text() {
            return Language.get("Prices.type.levels.amount", "amount", (Object)this.value);
        }

        @Override
        public Content requires(Player player) {
            int require = this.value - player.getLevel();
            return Language.get("Prices.type.levels.amount", "amount", (Object)require);
        }

        @Override
        public int balance(Player player) {
            return player.getLevel();
        }

        @Override
        public void refund(Player player) {
            int level = player.getLevel() + this.value;
            player.setLevel(level);
        }
    }

    public static class PriceMaterial
    extends Price {
        private final ItemMatcher matcher;

        public PriceMaterial(int value, ItemMatcher matcher) {
            super(PriceType.MATERIAL, value);
            this.matcher = matcher;
        }

        @Override
        public boolean has(Player player) {
            if (Utils.op(player)) {
                return true;
            }
            PlayerInventory v = player.getInventory();
            int h = IntStream.range(0, 36).map(arg_0 -> this.lambda$0((Inventory)v, arg_0)).sum();
            return h >= this.value;
        }

        @Override
        public void remove(Player player) {
            if (Utils.op(player)) {
                return;
            }
            PlayerInventory v = player.getInventory();
            int[] f = new int[]{this.value};
            IntStream.range(0, 36).forEach(arg_0 -> this.lambda$1(f, (Inventory)v, arg_0));
        }

        @Override
        public Content insufficient() {
            return Language.get("Prices.type.material.insufficient");
        }

        @Override
        public Content text() {
            return Language.get("Prices.type.material.amount", "amount", this.value, "material", Utils.displayName(this.matcher.refund()));
        }

        @Override
        public Content requires(Player player) {
            return Language.get("Prices.type.material.amount", "amount", this.value - this.balance(player), "material", Utils.displayName(this.matcher.refund()));
        }

        @Override
        public int balance(Player player) {
            PlayerInventory v = player.getInventory();
            return IntStream.range(0, 36).map(arg_0 -> this.lambda$2((Inventory)v, arg_0)).sum();
        }

        @Override
        public void refund(Player player) {
            int i = 0;
            while (i < this.value) {
                ItemMatcher.add(player, this.matcher.refund());
                ++i;
            }
        }

        private /* synthetic */ int lambda$0(Inventory inventory, int i) {
            ItemStack item = inventory.getItem(i);
            return this.matcher.match(item) ? item.getAmount() : 0;
        }

        private /* synthetic */ void lambda$1(int[] nArray, Inventory inventory, int i) {
            if (nArray[0] <= 0) {
                return;
            }
            ItemStack item = inventory.getItem(i);
            if (!this.matcher.match(item)) {
                return;
            }
            int a = item.getAmount();
            if (a > nArray[0]) {
                item.setAmount(a - nArray[0]);
                nArray[0] = 0;
            } else {
                nArray[0] = nArray[0] - a;
                inventory.setItem(i, null);
            }
        }

        private /* synthetic */ int lambda$2(Inventory inventory, int i) {
            ItemStack slot = inventory.getItem(i);
            return this.matcher.match(slot) ? slot.getAmount() : 0;
        }
    }
}

