/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.items;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import mc.rellox.spawnermeta.utils.Reflections;
import mc.rellox.spawnermeta.utils.Utils;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public final class ItemMatcher {
    public static final ItemMatcher DEFAULT = new ItemMatcher(Material.GOLD_INGOT);
    private final Material material;
    private final List<MatchData> matchers;

    public static boolean has(Player player, ItemStack item, int a) {
        if (Utils.op(player)) {
            return true;
        }
        PlayerInventory v = player.getInventory();
        int t = IntStream.range(0, 36).map(i -> {
            ItemStack slot = v.getItem(i);
            if (!item.isSimilar(slot)) {
                return 0;
            }
            return slot.getAmount();
        }).sum();
        return t >= a;
    }

    public static void add(Player player, ItemStack item) {
        int f = 0;
        int a = item.getAmount();
        PlayerInventory pi = player.getInventory();
        int i = 0;
        while (f < a && i < 36) {
            ItemStack slot = pi.getItem(i);
            if (slot == null) {
                f += 64;
            } else if (slot.isSimilar(item)) {
                f += 64 - slot.getAmount();
            }
            ++i;
        }
        if (f >= a) {
            pi.addItem(new ItemStack[]{item});
        } else {
            ItemStack give = item.clone();
            give.setAmount(f);
            ItemStack sink = item.clone();
            sink.setAmount(a - f);
            pi.addItem(new ItemStack[]{give});
            Item drop = player.getWorld().dropItem(player.getLocation(), sink);
            drop.setVelocity(new Vector());
        }
    }

    public static void remove(Player player, ItemStack item, int a) {
        if (Utils.op(player)) {
            return;
        }
        ItemStack r = item.clone();
        r.setAmount(a);
        player.getInventory().removeItem(new ItemStack[]{r});
    }

    public static void parse(ItemStack item, FileConfiguration file, String path) {
        if (item == null) {
            return;
        }
        file.set(String.valueOf(path) + ".material", (Object)item.getType().name());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (meta.hasDisplayName()) {
                file.set(String.valueOf(path) + ".name", (Object)meta.getDisplayName());
            }
            if (meta.hasCustomModelData()) {
                file.set(String.valueOf(path) + ".model", (Object)meta.getCustomModelData());
            }
        }
    }

    public static ItemMatcher from(FileConfiguration file, String path) {
        List lore;
        if (file == null) {
            return DEFAULT;
        }
        Material material = Reflections.RF.enumerate(Material.class, file.getString(String.valueOf(path) + ".material"));
        if (material == null) {
            return DEFAULT;
        }
        ItemMatcher matcher = new ItemMatcher(material);
        if (file.isString(String.valueOf(path) + ".name")) {
            String name = file.getString(String.valueOf(path) + ".name");
            if (name == null || name.isEmpty()) {
                return DEFAULT;
            }
            matcher.name(name);
        }
        if (file.isList(String.valueOf(path) + ".lore") && ((lore = file.getStringList(String.valueOf(path) + ".lore")) == null || lore.isEmpty())) {
            return DEFAULT;
        }
        if (file.isInt(String.valueOf(path) + ".model")) {
            int model = file.getInt(String.valueOf(path) + ".model");
            matcher.model(model);
        }
        return matcher;
    }

    protected ItemMatcher(Material material) {
        this.material = material;
        this.matchers = new LinkedList<MatchData>();
    }

    private ItemMatcher match(MatchData m) {
        this.matchers.add(m);
        return this;
    }

    protected ItemMatcher model(final int m) {
        this.match(new MatchData(){

            @Override
            public boolean match(ItemMeta meta) {
                return meta.getCustomModelData() == m;
            }

            @Override
            public void modify(ItemMeta meta) {
                meta.setCustomModelData(Integer.valueOf(m));
            }
        });
        return this;
    }

    protected ItemMatcher name(final String name) {
        this.match(new MatchData(){

            @Override
            public boolean match(ItemMeta meta) {
                return meta.getDisplayName().equals(name);
            }

            @Override
            public void modify(ItemMeta meta) {
                meta.setDisplayName(name);
            }
        });
        return this;
    }

    protected ItemMatcher lore(final List<String> lore) {
        this.match(new MatchData(){

            @Override
            public boolean match(ItemMeta meta) {
                List list = meta.getLore();
                if (list == null || list.isEmpty()) {
                    return false;
                }
                if (list.size() != lore.size()) {
                    return false;
                }
                return IntStream.range(0, lore.size()).allMatch(i -> ((String)list.get(i)).equals(lore.get(i)));
            }

            @Override
            public void modify(ItemMeta meta) {
                meta.setLore(lore);
            }
        });
        return this;
    }

    public boolean match(ItemStack item) {
        if (item == null || item.getType() != this.material) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta == null ? false : this.matchers.stream().allMatch(m -> m.match(meta));
    }

    public ItemStack refund() {
        ItemStack item = new ItemStack(this.material);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        this.matchers.forEach(m -> m.modify(meta));
        item.setItemMeta(meta);
        return item;
    }

    protected static interface MatchData {
        public boolean match(ItemMeta var1);

        public void modify(ItemMeta var1);
    }
}

