/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.utils.Utils;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ItemCollector
implements Listener {
    private static final Map<UUID, ItemCollector> ITEMS = new HashMap<UUID, ItemCollector>();
    private static boolean running;
    private final Player player;
    private final List<ItemStack> items;
    private int ticks;

    public static void add(Player player, ItemStack item) {
        if (Settings.settings.breaking_drop_on_ground) {
            return;
        }
        ItemCollector dr = ITEMS.get(player.getUniqueId());
        if (dr == null) {
            dr = new ItemCollector(player);
            ITEMS.put(player.getUniqueId(), dr);
        }
        dr.add(item);
    }

    public static boolean exists(Player player) {
        return ItemCollector.get(player) != null;
    }

    public static void execute(Player player) {
        if (Settings.settings.breaking_drop_on_ground) {
            return;
        }
        ItemCollector drop = ITEMS.get(player.getUniqueId());
        if (drop == null) {
            return;
        }
        if (drop.get(true)) {
            ItemCollector.unregister(player);
            return;
        }
        drop.remind();
        ItemCollector.run();
    }

    private static void run() {
        if (running) {
            return;
        }
        running = true;
        new BukkitRunnable(){

            public void run() {
                Iterator<ItemCollector> it = ITEMS.values().iterator();
                while (it.hasNext()) {
                    if (it.next().tick()) continue;
                    it.remove();
                }
                running = !ITEMS.isEmpty();
                if (!running) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)SpawnerMeta.instance(), 1L, 1L);
    }

    private static void send(Player player, int ticks) {
        BaseComponent[] text = TextComponent.fromLegacyText((String)Language.get("Items.spawner-drop.alert", "seconds", (Object)(ticks / 20)).text());
        ComponentBuilder builder = new ComponentBuilder("");
        Stream.of(text).forEach(arg_0 -> ((ComponentBuilder)builder).append(arg_0));
        builder.event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + Settings.settings.command_drops));
        player.spigot().sendMessage(builder.create());
    }

    public static void unregister(Player player) {
        ITEMS.remove(player.getUniqueId());
    }

    public static ItemCollector get(Player player) {
        if (Settings.settings.breaking_drop_on_ground) {
            return null;
        }
        return ITEMS.get(player.getUniqueId());
    }

    public ItemCollector(Player player) {
        this.player = player;
        this.items = new ArrayList<ItemStack>();
    }

    private boolean tick() {
        if (--this.ticks <= 0) {
            this.player.sendMessage(Language.get("Items.spawner-drop.cleared").text());
            this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return false;
        }
        if (this.ticks == Settings.settings.items_remind_ticks) {
            this.remind();
        }
        return true;
    }

    private void remind() {
        this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 2.0f, 0.5f);
        ItemCollector.send(this.player, this.ticks);
    }

    private void add(ItemStack item) {
        this.items.add(item);
        this.ticks = Settings.settings.items_taking_ticks;
    }

    public boolean get(boolean silent) {
        PlayerInventory v = this.player.getInventory();
        int f = this.free(v);
        if (f < this.items.size()) {
            if (!silent) {
                this.player.sendMessage(Language.get("Inventory.insufficient-space").text());
                this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            }
            return false;
        }
        v.addItem((ItemStack[])this.items.toArray(ItemStack[]::new));
        if (!silent) {
            this.player.playSound(this.player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 2.0f);
        }
        ItemCollector.unregister(this.player);
        return true;
    }

    private int free(PlayerInventory v) {
        return IntStream.range(0, 36).map(i -> Utils.nulled(v.getItem(i)) ? 1 : 0).sum();
    }
}

