/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.hook.setup;

import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.api.spawner.VirtualSpawner;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.utils.DataManager;
import mc.rellox.spawnermeta.utils.Reflections;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.event.ShopGUIPlusPostEnableEvent;
import net.brcdev.shopgui.spawner.external.provider.ExternalSpawnerProvider;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SetupShopGUI {
    public static void load() {
        Bukkit.getPluginManager().registerEvents((Listener)new ShopGUIPlusHook(), (Plugin)SpawnerMeta.instance());
    }

    public static class ShopGUIPlusHook
    implements Listener {
        @EventHandler
        public void onenable(ShopGUIPlusPostEnableEvent event) {
            try {
                ShopGuiPlusApi.registerSpawnerProvider((ExternalSpawnerProvider)new SpawnerMetaSpawnerProvider());
            }
            catch (Exception e) {
                Reflections.RF.debug(e);
            }
        }
    }

    public static class SpawnerMetaSpawnerProvider
    implements ExternalSpawnerProvider {
        public String getName() {
            return "SpawnerMeta";
        }

        public ItemStack getSpawnerItem(EntityType entity) {
            SpawnerType type = SpawnerType.of(entity);
            if (type == null) {
                return null;
            }
            return DataManager.getSpawner(type, 1);
        }

        public EntityType getSpawnerEntityType(ItemStack item) {
            VirtualSpawner virtual = VirtualSpawner.of(item);
            return virtual == null ? null : virtual.getType().entity();
        }
    }
}

