/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.holograms;

import java.util.HashMap;
import java.util.Map;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.holograms.HologramInstance;
import mc.rellox.spawnermeta.holograms.HologramInstance1_14;
import mc.rellox.spawnermeta.holograms.HologramInstance1_15;
import mc.rellox.spawnermeta.holograms.HologramInstance1_16_1;
import mc.rellox.spawnermeta.holograms.HologramInstance1_16_2;
import mc.rellox.spawnermeta.holograms.HologramInstance1_16_3;
import mc.rellox.spawnermeta.holograms.HologramInstance1_17;
import mc.rellox.spawnermeta.holograms.HologramInstance1_18_1;
import mc.rellox.spawnermeta.holograms.HologramInstance1_18_2;
import mc.rellox.spawnermeta.holograms.HologramInstance1_19_1;
import mc.rellox.spawnermeta.holograms.HologramInstance1_19_2;
import mc.rellox.spawnermeta.holograms.HologramInstance1_19_3;
import mc.rellox.spawnermeta.holograms.HologramMap;
import mc.rellox.spawnermeta.utils.Version;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class HologramRegistry {
    public static final HologramInstance HI = switch (Version.version) {
        case Version.VersionType.v_14_1 -> new HologramInstance1_14();
        case Version.VersionType.v_15_1 -> new HologramInstance1_15();
        case Version.VersionType.v_16_1 -> new HologramInstance1_16_1();
        case Version.VersionType.v_16_2 -> new HologramInstance1_16_2();
        case Version.VersionType.v_16_3 -> new HologramInstance1_16_3();
        case Version.VersionType.v_17_1 -> new HologramInstance1_17();
        case Version.VersionType.v_18_1 -> new HologramInstance1_18_1();
        case Version.VersionType.v_18_2 -> new HologramInstance1_18_2();
        case Version.VersionType.v_19_1 -> new HologramInstance1_19_1();
        case Version.VersionType.v_19_2 -> new HologramInstance1_19_2();
        case Version.VersionType.v_19_3 -> new HologramInstance1_19_3();
        default -> null;
    };
    private static final HologramLoader LOADER = new HologramLoader();

    public static void initialize() {
        LOADER.clear();
        LOADER.unregister();
        if (Settings.settings.holograms_enabled) {
            LOADER.register();
        }
    }

    public static boolean loaded() {
        return HologramRegistry.LOADER.registered;
    }

    public static void erase() {
        LOADER.clear();
    }

    public static void update(Block block) {
        LOADER.update(block);
    }

    public static void add(Block block) {
        LOADER.add(block);
    }

    public static void remove(Block block) {
        LOADER.remove(block);
    }

    public static void load(World world) {
        LOADER.load(world);
    }

    private static final class HologramLoader
    implements Listener {
        private final Map<World, HologramMap> map = new HashMap<World, HologramMap>();
        private boolean registered;

        public void register() {
            if (this.registered) {
                return;
            }
            this.registered = true;
            for (World world : Bukkit.getWorlds()) {
                HologramMap hm = new HologramMap();
                this.map.put(world, hm);
                Chunk[] chunkArray = world.getLoadedChunks();
                int n = chunkArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Chunk chunk = chunkArray[n2];
                    hm.load(chunk);
                    ++n2;
                }
            }
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SpawnerMeta.instance());
        }

        public void unregister() {
            if (!this.registered) {
                return;
            }
            this.registered = false;
            HandlerList.unregisterAll((Listener)this);
        }

        public void clear() {
            if (!this.registered) {
                return;
            }
            this.map.forEach((w, h) -> h.clear());
            this.map.clear();
        }

        public void update(Block block) {
            if (!this.registered) {
                return;
            }
            HologramMap hm = this.map.get(block.getWorld());
            if (hm != null) {
                hm.update(block);
            }
        }

        public void add(Block block) {
            if (!this.registered) {
                return;
            }
            HologramMap hm = this.map.get(block.getWorld());
            if (hm != null) {
                hm.add(block);
            }
        }

        public void remove(Block block) {
            if (!this.registered) {
                return;
            }
            HologramMap hm = this.map.get(block.getWorld());
            if (hm != null) {
                hm.remove(block);
            }
        }

        public void load(World world) {
            if (!this.registered || this.map.containsKey(world)) {
                return;
            }
            HologramMap hm = new HologramMap();
            this.map.put(world, hm);
            Chunk[] chunkArray = world.getLoadedChunks();
            int n = chunkArray.length;
            int n2 = 0;
            while (n2 < n) {
                Chunk chunk = chunkArray[n2];
                hm.load(chunk);
                ++n2;
            }
        }

        public void unload(World world) {
            if (!this.registered || !this.map.containsKey(world)) {
                return;
            }
            HologramMap hm = this.map.remove(world);
            hm.clear();
        }

        @EventHandler
        private void onWorldLoad(WorldLoadEvent event) {
            this.load(event.getWorld());
        }

        @EventHandler
        private void onWorldUnload(WorldUnloadEvent event) {
            this.unload(event.getWorld());
        }

        @EventHandler
        private void onLoad(ChunkLoadEvent event) {
            Chunk chunk = event.getChunk();
            HologramMap hm = this.map.get(chunk.getWorld());
            if (hm != null) {
                hm.load(chunk);
            }
        }

        @EventHandler
        private void onUnload(ChunkUnloadEvent event) {
            Chunk chunk = event.getChunk();
            HologramMap hm = this.map.get(chunk.getWorld());
            if (hm != null) {
                hm.unload(chunk);
            }
        }

        @EventHandler
        private void onJoin(PlayerJoinEvent event) {
            final Player player = event.getPlayer();
            new BukkitRunnable(){

                public void run() {
                    HologramMap hm = map.get(player.getWorld());
                    if (hm != null) {
                        hm.spawn(player);
                    }
                }
            }.runTaskLater((Plugin)SpawnerMeta.instance(), 50L);
        }

        @EventHandler
        private void onWorldChange(PlayerChangedWorldEvent event) {
            final Player player = event.getPlayer();
            new BukkitRunnable(){

                public void run() {
                    HologramMap hm = map.get(player.getWorld());
                    if (hm != null) {
                        hm.spawn(player);
                    }
                }
            }.runTaskLater((Plugin)SpawnerMeta.instance(), 20L);
        }
    }
}

