/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.holograms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.holograms.Hologram;
import mc.rellox.spawnermeta.utils.DataManager;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Player;

public final class HologramMap {
    private final Map<Long, List<Hologram>> holograms = new HashMap<Long, List<Hologram>>();

    public void clear() {
        this.holograms.values().forEach(h -> h.forEach(Hologram::destroy));
        this.holograms.clear();
    }

    public void update(Block block) {
        long at = this.at(block.getX() >> 4, block.getZ() >> 4);
        List<Hologram> hs = this.holograms.get(at);
        if (hs == null) {
            this.add(block);
        } else {
            hs.stream().filter(h -> h.is(block)).findFirst().ifPresentOrElse(Hologram::update, () -> this.add(block));
        }
    }

    public void spawn(Player player) {
        this.holograms.values().forEach(l -> l.forEach(h -> h.spawn(player)));
    }

    public void add(Block block) {
        if (block.getType() != Material.SPAWNER) {
            return;
        }
        if (!Settings.settings.holograms_show_natural && !DataManager.isPlaced(block)) {
            return;
        }
        long at = this.at(block.getX() >> 4, block.getZ() >> 4);
        List<Hologram> hs = this.holograms.get(at);
        if (hs == null) {
            hs = new ArrayList<Hologram>(1);
            this.holograms.put(at, hs);
        }
        hs.add(new Hologram(block));
    }

    public void remove(Block block) {
        long at = this.at(block.getX() >> 4, block.getZ() >> 4);
        List<Hologram> hs = this.holograms.get(at);
        if (hs == null) {
            return;
        }
        Iterator<Hologram> it = hs.iterator();
        while (it.hasNext()) {
            Hologram h = it.next();
            if (!h.block.equals(block)) continue;
            h.destroy();
            it.remove();
            return;
        }
        if (hs.isEmpty()) {
            this.holograms.remove(at);
        }
    }

    public void load(Chunk chunk) {
        ArrayList<Block> spawners = new ArrayList<Block>();
        BlockState[] blockStateArray = chunk.getTileEntities();
        int n = blockStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockState state = blockStateArray[n2];
            if (state instanceof CreatureSpawner && (Settings.settings.holograms_show_natural || DataManager.isPlaced(state.getBlock()))) {
                spawners.add(state.getBlock());
            }
            ++n2;
        }
        if (spawners.isEmpty()) {
            return;
        }
        long at = this.at(chunk.getX(), chunk.getZ());
        List hs = spawners.stream().map(Hologram::new).collect(Collectors.toList());
        this.holograms.put(at, hs);
    }

    public void unload(Chunk chunk) {
        long at = this.at(chunk.getX(), chunk.getZ());
        List<Hologram> hs = this.holograms.remove(at);
        if (hs == null) {
            return;
        }
        for (Hologram h : hs) {
            h.destroy();
        }
    }

    private long at(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }
}

