/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.holograms;

import mc.rellox.spawnermeta.api.spawner.Spawner;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.holograms.HologramRegistry;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.text.content.Content;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class Hologram {
    protected final Block block;
    private final Object hologram;

    public Hologram(Block block) {
        this.block = block;
        String title = this.title(Spawner.of(block)).text();
        this.hologram = HologramRegistry.HI.create(block.getLocation().add(0.5, 1.25, 0.5), title);
        HologramRegistry.HI.spawn(this.hologram);
    }

    public boolean is(Block block) {
        return this.block.equals(block);
    }

    public void update() {
        String title = this.title(Spawner.of(this.block)).text();
        HologramRegistry.HI.update(this.hologram, title);
    }

    public void spawn(Player player) {
        HologramRegistry.HI.spawn(player, this.hologram);
    }

    public void destroy() {
        HologramRegistry.HI.destroy(this.hologram);
    }

    private Content title(Spawner spawner) {
        SpawnerType type = spawner.getType();
        String r = type == SpawnerType.EMPTY ? "empty" : "regular";
        int stack = spawner.getStack();
        return stack > 1 ? Language.get("Spawners.hologram." + r + ".multiple", new Object[]{"name", type, "stack", stack}) : Language.get("Spawners.hologram." + r + ".single", "name", (Object)type);
    }
}

