/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.events;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.api.APIInstance;
import mc.rellox.spawnermeta.api.APIRegistry;
import mc.rellox.spawnermeta.api.events.IEvent;
import mc.rellox.spawnermeta.api.events.SpawnerBreakEvent;
import mc.rellox.spawnermeta.api.events.SpawnerChangeEvent;
import mc.rellox.spawnermeta.api.events.SpawnerEmptyEvent;
import mc.rellox.spawnermeta.api.events.SpawnerExplodeEvent;
import mc.rellox.spawnermeta.api.events.SpawnerOpenEvent;
import mc.rellox.spawnermeta.api.events.SpawnerPlaceEvent;
import mc.rellox.spawnermeta.api.events.SpawnerPostSpawnEvent;
import mc.rellox.spawnermeta.api.events.SpawnerPreSpawnEvent;
import mc.rellox.spawnermeta.api.events.SpawnerStackEvent;
import mc.rellox.spawnermeta.api.spawner.Spawner;
import mc.rellox.spawnermeta.api.spawner.VirtualSpawner;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.configuration.LocationFile;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.holograms.HologramRegistry;
import mc.rellox.spawnermeta.items.ItemCollector;
import mc.rellox.spawnermeta.items.ItemMatcher;
import mc.rellox.spawnermeta.prices.Group;
import mc.rellox.spawnermeta.prices.Price;
import mc.rellox.spawnermeta.spawner.SpawnerManager;
import mc.rellox.spawnermeta.spawner.SpawnerSpawning;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.spawner.UpgradeType;
import mc.rellox.spawnermeta.text.content.Content;
import mc.rellox.spawnermeta.utils.DataManager;
import mc.rellox.spawnermeta.utils.EntityBox;
import mc.rellox.spawnermeta.utils.Messagable;
import mc.rellox.spawnermeta.utils.Reflections;
import mc.rellox.spawnermeta.utils.Utils;
import mc.rellox.spawnermeta.views.SpawnerUpgrade;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Item;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;
import org.spigotmc.SpigotWorldConfig;

public final class EventRegistry {
    private static long time;
    private static long chunk;
    private static Block verify;
    private static final Set<Block> SET;

    static {
        SET = new HashSet<Block>(4);
    }

    public static APIInstance getAPI() {
        return SpawnerMeta.instance().getAPI();
    }

    public static boolean registered() {
        return ((APIRegistry)EventRegistry.getAPI()).registered();
    }

    public static <E extends IEvent> E call(E event) {
        APIRegistry api = (APIRegistry)EventRegistry.getAPI();
        api.execute(event);
        return event;
    }

    protected static void open_upgrades(Player player, Messagable m, Block block, Spawner spawner) {
        if (!Settings.settings.upgrade_interface_enabled) {
            return;
        }
        DataManager.recalculate(block);
        if (!player.hasPermission("spawnermeta.upgrades.open")) {
            m.send(Language.list("Spawners.upgrades.permission.opening"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (!(Settings.settings.owned_can_open || spawner.isOwner(player, true) || player.hasPermission("spawnermeta.ownership.bypass.interact"))) {
            m.send(Language.list("Spawners.ownership.opening.warning"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (!Settings.settings.natural_can_open && spawner.isNatural() && !player.hasPermission("spawnermeta.natural.bypass.interact")) {
            m.send(Language.list("Spawners.natural.opening.warning"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        SpawnerOpenEvent call = EventRegistry.call(new SpawnerOpenEvent(player, block));
        if (call.cancelled()) {
            return;
        }
        SpawnerUpgrade.newUpgrade(player, block);
        HologramRegistry.update(block);
    }

    protected static void changing_regular(Player player, Messagable m, Block block, Spawner spawner, SpawnerType type, ItemStack item, SpawnerType change) {
        SpawnerChangeEvent call;
        if (!Settings.settings.changing_enabled) {
            return;
        }
        if (change.unique() && (!player.isOp() || player.getGameMode() != GameMode.CREATIVE)) {
            return;
        }
        if (!player.hasPermission("spawnermeta.eggs")) {
            m.send(Language.list("Spawners.changing.permission"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (!Settings.settings.natural_can_change && spawner.isNatural() && !player.hasPermission("spawnermeta.natural.bypass.changing")) {
            m.send(Language.list("Spawners.natural.changing.warning"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (!(Settings.settings.owned_can_change || spawner.isOwner(player, true) || player.hasPermission("spawnermeta.ownership.bypass.changing"))) {
            m.send(Language.list("Spawners.ownership.changing.warning"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (type == change) {
            m.send(Language.list("Spawners.changing.same-type"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        int stack = spawner.getStack();
        if (!ItemMatcher.has(player, item, stack)) {
            m.send(Language.list("Spawners.changing.eggs.insufficient", "required", (Object)stack));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        Price price = null;
        if (Settings.settings.changing_price.using()) {
            price = Price.of(Group.changing, Settings.settings.changing_price.get(type) * stack);
        }
        if ((call = EventRegistry.call(new SpawnerChangeEvent(player, block, price, change, false))).cancelled()) {
            return;
        }
        if (!call.withdraw(player)) {
            price = call.getUnsafePrice();
            m.send(Language.list("Prices.insufficient", "insufficient", price.insufficient(), "price", price.requires(player)));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        m.send(Language.list("Spawners.changing.type-changed", "type", (Object)call.getNewType()));
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 2.0f, 2.0f);
        player.spawnParticle(Particle.VILLAGER_HAPPY, block.getLocation().add(0.5, 0.5, 0.5), 25, 0.25, 0.25, 0.25, 0.1);
        ItemMatcher.remove(player, item, stack);
        spawner.setType(change);
        spawner.update();
        HologramRegistry.update(block);
        EventRegistry.unlink(block);
    }

    protected static void changing_empty(Player player, Messagable m, Block block, Spawner spawner, SpawnerType type, ItemStack item, SpawnerType change) {
        SpawnerChangeEvent call;
        if (change.unique() && !Utils.op(player)) {
            return;
        }
        if (type != SpawnerType.EMPTY) {
            return;
        }
        if (!(Settings.settings.owned_can_change || spawner.isOwner(player, true) || player.hasPermission("spawnermeta.ownership.bypass.changing"))) {
            m.send(Language.list("Spawners.ownership.changing.warning"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        int stack = spawner.getStack();
        if (!ItemMatcher.has(player, item, stack)) {
            m.send(Language.list("Spawners.changing.eggs.insufficient", "required", (Object)stack));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        Price price = null;
        if (Settings.settings.changing_price.using()) {
            price = Price.of(Group.changing, Settings.settings.changing_price.get(type) * stack);
        }
        if ((call = EventRegistry.call(new SpawnerChangeEvent(player, block, price, change, true))).cancelled()) {
            return;
        }
        if (!call.withdraw(player)) {
            price = call.getUnsafePrice();
            m.send(Language.list("Prices.insufficient", "insufficient", price.insufficient(), "price", price.requires(player)));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        m.send(Language.list("Spawners.changing.type-changed", "type", (Object)change));
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 2.0f, 2.0f);
        player.spawnParticle(Particle.VILLAGER_HAPPY, block.getLocation().add(0.5, 0.5, 0.5), 25, 0.25, 0.25, 0.25, 0.1);
        ItemMatcher.remove(player, item, stack);
        spawner.setType(change);
        spawner.update();
        HologramRegistry.update(block);
        EventRegistry.unlink(block);
    }

    protected static boolean remove_eggs_empty(final Player player, Messagable m, final Block block, SpawnerType type, ItemStack item, Spawner spawner) {
        boolean b;
        if (!spawner.isEmpty()) {
            return true;
        }
        if (item != null && item.getType() == Material.SPAWNER) {
            return true;
        }
        if (!Settings.settings.empty_enabled) {
            m.send(Language.list("Spawners.empty.disabled"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return false;
        }
        if (!player.isSneaking()) {
            if (type == SpawnerType.EMPTY) {
                m.send(Language.list("Spawners.empty.try-open"));
                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
                return false;
            }
            return true;
        }
        if (type == SpawnerType.EMPTY) {
            return true;
        }
        if (!(Settings.settings.owned_can_change || spawner.isOwner(player, true) || player.hasPermission("spawnermeta.ownership.bypass.changing"))) {
            m.send(Language.list("Spawners.ownership.changing.warning"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return false;
        }
        boolean bl = b = !Utils.nulled(player.getInventory().getItemInMainHand());
        if (b) {
            m.send(Language.list("Spawners.empty.hand-full"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return false;
        }
        if (Settings.settings.empty_verify_removing) {
            verify = block;
            new BukkitRunnable(){

                public void run() {
                    if (block.equals(verify)) {
                        verify = null;
                        player.spawnParticle(Particle.REDSTONE, Utils.center(block).add(0.0, 0.52, 0.0), 5, 0.1, 0.1, 0.1, 0.0, (Object)new Particle.DustOptions(Color.MAROON, 2.0f));
                    }
                }
            }.runTaskLater((Plugin)SpawnerMeta.instance(), 20L);
            m.send(Language.list("Spawners.empty.verify-removing.first"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 2.0f, 0.0f);
            return false;
        }
        EventRegistry.remove_eggs(player, block, type);
        return false;
    }

    protected static void stack_nearby(PlayerInteractEvent event, Player player, Messagable m, Block block) {
        if (!Settings.settings.stacking_nearby_enabled) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.SPAWNER || !player.isSneaking()) {
            return;
        }
        event.setCancelled(true);
        VirtualSpawner data = VirtualSpawner.of(item);
        if (data == null) {
            return;
        }
        int r = Settings.settings.stacking_nearby_radius;
        Block valid = null;
        int x = -r;
        block0: do {
            int y = -r;
            do {
                int z = -r;
                do {
                    VirtualSpawner of;
                    Block rel;
                    if ((rel = block.getRelative(x, y, z)).getType() != Material.SPAWNER || (of = VirtualSpawner.of(rel)) == null || !data.exact(of)) continue;
                    valid = rel;
                    break block0;
                } while (++z <= r);
            } while (++y <= r);
        } while (++x <= r);
        if (valid == null) {
            m.send(Language.list("Spawners.stacking.nearby.none-match"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        EventRegistry.stacking(player, m, valid, Spawner.of(valid), item, false);
    }

    protected static void verify_removing(PlayerInteractEvent event, Player player, Messagable m) {
        boolean b;
        if (!Settings.settings.empty_verify_removing) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!player.isSneaking() || block.getType() != Material.SPAWNER) {
            return;
        }
        Spawner spawner = EventRegistry.getAPI().getSpawner(block);
        SpawnerType type = spawner.getType();
        if (type == SpawnerType.EMPTY || !spawner.isEmpty()) {
            return;
        }
        boolean bl = b = !Utils.nulled(player.getInventory().getItemInMainHand());
        if (!b && Utils.op(player)) {
            event.setCancelled(true);
        }
        if (verify == null) {
            m.send(Language.list("Spawners.empty.verify-removing.try-again"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (b) {
            m.send(Language.list("Spawners.empty.hand-full"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        EventRegistry.remove_eggs(player, block, type);
    }

    protected static boolean stacking(Player player, Messagable m, Block block, Spawner spawner, ItemStack item, boolean direct) {
        SpawnerStackEvent call;
        int p;
        VirtualSpawner data;
        int stack = spawner.getStack();
        if (!Settings.settings.stacking_ignore_limit && stack >= Settings.settings.stacking_spawner_limit) {
            m.send(Language.list("Spawners.stacking.limit-reached"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return true;
        }
        int tt = Settings.settings.stacking_ticks;
        if (tt > 0) {
            long b = System.currentTimeMillis() / 50L;
            if (time >= b - (long)tt) {
                return false;
            }
            time = b;
        }
        if ((data = VirtualSpawner.of(item)) == null) {
            return false;
        }
        if (!player.hasPermission("spawnermeta.stacking")) {
            m.send(Language.list("Spawners.stacking.permission"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return false;
        }
        if (!Settings.settings.natural_can_stack && spawner.isNatural() && !player.hasPermission("spawnermeta.natural.bypass.stacking")) {
            m.send(Language.list("Spawners.natural.breaking.warning"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return false;
        }
        if (!(Settings.settings.owned_can_stack || spawner.isOwner(player, true) || player.hasPermission("spawnermeta.ownership.bypass.stacking"))) {
            m.send(Language.list("Spawners.ownership.stacking.warning"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return false;
        }
        VirtualSpawner other = VirtualSpawner.of(block);
        if (!data.exact(other)) {
            m.send(Language.list("Spawners.stacking.unequal-spawner"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return false;
        }
        if (!Settings.settings.owned_ignore_limit && (p = LocationFile.LF.placed(player)) >= Settings.settings.owned_spawner_limit) {
            m.send(Language.list("Spawners.ownership.limit.reached", "limit", (Object)Settings.settings.owned_spawner_limit));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return false;
        }
        Price price = null;
        if (Settings.settings.stacking_price.using()) {
            price = Price.of(Group.stacking, Settings.settings.stacking_price.get(spawner.getType()));
        }
        if ((call = EventRegistry.call(new SpawnerStackEvent(player, block, price, data, direct))).cancelled()) {
            return false;
        }
        if (!call.withdraw(player)) {
            price = call.getUnsafePrice();
            m.send(Language.list("Prices.insufficient", "insufficient", price.insufficient(), "price", price.requires(player)));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return false;
        }
        spawner.setStack(++stack);
        m.send(Settings.settings.stacking_ignore_limit ? Language.list("Spawners.stacking.stacked.infinite", "stack", (Object)stack) : Language.list("Spawners.stacking.stacked.finite", "stack", stack, "limit", Settings.settings.stacking_spawner_limit));
        player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 0.75f, 1.5f);
        if (Settings.settings.spawnable_enabled) {
            int s = spawner.getSpawnable() + data.getSpawnable();
            spawner.setSpawnable(s);
        }
        if (Settings.settings.charges_enabled && Settings.settings.charges_allow_stacking) {
            int b = spawner.getCharges() * (stack - 1) + data.getCharges();
            int r = b / stack;
            spawner.setCharges(r);
            int f = b % stack;
            if (f > 0) {
                m.send(Language.list("Spawners.charges.lose-by-stacking", "charges", (Object)f));
            }
        }
        if (!direct && Settings.settings.stacking_nearby_particles) {
            Location start = block.getLocation().add(0.5, 0.5, 0.5);
            Location end = player.getLocation().add(0.0, 1.0, 0.0);
            Vector dis = end.toVector().subtract(start.toVector()).normalize().multiply(0.25);
            double loops = start.distance(end) / 0.25;
            int i = 0;
            while ((double)i < loops) {
                start.add(dis);
                player.spawnParticle(Particle.CRIT_MAGIC, start, 1, 0.0, 0.0, 0.0, 0.0);
                ++i;
            }
        }
        ItemMatcher.remove(player, item, 1);
        LocationFile.LF.add(block, player);
        SpawnerUpgrade.update(block);
        HologramRegistry.update(block);
        return false;
    }

    protected static void interact(PlayerInteractEvent event, Player player, Messagable m, Block block, Spawner spawner) {
        if (DataManager.isItemSpawner(block)) {
            return;
        }
        SpawnerType type = spawner.getType();
        if (type.disabled()) {
            return;
        }
        event.setCancelled(true);
        ItemStack item = event.getItem();
        if (!EventRegistry.remove_eggs_empty(player, m, block, type, item, spawner)) {
            return;
        }
        if (item != null) {
            if (player.isSneaking()) {
                SpawnerType change;
                if (Settings.settings.stacking_enabled) {
                    if (item.getType() != Material.SPAWNER) {
                        event.setCancelled(false);
                    } else if (!EventRegistry.stacking(player, m, block, spawner, item, true)) {
                        return;
                    }
                }
                if ((change = SpawnerManager.fromEgg(item.getType())) == null) {
                    return;
                }
                event.setCancelled(true);
                if (change.disabled()) {
                    return;
                }
                if (spawner.isEmpty()) {
                    EventRegistry.changing_empty(player, m, block, spawner, type, item, change);
                } else {
                    EventRegistry.changing_regular(player, m, block, spawner, type, item, change);
                }
                return;
            }
            if (item.getType().name().endsWith("_EGG")) {
                event.setCancelled(true);
            }
        }
        if (spawner.isEmpty() && type == SpawnerType.EMPTY) {
            return;
        }
        if (item != null && item.getType() == Material.SPAWNER) {
            event.setCancelled(false);
            return;
        }
        EventRegistry.open_upgrades(player, m, block, spawner);
    }

    protected static void remove_eggs(Player player, Block block, SpawnerType type) {
        SpawnerEmptyEvent call;
        Material m;
        Spawner spawner = EventRegistry.getAPI().getSpawner(block);
        ItemStack refund = null;
        if (!Settings.settings.empty_destroy_eggs_removing && (m = type.changer()) != null) {
            refund = new ItemStack(m, spawner.getStack());
        }
        if ((call = EventRegistry.call(new SpawnerEmptyEvent(player, block, refund))).cancelled()) {
            return;
        }
        call.getRefund().ifPresent(i -> player.getInventory().setItemInMainHand(i));
        player.playSound(player.getEyeLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 2.0f, 1.0f);
        player.spawnParticle(Particle.FIREWORKS_SPARK, block.getLocation().add(0.5, 0.5, 0.5), 25, 0.3, 0.3, 0.3, 0.1);
        spawner.setType(SpawnerType.EMPTY);
        spawner.setRotating(false);
        HologramRegistry.update(block);
        EventRegistry.unlink(block);
        if (block.equals(verify)) {
            verify = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void breaking(BlockBreakEvent event, Block block) {
        Damageable damageable;
        ItemStack item2;
        ItemMeta meta;
        ItemMeta itemMeta;
        List<Content> mm;
        Spawner spawner = EventRegistry.getAPI().getSpawner(block);
        SpawnerType type = spawner.getType();
        boolean ce = Settings.settings.cancel_break_event;
        event.setCancelled(true);
        if (type.disabled()) {
            return;
        }
        Player player = event.getPlayer();
        Messagable m = new Messagable(player);
        if (Utils.op(player)) {
            Location bl = block.getLocation().add(0.5, 0.5, 0.5);
            DataManager.getSpawners(block, false).forEach(item -> player.getWorld().dropItem(bl, item).setVelocity(new Vector()));
            player.spawnParticle(Particle.CLOUD, bl, 25, 0.25, 0.25, 0.25, 0.0);
            player.playSound(player.getEyeLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.35f, 0.0f);
            m.send(Language.list("Spawners.breaking.success"));
            event.setCancelled(false);
            return;
        }
        if (Settings.settings.unbreakable && !player.hasPermission("spawnermeta.unbreakable.bypass")) {
            m.send(Language.list("Spawners.breaking.permission"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (!Settings.settings.ignore_permission && !player.hasPermission("spawnermeta.break")) {
            m.send(Language.list("Spawners.breaking.permission"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (!Settings.settings.natural_can_break && spawner.isNatural() && !player.hasPermission("spawnermeta.natural.bypass.breaking")) {
            m.send(Language.list("Spawners.natural.breaking.warning"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (!(Settings.settings.owned_can_break || spawner.isOwner(player, true) || player.hasPermission("spawnermeta.ownership.bypass.breaking"))) {
            OfflinePlayer off;
            String name;
            UUID id;
            m.send(Language.list("Spawners.ownership.breaking.warning"));
            if (Settings.settings.breaking_show_owner && (id = spawner.getOwnerID()) != null && (name = (off = Bukkit.getOfflinePlayer((UUID)id)).getName()) != null) {
                m.send(Language.list("Spawners.ownership.show-owner", "player", (Object)name));
            }
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (!Settings.settings.breaking_drop_on_ground && ItemCollector.exists(player)) {
            m.send(Language.list("Items.spawner-drop.try-breaking"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        boolean silk = Settings.settings.has_silk(player);
        if (Settings.settings.breaking_silk_enabled && !Settings.settings.breaking_silk_destroy && !silk) {
            m.send(Language.list("Spawners.breaking.failure"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        Location bl = block.getLocation().add(0.5, 0.5, 0.5);
        Price price = null;
        if (Settings.settings.breaking_price.using()) {
            price = Price.of(Group.breaking, Settings.settings.breaking_price.get(type) * spawner.getStack());
        }
        double chance = Settings.settings.breaking_chance(player);
        chance = spawner.isOwned() ? (spawner.isOwner(player) ? Settings.settings.breaking_chance_changer_owned.change(chance) : Settings.settings.breaking_chance_changer_not_owned.change(chance)) : Settings.settings.breaking_chance_changer_natural.change(chance);
        SpawnerBreakEvent call = EventRegistry.call(new SpawnerBreakEvent(player, block, price, chance));
        if (call.cancelled()) {
            return;
        }
        if (!call.withdraw(player)) {
            price = call.getUnsafePrice();
            m.send(Language.list("Prices.insufficient", "insufficient", price.insufficient(), "price", price.requires(player)));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (Utils.chance(call.chance)) {
            boolean give = true;
            if (Settings.settings.breaking_silk_enabled) {
                give = Settings.settings.has_silk(player);
                give = spawner.isOwned() ? (give &= Settings.settings.breaking_silk_break_owned) : (give &= Settings.settings.breaking_silk_break_natural);
            }
            if (player.getGameMode() == GameMode.CREATIVE) {
                give = true;
            }
            if (give) {
                DataManager.getSpawners(block, false).forEach(item -> {
                    if (Settings.settings.breaking_drop_on_ground) {
                        player.getWorld().dropItem(bl, item).setVelocity(new Vector());
                    } else {
                        ItemCollector.add(player, item);
                    }
                });
                player.spawnParticle(Particle.CLOUD, bl, 25, 0.25, 0.25, 0.25, 0.0);
                player.playSound(player.getEyeLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.35f, 0.0f);
                mm = Language.list("Spawners.breaking.success");
            } else {
                player.spawnParticle(Particle.SQUID_INK, bl, 25, 0.25, 0.25, 0.25, 0.1);
                player.playSound(player.getEyeLocation(), Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, 0.2f, 0.0f);
                mm = Language.list("Spawners.breaking.failure");
                EventRegistry.spawnXP(block, event, give);
            }
        } else {
            player.spawnParticle(Particle.SQUID_INK, bl, 25, 0.25, 0.25, 0.25, 0.1);
            player.playSound(player.getEyeLocation(), Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, 0.35f, 0.0f);
            mm = Language.list("Spawners.breaking.failure");
            EventRegistry.spawnXP(block, event, ce);
        }
        m.send(mm);
        if (Settings.settings.breaking_durability_enabled && player.getGameMode() != GameMode.CREATIVE && (itemMeta = (meta = (item2 = player.getInventory().getItemInMainHand()).getItemMeta())) instanceof Damageable && (damageable = (Damageable)itemMeta) == (Damageable)itemMeta) {
            void damageable2;
            int d = damageable2.getDamage() + Settings.settings.breaking_durability_to_remove;
            if (d >= item2.getType().getMaxDurability()) {
                player.getInventory().setItemInMainHand(null);
                player.playSound(player.getEyeLocation(), Sound.ENTITY_ITEM_BREAK, 2.0f, 1.0f);
            } else {
                damageable2.setDamage(d);
            }
            item2.setItemMeta(meta);
        }
        SpawnerUpgrade.removeUpgrade(block);
        SpawnerManager.dropEggs(player, block);
        LocationFile.LF.remove(block);
        if (ce) {
            block.setType(Material.AIR);
        }
        EventRegistry.unlink(block);
        HologramRegistry.remove(block);
        ItemCollector.execute(player);
        event.setCancelled(ce);
    }

    private static void spawnXP(Block block, BlockBreakEvent event, boolean ce) {
        event.setExpToDrop(0);
        int xp = Settings.settings.breaking_xp_on_failure;
        if (xp > 0) {
            if (ce) {
                EventRegistry.spawnXP(block, xp);
            } else {
                event.setExpToDrop(xp);
            }
        }
    }

    public static void spawnXP(Block block, int xp) {
        ExperienceOrb orb = (ExperienceOrb)block.getWorld().spawnEntity(block.getLocation().add(0.5, 0.5, 0.5), EntityType.EXPERIENCE_ORB);
        orb.setExperience(xp);
    }

    protected static void explode_block(Iterator<Block> it) {
        Block block;
        while (it.hasNext() && (block = it.next()) != null) {
            BlockState bs;
            if (block.getType() != Material.SPAWNER || !((bs = block.getState()) instanceof CreatureSpawner)) continue;
            boolean[] xs = Settings.settings.explosion_types.get((Object)SpawnerExplodeEvent.ExplosionType.TNT);
            SpawnerExplodeEvent call = EventRegistry.call(new SpawnerExplodeEvent(block, SpawnerExplodeEvent.ExplosionType.TNT, xs));
            if (call.cancelled()) {
                it.remove();
                continue;
            }
            if (DataManager.isPlaced(block)) {
                if (xs[0]) {
                    SpawnerManager.breakSpawner(block, xs[1]);
                }
            } else if (xs[2]) {
                SpawnerManager.breakSpawner(block, xs[3]);
            }
            block.getWorld().spawnParticle(Particle.VILLAGER_ANGRY, block.getLocation().add(0.5, 0.5, 0.5), 10, 0.2, 0.2, 0.2, 0.0);
            it.remove();
        }
    }

    protected static void explode_entity(EntityExplodeEvent event) {
        Block block;
        Entity entity = event.getEntity();
        Iterator it = event.blockList().iterator();
        while (it.hasNext() && (block = (Block)it.next()) != null) {
            boolean[] xs;
            SpawnerExplodeEvent.ExplosionType explosion;
            BlockState bs;
            if (block.getType() != Material.SPAWNER || !((bs = block.getState()) instanceof CreatureSpawner)) continue;
            if (entity instanceof TNTPrimed) {
                explosion = SpawnerExplodeEvent.ExplosionType.TNT;
                xs = Settings.settings.explosion_types.get((Object)explosion);
            } else if (entity instanceof Creeper) {
                explosion = SpawnerExplodeEvent.ExplosionType.CREEPERS;
                xs = Settings.settings.explosion_types.get((Object)explosion);
            } else if (entity instanceof Fireball || entity instanceof LargeFireball) {
                explosion = SpawnerExplodeEvent.ExplosionType.FIREBALLS;
                xs = Settings.settings.explosion_types.get((Object)explosion);
            } else {
                if (!(entity instanceof EnderCrystal)) continue;
                explosion = SpawnerExplodeEvent.ExplosionType.END_CRYSTALS;
                xs = Settings.settings.explosion_types.get((Object)explosion);
            }
            SpawnerExplodeEvent call = EventRegistry.call(new SpawnerExplodeEvent(block, explosion, xs));
            if (call.cancelled()) {
                it.remove();
                continue;
            }
            if (xs != null) {
                if (DataManager.isPlaced(block)) {
                    if (xs[0]) {
                        SpawnerManager.breakSpawner(block, xs[1]);
                    }
                } else if (xs[2]) {
                    SpawnerManager.breakSpawner(block, xs[3]);
                }
            }
            block.getWorld().spawnParticle(Particle.VILLAGER_ANGRY, block.getLocation().add(0.5, 0.5, 0.5), 10, 0.2, 0.2, 0.2, 0.0);
            it.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void onEntityDamaged(EntityDamageEvent event) {
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cause != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && cause != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Item var4_5) {
            ItemStack item = drop.getItemStack();
            if (item == null || item.getType() != Material.SPAWNER) {
                return;
            }
            event.setCancelled(true);
        }
    }

    protected static void place(BlockPlaceEvent event, final Block block) {
        SpawnerPlaceEvent call;
        int p;
        int sa;
        final Player player = event.getPlayer();
        Messagable m = new Messagable(player);
        ItemStack item = event.getItemInHand().clone();
        final VirtualSpawner data = VirtualSpawner.of(item);
        if (data == null) {
            return;
        }
        event.setCancelled(true);
        SpawnerType type = data.getType();
        if (type.disabled()) {
            return;
        }
        if (data.isEmpty() && !Settings.settings.empty_enabled) {
            m.send(Language.list("Spawners.empty.disabled"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (!player.hasPermission("spawnermeta.place")) {
            m.send(Language.list("Spawners.placing.permission"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (Settings.settings.chunk_enabled && (sa = SpawnerManager.getChunkSpawnerAmount(block)) > Settings.settings.chunk_limit) {
            long b = System.currentTimeMillis() / 50L;
            if (chunk >= b - 20L) {
                return;
            }
            chunk = b;
            m.send(Language.list("Spawners.chunks.limit-reached"));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        if (!Settings.settings.owned_ignore_limit && !player.hasPermission("spawnermeta.ownership.bypass.limit") && (p = LocationFile.LF.placed(player)) >= Settings.settings.owned_spawner_limit) {
            m.send(Language.list("Spawners.ownership.limit.reached", "limit", (Object)Settings.settings.owned_spawner_limit));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        Price price = null;
        if (Settings.settings.placing_price.using()) {
            price = Price.of(Group.placing, Settings.settings.placing_price.get(type));
        }
        if ((call = EventRegistry.call(new SpawnerPlaceEvent(player, block, price, data))).cancelled()) {
            return;
        }
        if (!call.withdraw(player)) {
            price = call.getUnsafePrice();
            m.send(Language.list("Prices.insufficient", "insufficient", price.insufficient(), "price", price.requires(player)));
            player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 1.0f);
            return;
        }
        event.setCancelled(false);
        new BukkitRunnable(){

            public void run() {
                if (block.getType() != Material.SPAWNER) {
                    return;
                }
                SpawnerManager.placeSpawner(block, player, data);
            }
        }.runTaskLater((Plugin)SpawnerMeta.instance(), 1L);
    }

    protected static void spawn(SpawnerSpawnEvent event, Entity entity) {
        int spawnable;
        long ic;
        int cl;
        if (Settings.settings.disable_spawning) {
            return;
        }
        if (entity.getType() == EntityType.DROPPED_ITEM) {
            if (Settings.settings.disable_item_spawners) {
                event.setCancelled(true);
                if (!entity.isDead()) {
                    entity.remove();
                }
            } else {
                event.setCancelled(false);
                return;
            }
            return;
        }
        CreatureSpawner cs = event.getSpawner();
        final Block block = event.getSpawner().getBlock();
        Spawner spawner = EventRegistry.getAPI().getSpawner(block);
        SpawnerType type = spawner.getType();
        if (type.disabled()) {
            return;
        }
        if (Settings.settings.spawner_switching && !spawner.isEnabled()) {
            return;
        }
        if (spawner.isEmpty() && DataManager.isEmptyType(block)) {
            return;
        }
        DataManager.recalculate(block);
        if (SET.contains(block)) {
            return;
        }
        SET.add(block);
        new BukkitRunnable(){

            public void run() {
                SET.remove(block);
            }
        }.runTaskLater((Plugin)SpawnerMeta.instance(), 1L);
        DataManager.setNewSpawner(null, block, false);
        DataManager.resetDelay(block);
        int stack = spawner.getStack();
        int count = stack * spawner.getUpgradeAttribute(UpgradeType.AMOUNT);
        if (count > Settings.settings.safety_limit) {
            count = Settings.settings.safety_limit;
        }
        if ((cl = Settings.settings.chunk_entity_limit) > 0 && (ic = Stream.of(block.getChunk().getEntities()).filter(e -> e instanceof LivingEntity).filter(e -> !(e instanceof Player)).count()) >= (long)cl) {
            return;
        }
        SpawnerPreSpawnEvent call = EventRegistry.call(new SpawnerPreSpawnEvent(block, count));
        if (call.cancelled()) {
            return;
        }
        count = call.count;
        int charges = spawner.getCharges();
        if (!call.bypass_checks && Settings.settings.charges_enabled && charges <= 0) {
            boolean n2;
            boolean bl = n2 = Settings.settings.charges_ignore_natural && spawner.isNatural();
            if (!n2) {
                block.getWorld().spawnParticle(Particle.REDSTONE, block.getLocation().add(0.5, 0.5, 0.5), 25, 0.5, 0.5, 0.5, 0.075, (Object)new Particle.DustOptions(Color.MAROON, 2.5f));
                return;
            }
        }
        boolean clear = false;
        if (!call.bypass_checks && Settings.settings.spawnable_enabled && (spawnable = spawner.getSpawnable()) < 1000000000) {
            if (spawnable <= 0) {
                clear = true;
                count = 0;
            } else {
                if (spawnable < count) {
                    count = spawnable;
                    spawnable = 0;
                } else {
                    spawnable -= count;
                }
                spawner.setSpawnable(spawnable);
                if (spawnable < stack) {
                    if (spawnable <= 0) {
                        clear = true;
                    } else {
                        spawner.setStack(spawnable);
                        HologramRegistry.update(block);
                    }
                }
            }
        }
        Location l = event.getLocation();
        if (count <= 0) {
            l.getWorld().spawnParticle(Particle.REDSTONE, block.getLocation().add(0.5, 0.5, 0.5), 25, 0.45, 0.45, 0.45, 0.075, (Object)new Particle.DustOptions(Color.MAROON, 2.5f));
            return;
        }
        List<Entity> entities = EventRegistry.spawnEntities(block, l.getBlock(), type, event.getEntityType(), count, cs);
        if (entities.isEmpty()) {
            return;
        }
        SpawnerUpgrade.update(block);
        EventRegistry.call(new SpawnerPostSpawnEvent(block, entities));
        if (Settings.settings.kill_entities_on_spawn) {
            if (Settings.settings.entities_drop_xp) {
                Optional<Player> opt = block.getWorld().getNearbyEntities(block.getLocation(), 32.0, 32.0, 32.0).stream().filter(n -> n instanceof Player).findAny().map(n -> (Player)n);
                entities.forEach(e -> {
                    void var3_2;
                    LivingEntity livingEntity;
                    Entity entity = e;
                    if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) == (LivingEntity)var3_2) {
                        void living;
                        opt.ifPresent(arg_0 -> EventRegistry.lambda$8((LivingEntity)living, arg_0));
                        living.setHealth(0.0);
                    }
                });
            } else {
                entities.forEach(e -> {
                    void var2_1;
                    LivingEntity livingEntity;
                    Entity entity = e;
                    if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity) == (LivingEntity)var2_1) {
                        void living;
                        living.setHealth(0.0);
                    }
                });
            }
        }
        if (!call.bypass_checks && Settings.settings.charges_enabled && charges < 1000000000) {
            spawner.setCharges(--charges);
        }
        if (clear) {
            SpawnerUpgrade.close(block);
            block.setType(Material.AIR);
            EventRegistry.unlink(block);
            l.getWorld().spawnParticle(Particle.LAVA, block.getLocation().add(0.5, 0.5, 0.5), 25, 0.1, 0.1, 0.1, 0.0);
            HologramRegistry.remove(block);
        }
    }

    private static List<Entity> spawnEntities(Block block, Block at, SpawnerType st, EntityType type, int a, CreatureSpawner cs) {
        try {
            Consumer f;
            Class entity_class = type.getEntityClass();
            Reflections.RF.Invoker<Entity> invoker = EventRegistry.spawner(block.getWorld());
            SpawnerSpawning spread = Settings.settings.spawner_spawning;
            int s = switch (st) {
                case SpawnerType.MAGMA_CUBE, SpawnerType.SLIME -> {
                    int z = Settings.settings.slime_size;
                    if (z <= 0) {
                        yield Utils.random(3) + 1;
                    }
                    yield z;
                }
                default -> 0;
            };
            EntityBox box = st.box();
            Consumer n = EventRegistry.function(cs);
            if (s > 0) {
                box = box.multiply(s);
                f = e -> {
                    n.accept(e);
                    if (e instanceof Slime var3_4) {
                        m.setSize(s);
                    }
                };
            } else {
                f = n;
            }
            spread.set(block, at, box);
            List<Object> entities = EventRegistry.isLiving(type) && SpawnerMeta.WILD_STACKER.exists() && SpawnerMeta.WILD_STACKER.enabled() ? SpawnerMeta.WILD_STACKER.combine(block, type, spread, a, cs) : Stream.generate(spread::get).limit(a).peek(EventRegistry::particle).map(l -> EventRegistry.spawn(entity_class, invoker, l, (Consumer<Entity>)f)).collect(Collectors.toList());
            spread.clear();
            return entities;
        }
        catch (Exception e2) {
            Reflections.RF.debug(e2);
            return new ArrayList<Entity>();
        }
    }

    public static void particle(Location loc) {
        if (!Settings.settings.spawning_particles) {
            return;
        }
        loc.getWorld().spawnParticle(Particle.CLOUD, loc.add(0.0, 0.25, 0.0), 5, 0.2, 0.2, 0.2, 0.1);
    }

    private static boolean isLiving(EntityType type) {
        return LivingEntity.class.isAssignableFrom(type.getEntityClass());
    }

    private static Reflections.RF.Invoker<Entity> spawner(World world) {
        return Reflections.RF.order(Reflections.RF.craft("CraftWorld").cast(world), Entity.class, "spawn", Location.class, Class.class, Consumer.class, CreatureSpawnEvent.SpawnReason.class);
    }

    public static Entity spawn(Class<?> entity_class, Reflections.RF.Invoker<Entity> invoker, Location at, Consumer<Entity> function) {
        return invoker.invoke(at, entity_class, function, CreatureSpawnEvent.SpawnReason.SPAWNER);
    }

    public static Entity spawn(Location l, EntityType type, Consumer<Entity> function) {
        return EventRegistry.spawner(l.getWorld()).invoke(l, type.getEntityClass(), function, CreatureSpawnEvent.SpawnReason.SPAWNER);
    }

    public static Consumer<Entity> function(CreatureSpawner cs) {
        return entity -> {
            try {
                Object a;
                Object w;
                void le;
                Mob at;
                void var3_2;
                EnderDragon enderDragon;
                Entity entity2 = entity;
                if (entity2 instanceof EnderDragon && (enderDragon = (EnderDragon)entity2) == (EnderDragon)var3_2) {
                    void dragon;
                    dragon.setPhase(EnderDragon.Phase.CIRCLING);
                }
                if (!Settings.settings.entity_movement && ( instanceOfPatternExpressionValue = entity) instanceof Attributable var4_6 && (at = le.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED)) != null) {
                    at.setBaseValue(0.0);
                }
                if (Settings.settings.check_spawner_nerf && ( instanceOfPatternExpressionValue = entity) instanceof Mob && (at = (Mob) instanceOfPatternExpressionValue) == (Mob) instanceOfPatternExpressionValue) {
                    void mob;
                    w = Reflections.RF.order((Object)mob.getWorld(), "getHandle", new Class[0]).invoke(new Object[0]);
                    SpigotWorldConfig f = Reflections.RF.access(w, "spigotConfig", SpigotWorldConfig.class).field();
                    if (f.nerfSpawnerMobs) {
                        a = Reflections.RF.order((Object)mob, "getHandle", new Class[0]).invoke(new Object[0]);
                        Reflections.RF.access(a, "aware", Boolean.TYPE).set(false);
                    }
                }
                if (!Settings.settings.spawn_babies && ( instanceOfPatternExpressionValue = entity) instanceof Ageable && (w = (Ageable) instanceOfPatternExpressionValue) == (Ageable) instanceOfPatternExpressionValue) {
                    void ageable;
                    ageable.setAdult();
                }
                if (!Settings.settings.spawn_with_equipment && ( instanceOfPatternExpressionValue = entity) instanceof LivingEntity && (a = (LivingEntity) instanceOfPatternExpressionValue) == (LivingEntity) instanceOfPatternExpressionValue) {
                    EntityEquipment e = a.getEquipment();
                    e.clear();
                }
                Object o = Reflections.RF.order(entity, "getHandle", new Class[0]).invoke(new Object[0]);
                Reflections.RF.accessI(o, "spawnedViaMobSpawner", Boolean.TYPE).set(true);
                Reflections.RF.accessI(o, "spawnReason", CreatureSpawnEvent.SpawnReason.class).set(CreatureSpawnEvent.SpawnReason.SPAWNER);
                if (Settings.settings.send_spawning_event) {
                    SpawnerSpawnEvent event = new SpawnerSpawnEvent(entity, cs);
                    entity.getServer().getPluginManager().callEvent((Event)event);
                }
            }
            catch (Exception e) {
                Reflections.RF.debug(e);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static void modify(Entity entity) {
        try {
            void le;
            Mob at;
            void var2_1;
            EnderDragon enderDragon;
            Entity entity2 = entity;
            if (entity2 instanceof EnderDragon && (enderDragon = (EnderDragon)entity2) == (EnderDragon)var2_1) {
                void dragon;
                dragon.setPhase(EnderDragon.Phase.CIRCLING);
            }
            if (!Settings.settings.entity_movement && ( instanceOfPatternExpressionValue = entity) instanceof Attributable var3_5 && (at = le.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED)) != null) {
                at.setBaseValue(0.0);
            }
            if (Settings.settings.check_spawner_nerf && ( instanceOfPatternExpressionValue = entity) instanceof Mob && (at = (Mob) instanceOfPatternExpressionValue) == (Mob) instanceOfPatternExpressionValue) {
                void mob;
                Object w = Reflections.RF.order((Object)mob.getWorld(), "getHandle", new Class[0]).invoke(new Object[0]);
                SpigotWorldConfig f = Reflections.RF.access(w, "spigotConfig", SpigotWorldConfig.class).field();
                if (f.nerfSpawnerMobs) {
                    Object a = Reflections.RF.order((Object)mob, "getHandle", new Class[0]).invoke(new Object[0]);
                    Reflections.RF.access(a, "aware", Boolean.TYPE).set(false);
                }
            }
            Object o = Reflections.RF.order((Object)entity, "getHandle", new Class[0]).invoke(new Object[0]);
            Reflections.RF.accessI(o, "spawnedViaMobSpawner", Boolean.TYPE).set(true);
            Reflections.RF.accessI(o, "spawnReason", CreatureSpawnEvent.SpawnReason.class).set(CreatureSpawnEvent.SpawnReason.SPAWNER);
        }
        catch (Exception e) {
            Reflections.RF.debug(e);
        }
    }

    public static void unlink(Block block) {
        if (!SpawnerMeta.WILD_STACKER.exists()) {
            return;
        }
        SpawnerMeta.WILD_STACKER.unlink(block);
    }

    private static /* synthetic */ void lambda$8(LivingEntity livingEntity, Player near) {
        livingEntity.damage(1.0E7, (Entity)near);
    }
}

