/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mc.rellox.spawnermeta.api.events.SpawnerExplodeEvent;
import mc.rellox.spawnermeta.configuration.Configuration;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.prices.Group;
import mc.rellox.spawnermeta.prices.IncreaseType;
import mc.rellox.spawnermeta.prices.Price;
import mc.rellox.spawnermeta.prices.PriceManager;
import mc.rellox.spawnermeta.spawner.SpawnerSpawning;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.spawner.UpgradeType;
import mc.rellox.spawnermeta.text.order.OrderList;
import mc.rellox.spawnermeta.utils.DataManager;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class Settings {
    public static final Settings settings = new Settings();
    public boolean debug;
    public boolean disable_spawning;
    public final TripleIntegerMap spawner_values = new TripleIntegerMap("Spawners.values");
    public final TripleIntegerMap spawner_value_increase = new TripleIntegerMap("Spawners.value-increase");
    public SpawnerSpawning spawner_spawning;
    public boolean spawner_switching;
    public boolean empty_enabled;
    public boolean empty_destroy_eggs_removing;
    public boolean empty_destroy_eggs_breaking;
    public boolean empty_store_inside;
    public boolean empty_verify_removing;
    public boolean spawning_particles;
    public boolean disable_item_spawners;
    public final Set<SpawnerType> spawner_disabled;
    public boolean allow_renaming;
    public int slime_size;
    public boolean cancel_spawning_event;
    public boolean send_spawning_event;
    public boolean cancel_break_event;
    public boolean kill_entities_on_spawn;
    public boolean entities_drop_xp;
    public int nearby_entity_limit;
    public int items_taking_ticks;
    public int items_remind_ticks;
    public boolean holograms_enabled;
    public boolean holograms_show_natural;
    public boolean upgrade_interface_enabled;
    public final TripleBooleanMap upgrades_upgradeable = new TripleBooleanMap("Modifiers.upgrades.upgradeable");
    public final TripleIntegerMap upgrades_levels = new TripleIntegerMap("Modifiers.upgrades.levels");
    public final TripleIntegerMap upgrades_prices = new TripleIntegerMap("Modifiers.upgrades.prices");
    public final TripleIntegerMap upgrades_price_increase = new TripleIntegerMap("Modifiers.upgrades.price-increase");
    public IncreaseType upgrade_increase_type;
    public final SingleIntegerMap charges_price = new SingleIntegerMap("Modifiers.charges.prices");
    public boolean charges_enabled;
    public boolean charges_allow_stacking;
    public boolean charges_ignore_natural;
    public int charges_buy_first;
    public int charges_buy_second;
    public final SinglePriceMap changing_price = new SinglePriceMap("Modifiers.changing");
    public boolean changing_enabled;
    public final SinglePriceMap placing_price = new SinglePriceMap("Modifiers.placing");
    public boolean placing_enabled;
    public final SinglePriceMap stacking_price = new SinglePriceMap("Modifiers.stacking");
    public boolean stacking_enabled;
    public int stacking_spawner_limit;
    public boolean stacking_ignore_limit;
    public boolean stacking_nearby_enabled;
    public int stacking_nearby_radius;
    public boolean stacking_nearby_particles;
    public final SinglePriceMap breaking_price = new SinglePriceMap("Modifiers.breaking");
    public boolean unbreakable;
    public boolean ignore_permission;
    public double breaking_dropping_chance;
    public ValueChanger breaking_chance_changer_owned;
    public ValueChanger breaking_chance_changer_not_owned;
    public ValueChanger breaking_chance_changer_natural;
    public boolean breaking_drop_on_ground;
    public boolean breaking_silk_enabled;
    public int breaking_silk_level;
    public boolean breaking_silk_break_owned;
    public boolean breaking_silk_break_natural;
    public boolean breaking_silk_destroy;
    public boolean breaking_durability_enabled;
    public int breaking_durability_to_remove;
    public int breaking_xp_on_failure;
    public final Map<String, Double> chance_permissions;
    public boolean breaking_show_owner;
    public boolean entity_target;
    public boolean entity_movement;
    public boolean check_spawner_nerf;
    public boolean spawn_babies;
    public boolean spawn_with_equipment;
    public boolean modify_stacked_entities;
    public int safety_limit;
    public boolean chunk_enabled;
    public int chunk_limit;
    public int chunk_entity_limit;
    public boolean item_show_header;
    public boolean item_show_range;
    public boolean item_show_delay;
    public boolean item_show_amount;
    public boolean owned_ignore_limit;
    public int owned_spawner_limit;
    public boolean owned_can_break;
    public boolean owned_can_stack;
    public boolean owned_can_change;
    public boolean owned_can_open;
    public boolean owned_can_upgrade;
    public boolean natural_can_break;
    public boolean natural_can_stack;
    public boolean natural_can_change;
    public boolean natural_can_open;
    public boolean natural_can_upgrade;
    public int stacking_ticks;
    public boolean spawnable_enabled;
    public final SingleIntegerMap spawnable_amount = new SingleIntegerMap("Modifiers.spawnable.entity-amount");
    public final Map<SpawnerExplodeEvent.ExplosionType, boolean[]> explosion_types;
    public boolean spawner_view_enabled;
    public final List<SpawnerType> spawner_view_entities;
    public String command_view;
    public String command_shop;
    public String command_drops;
    public int spawner_version;
    public OrderList order_spawner;
    public OrderList order_stats;
    public OrderList order_upgrade;
    public OrderList order_disabled;

    public static void reload() {
        settings.reload0();
    }

    private Settings() {
        this.spawner_disabled = new HashSet<SpawnerType>(4);
        this.chance_permissions = new HashMap<String, Double>(4);
        this.explosion_types = new HashMap<SpawnerExplodeEvent.ExplosionType, boolean[]>(4);
        this.spawner_view_entities = new ArrayList<SpawnerType>(8);
    }

    protected void reload0() {
        this.debug = Configuration.CF.s.getBoolean("Debug-errors");
        this.spawner_values.load();
        this.spawner_value_increase.load();
        SpawnerSpawning.SpawningType spawning = SpawnerSpawning.SpawningType.of(Configuration.CF.s.getString("Spawners.spawning-type"));
        int r = Configuration.CF.s.getInteger("Spawners.spawning-radius");
        this.spawner_spawning = spawning.spread(r < 1 ? 1 : (r > 8 ? 8 : r));
        this.spawner_switching = Configuration.CF.s.getBoolean("Spawners.switching");
        this.empty_enabled = Configuration.CF.s.getBoolean("Spawners.empty.enabled");
        this.empty_destroy_eggs_removing = Configuration.CF.s.getBoolean("Spawners.empty.destroy-eggs.when-removing");
        this.empty_destroy_eggs_breaking = Configuration.CF.s.getBoolean("Spawners.empty.destroy-eggs.when-breaking");
        this.empty_store_inside = Configuration.CF.s.getBoolean("Spawners.empty.store-eggs-inside");
        this.empty_verify_removing = Configuration.CF.s.getBoolean("Spawners.empty.egg-removing-verify");
        this.spawning_particles = Configuration.CF.s.getBoolean("Spawners.spawning-particles");
        this.disable_item_spawners = Configuration.CF.s.getBoolean("Spawners.disable-item-spawners");
        this.spawner_disabled.clear();
        this.spawner_disabled.addAll(Configuration.CF.s.getStringList("Spawners.disabled-spawners").stream().map(SpawnerType::of).filter(s -> s != null).collect(Collectors.toList()));
        this.slime_size = Configuration.CF.s.getInteger("Spawners.default-slime-size");
        this.cancel_spawning_event = Configuration.CF.s.getBoolean("Events.cancel-spawning-event");
        this.send_spawning_event = Configuration.CF.s.getBoolean("Events.send-spawner-event");
        this.cancel_break_event = Configuration.CF.s.getBoolean("Events.cancel-break-event");
        this.kill_entities_on_spawn = Configuration.CF.s.getBoolean("Spawners.kill-entities-on-spawn");
        this.entities_drop_xp = Configuration.CF.s.getBoolean("Spawners.drop-xp-when-instant-kill");
        this.allow_renaming = Configuration.CF.s.getBoolean("Spawners.allow-renaming");
        this.nearby_entity_limit = Configuration.CF.s.getInteger("Spawners.nearby-entity-limit");
        this.items_taking_ticks = Configuration.CF.s.getInteger("Items.taking-ticks");
        this.items_remind_ticks = Configuration.CF.s.getInteger("Items.taking-remind-ticks");
        this.holograms_enabled = Configuration.CF.s.getBoolean("Modifiers.holograms.enabled");
        this.holograms_show_natural = Configuration.CF.s.getBoolean("Modifiers.holograms.show-natural");
        this.upgrade_interface_enabled = Configuration.CF.s.getBoolean("Modifiers.upgrade-interface.enabled");
        this.upgrades_upgradeable.load();
        this.upgrades_levels.load();
        this.upgrades_prices.load();
        this.upgrades_price_increase.load();
        this.upgrade_increase_type = IncreaseType.of(Configuration.CF.s.getString("Modifiers.upgrades.price-increase-type"));
        this.charges_enabled = Configuration.CF.s.getBoolean("Modifiers.charges.enabled");
        this.charges_allow_stacking = Configuration.CF.s.getBoolean("Modifiers.charges.allow-stacking");
        this.charges_ignore_natural = Configuration.CF.s.getBoolean("Modifiers.charges.ignore-natural");
        this.charges_price.load();
        this.charges_buy_first = Configuration.CF.s.getInteger("Modifiers.charges.buy-amount.first");
        this.charges_buy_second = Configuration.CF.s.getInteger("Modifiers.charges.buy-amount.second");
        this.changing_enabled = Configuration.CF.s.getBoolean("Modifiers.changing.enabled");
        this.changing_price.load();
        this.placing_enabled = Configuration.CF.s.getBoolean("Modifiers.placing.enabled");
        this.placing_price.load();
        this.stacking_enabled = Configuration.CF.s.getBoolean("Modifiers.stacking.enabled");
        this.stacking_price.load();
        this.stacking_spawner_limit = Configuration.CF.s.getInteger("Modifiers.stacking.spawner-limit");
        this.stacking_ignore_limit = Configuration.CF.s.getBoolean("Modifiers.stacking.ignore-limit");
        this.stacking_nearby_enabled = Configuration.CF.s.getBoolean("Modifiers.stacking.when-nearby.enabled");
        this.stacking_nearby_radius = Configuration.CF.s.getInteger("Modifiers.stacking.when-nearby.radius");
        if (this.stacking_nearby_radius < 1) {
            this.stacking_nearby_radius = 1;
        }
        if (this.stacking_nearby_radius > 16) {
            this.stacking_nearby_radius = 16;
        }
        this.stacking_nearby_particles = Configuration.CF.s.getBoolean("Modifiers.stacking.when-nearby.particles");
        this.stacking_ticks = Configuration.CF.s.getInteger("Modifiers.stacking.ticks-per");
        this.unbreakable = Configuration.CF.s.getBoolean("Modifiers.breaking.unbreakable");
        this.ignore_permission = Configuration.CF.s.getBoolean("Modifiers.breaking.ignore-permission");
        this.breaking_price.load();
        this.breaking_dropping_chance = Configuration.CF.s.getDouble("Modifiers.breaking.dropping-chance");
        this.breaking_chance_changer_owned = ValueChanger.of("Modifiers.breaking.chance-changing.owned");
        this.breaking_chance_changer_not_owned = ValueChanger.of("Modifiers.breaking.chance-changing.not-owned");
        this.breaking_chance_changer_natural = ValueChanger.of("Modifiers.breaking.chance-changing.natural");
        this.breaking_drop_on_ground = Configuration.CF.s.getBoolean("Modifiers.breaking.drop-on-ground");
        this.breaking_silk_enabled = Configuration.CF.s.getBoolean("Modifiers.breaking.silk-requirement.enabled");
        this.breaking_silk_level = Configuration.CF.s.getInteger("Modifiers.breaking.silk-requirement.level");
        this.breaking_silk_break_owned = Configuration.CF.s.getBoolean("Modifiers.breaking.silk-requirement.break-owned");
        this.breaking_silk_break_natural = Configuration.CF.s.getBoolean("Modifiers.breaking.silk-requirement.break-natural");
        this.breaking_silk_destroy = Configuration.CF.s.getBoolean("Modifiers.breaking.silk-requirement.destroy-on-fail");
        this.breaking_durability_enabled = Configuration.CF.s.getBoolean("Modifiers.breaking.enable-durability");
        this.breaking_durability_to_remove = Configuration.CF.s.getInteger("Modifiers.breaking.durability-to-remove");
        this.breaking_xp_on_failure = Configuration.CF.s.getInteger("Modifiers.breaking.xp-on-failure");
        Set<String> keys = Configuration.CF.s.getKeys("Modifiers.breaking.permissions");
        this.chance_permissions.clear();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                String p = "spawnermeta.breaking.permission." + key;
                double c = Configuration.CF.s.getDouble("Modifiers.breaking.permissions." + key);
                this.chance_permissions.put(p, c);
            }
        }
        this.breaking_show_owner = Configuration.CF.s.getBoolean("Modifiers.breaking.show-owner");
        this.entity_target = Configuration.CF.s.getBoolean("Modifiers.entity-target");
        this.entity_movement = Configuration.CF.s.getBoolean("Modifiers.entity-movement");
        this.check_spawner_nerf = Configuration.CF.s.getBoolean("Modifiers.check-spawner-nerf");
        this.spawn_babies = Configuration.CF.s.getBoolean("Modifiers.spawn-babies");
        this.spawn_with_equipment = Configuration.CF.s.getBoolean("Modifiers.spawn-with-equipment");
        this.modify_stacked_entities = Configuration.CF.s.getBoolean("Modifiers.modify-stacked-entities");
        this.safety_limit = Configuration.CF.s.getInteger("Modifiers.safety-limit");
        this.chunk_enabled = Configuration.CF.s.getBoolean("Modifiers.chunk-limits.enabled");
        this.chunk_limit = Configuration.CF.s.getInteger("Modifiers.chunk-limits.spawner-limit");
        this.chunk_entity_limit = Configuration.CF.s.getInteger("Modifiers.chunk-limits.entities-in-chuck");
        this.item_show_header = Configuration.CF.s.getBoolean("Modifiers.spawner-item.show-header");
        this.item_show_range = Configuration.CF.s.getBoolean("Modifiers.spawner-item.show-range");
        this.item_show_delay = Configuration.CF.s.getBoolean("Modifiers.spawner-item.show-delay");
        this.item_show_amount = Configuration.CF.s.getBoolean("Modifiers.spawner-item.show-amount");
        this.owned_ignore_limit = Configuration.CF.s.getBoolean("Modifiers.players.owned.ignore-limit");
        this.owned_spawner_limit = Configuration.CF.s.getInteger("Modifiers.players.owned.spawner-limit");
        this.owned_can_break = Configuration.CF.s.getBoolean("Modifiers.players.owned.can-break");
        this.owned_can_change = Configuration.CF.s.getBoolean("Modifiers.players.owned.can-stack");
        this.owned_can_open = Configuration.CF.s.getBoolean("Modifiers.players.owned.can-open");
        this.owned_can_stack = Configuration.CF.s.getBoolean("Modifiers.players.owned.can-stack");
        this.owned_can_upgrade = Configuration.CF.s.getBoolean("Modifiers.players.owned.can-upgrade");
        this.natural_can_break = Configuration.CF.s.getBoolean("Modifiers.players.natural.can-break");
        this.natural_can_change = Configuration.CF.s.getBoolean("Modifiers.players.natural.can-stack");
        this.natural_can_open = Configuration.CF.s.getBoolean("Modifiers.players.natural.can-open");
        this.natural_can_stack = Configuration.CF.s.getBoolean("Modifiers.players.natural.can-stack");
        this.natural_can_upgrade = Configuration.CF.s.getBoolean("Modifiers.players.natural.can-upgrade");
        this.spawnable_enabled = Configuration.CF.s.getBoolean("Modifiers.spawnable.enabled");
        this.spawnable_amount.load();
        this.explosion_types.clear();
        Arrays.asList(SpawnerExplodeEvent.ExplosionType.values()).forEach(x -> {
            boolean[] bs = new boolean[]{Configuration.CF.s.getBoolean("Miscellaneous.explosions." + x.name() + ".break-spawners"), Configuration.CF.s.getBoolean("Miscellaneous.explosions." + x.name() + ".drop-spawners"), Configuration.CF.s.getBoolean("Miscellaneous.explosions." + x.name() + ".break-natural-spawners"), Configuration.CF.s.getBoolean("Miscellaneous.explosions." + x.name() + ".drop-natural-spawners")};
            this.explosion_types.put((SpawnerExplodeEvent.ExplosionType)((Object)x), bs);
        });
        this.spawner_view_enabled = Configuration.CF.s.getBoolean("Spawner-view.enabled");
        Set list = Configuration.CF.s.getStringList("Spawner-view.ignore-entities").stream().map(SpawnerType::of).filter(s -> s != null).collect(Collectors.toSet());
        this.spawner_view_entities.clear();
        this.spawner_view_entities.addAll(Stream.of(SpawnerType.values()).filter(s -> s.exists() && !list.contains(s)).collect(Collectors.toList()));
        this.spawner_view_entities.remove((Object)SpawnerType.EMPTY);
        this.command_view = Configuration.CF.s.getString("Commands.spawner-view");
        this.command_shop = Configuration.CF.s.getString("Commands.spawner-shop");
        this.command_drops = Configuration.CF.s.getString("Commands.spawner-drops");
        this.spawner_version = Configuration.CF.s.getInteger("Spawner-version");
        this.order_spawner = new OrderList(Configuration.CF.s.getStringList("Items.layout.spawner-item"));
        this.order_stats = new OrderList(Configuration.CF.s.getStringList("Items.layout.upgrades.stat-item"));
        this.order_upgrade = new OrderList(Configuration.CF.s.getStringList("Items.layout.upgrades.upgrade-item"));
        this.order_disabled = new OrderList(Configuration.CF.s.getStringList("Items.layout.upgrades.disabled-upgrade-item"));
        PriceManager.reload();
    }

    public void update_spawners() {
        ++this.spawner_version;
        Configuration.CF.s.set("Spawner-version", this.spawner_version);
    }

    public boolean disabled(SpawnerType type) {
        return this.spawner_disabled.contains((Object)type);
    }

    public double breaking_chance(Player player) {
        double chance = this.breaking_dropping_chance;
        if (this.chance_permissions.isEmpty()) {
            return chance;
        }
        for (Map.Entry<String, Double> e : this.chance_permissions.entrySet()) {
            double other;
            if (!player.hasPermission(e.getKey()) || !(chance < (other = e.getValue().doubleValue()))) continue;
            chance = other;
        }
        return chance;
    }

    public boolean has_silk(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getEnchantLevel(Enchantment.SILK_TOUCH) >= this.breaking_silk_level;
    }

    public ItemStack view_item(SpawnerType type) {
        boolean[] upgrades = this.upgrades_upgradeable.get(type);
        int[] prices = this.upgrades_prices.get(type);
        int[] increases = this.upgrades_price_increase.get(type);
        int[] levels = this.upgrades_levels.get(type);
        ItemStack item = new ItemStack(Material.SPAWNER);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Language.get("Inventory.spawner-view.items.name", "type", (Object)type).text());
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        int i = 0;
        while (i < 3) {
            if (upgrades[i]) {
                UpgradeType u = UpgradeType.values()[i];
                Price t = Price.of(Group.upgrades, prices[i]);
                Price n = Price.of(Group.upgrades, increases[i]);
                lore.add(Language.get("Inventory.spawner-view.items.header." + u.lower()).text());
                lore.add(Language.get("Inventory.spawner-view.items.price", "price", (Object)t).text());
                lore.add(Language.get("Inventory.spawner-view.items.price-increase", "increase", (Object)this.upgrade_increase_type.format(n)).text());
                lore.add(Language.get("Inventory.spawner-view.items.maximum-level", "level", (Object)levels[i]).text());
            }
            ++i;
        }
        if (this.spawnable_enabled) {
            lore.add("");
            lore.add(Language.get("Inventory.spawner-view.items.spawnable", "spawnable", (Object)this.spawnable_amount.get(type)).text());
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public int charges_price(SpawnerType type, Block block) {
        return this.charges_price.get(type) * DataManager.getStack(block) * (DataManager.getSpawnerLevel(block) + 1);
    }

    public static enum ChangerType {
        NONE{

            @Override
            public double change(double value, double other) {
                return value;
            }
        }
        ,
        ADD{

            @Override
            public double change(double value, double other) {
                return value + other;
            }
        }
        ,
        SUBTRACT{

            @Override
            public double change(double value, double other) {
                return value - other;
            }
        }
        ,
        MULTIPLY{

            @Override
            public double change(double value, double other) {
                return value * other;
            }
        }
        ,
        DIVIDE{

            @Override
            public double change(double value, double other) {
                return value / other;
            }
        };


        public abstract double change(double var1, double var3);

        public static ChangerType of(char c) {
            return switch (c) {
                case '+' -> ADD;
                case '-' -> SUBTRACT;
                case '*' -> MULTIPLY;
                case '/' -> DIVIDE;
                default -> NONE;
            };
        }
    }

    public static class SingleIntegerMap {
        protected final String path;
        protected int i;
        protected final Map<SpawnerType, Integer> map;

        public SingleIntegerMap(String path) {
            this.path = path;
            this.map = new HashMap<SpawnerType, Integer>();
        }

        public int get(SpawnerType type) {
            return this.map.getOrDefault((Object)type, this.i);
        }

        public void load() {
            this.map.clear();
            this.i = Configuration.CF.s.getInteger(String.valueOf(this.path) + ".DEFAULT");
            Stream.of(SpawnerType.values()).forEach(type -> {
                int a = Configuration.CF.s.getInteger(String.valueOf(this.path) + "." + type.name());
                if (a == 0 || a == this.i) {
                    return;
                }
                this.map.put((SpawnerType)((Object)type), a);
            });
        }
    }

    public static class SinglePriceMap
    extends SingleIntegerMap {
        private final String tp;
        private boolean u;

        public SinglePriceMap(String path) {
            super(String.valueOf(path) + ".prices");
            this.tp = path;
        }

        public boolean using() {
            return this.u;
        }

        @Override
        public void load() {
            this.map.clear();
            this.u = Configuration.CF.s.getBoolean(String.valueOf(this.tp) + ".use-price");
            if (!this.u) {
                return;
            }
            super.load();
        }
    }

    public static class TripleBooleanMap {
        private final String path;
        private final boolean[] is;
        private final Map<SpawnerType, boolean[]> map;

        public TripleBooleanMap(String path) {
            this.path = path;
            this.is = new boolean[3];
            this.map = new HashMap<SpawnerType, boolean[]>();
        }

        public boolean[] get(SpawnerType type) {
            return (boolean[])this.map.getOrDefault((Object)type, this.is).clone();
        }

        public void load() {
            this.map.clear();
            this.is[0] = Configuration.CF.s.getBoolean(String.valueOf(this.path) + ".DEFAULT.range");
            this.is[1] = Configuration.CF.s.getBoolean(String.valueOf(this.path) + ".DEFAULT.delay");
            this.is[2] = Configuration.CF.s.getBoolean(String.valueOf(this.path) + ".DEFAULT.amount");
            Stream.of(SpawnerType.values()).forEach(type -> {
                boolean a0 = this.b(String.valueOf(this.path) + "." + type.name() + ".range", 0);
                boolean a1 = this.b(String.valueOf(this.path) + "." + type.name() + ".delay", 1);
                boolean a2 = this.b(String.valueOf(this.path) + "." + type.name() + ".amount", 2);
                if (a0 == this.is[0] && a1 == this.is[1] && a2 == this.is[2]) {
                    return;
                }
                boolean[] as = new boolean[]{a0, a1, a2};
                this.map.put((SpawnerType)((Object)type), as);
            });
        }

        private boolean b(String path, int i) {
            if (!Configuration.CF.s.is(path)) {
                return this.is[i];
            }
            return Configuration.CF.s.getBoolean(path);
        }
    }

    public static class TripleIntegerMap {
        private final String path;
        private final int[] is;
        private final Map<SpawnerType, int[]> map;

        public TripleIntegerMap(String path) {
            this.path = path;
            this.is = new int[3];
            this.map = new HashMap<SpawnerType, int[]>();
        }

        public int[] get(SpawnerType type) {
            return (int[])this.map.getOrDefault((Object)type, this.is).clone();
        }

        public void load() {
            this.map.clear();
            this.is[0] = Configuration.CF.s.getInteger(String.valueOf(this.path) + ".DEFAULT.range");
            this.is[1] = Configuration.CF.s.getInteger(String.valueOf(this.path) + ".DEFAULT.delay");
            this.is[2] = Configuration.CF.s.getInteger(String.valueOf(this.path) + ".DEFAULT.amount");
            Stream.of(SpawnerType.values()).forEach(type -> {
                int a0 = this.a(String.valueOf(this.path) + "." + type.name() + ".range", 0);
                int a1 = this.a(String.valueOf(this.path) + "." + type.name() + ".delay", 1);
                int a2 = this.a(String.valueOf(this.path) + "." + type.name() + ".amount", 2);
                if (a0 == this.is[0] && a1 == this.is[1] && a2 == this.is[2]) {
                    return;
                }
                int[] as = new int[]{a0, a1, a2};
                this.map.put((SpawnerType)((Object)type), as);
            });
        }

        private int a(String path, int i) {
            if (!Configuration.CF.s.is(path)) {
                return this.is[i];
            }
            int a = Configuration.CF.s.getInteger(path);
            return a == 0 ? this.is[i] : a;
        }
    }

    public record ValueChanger(double change, ChangerType type) {
        public double change(double value) {
            return this.type.change(value, this.change);
        }

        public static ValueChanger of(String path) {
            double value;
            String s = Configuration.CF.s.getString(path);
            if (s == null || s.length() < 2) {
                return new ValueChanger(0.0, ChangerType.NONE);
            }
            ChangerType type = ChangerType.of(s.charAt(0));
            try {
                value = Double.parseDouble(s.substring(1));
            }
            catch (Exception e) {
                value = 0.0;
            }
            return new ValueChanger(value, type);
        }
    }
}

