/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.utils.DataManager;
import mc.rellox.spawnermeta.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class LocationFile {
    private static File f;
    private static FileConfiguration file;
    private static boolean legacy;

    public static void initialize() {
        f = new File(SpawnerMeta.instance().getDataFolder(), "locations.yml");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        file = YamlConfiguration.loadConfiguration((File)f);
        file.options().header("This file contains all player placed spawner locations.\nAny invalid modifications may result in errors\nand unwanted spawner exploits.\nLocation syntax must always be: [x, y, z]\n\nIf you have used version 5.2 or lower and\nhad enabled player spawner placing limit, than\nyou are using legacy spawner limit.\nLegacy spawner limit excludes spawner locations\nand are stored on player. You can change the value\nof 'Legacy' to false to enable new spawner location\nsaving.\nWarning! Using the new location saving all previously\nplaced spawner will not be counted and be ignored,\nmeaning all players will have 0 spawner placed, but\nall newly placed spawners will be saved in this file\nfor easy spawner location finding and searshing.\n\nNote! Spawner locations won't be saved if legacy\nis set to true.");
        File log = new File(SpawnerMeta.instance().getDataFolder(), "log.yml");
        if (log.exists()) {
            legacy = true;
            YamlConfiguration lc = YamlConfiguration.loadConfiguration((File)log);
            Set keys = lc.getKeys(false);
            keys.forEach(arg_0 -> LocationFile.lambda$0((FileConfiguration)lc, arg_0));
            LocationFile.saveFile();
            log.delete();
        } else {
            legacy = false;
        }
        file.addDefault("Legacy", (Object)legacy);
        file.options().copyDefaults(true);
        LocationFile.saveFile();
        LM.join();
    }

    public static void hold(String path, Object o) {
        file.set(path, o);
    }

    public static void save(String path, Object o) {
        file.set(path, o);
        LocationFile.saveFile();
    }

    public static void clear(String path) {
        file.set(path, null);
        LocationFile.saveFile();
    }

    public static void saveFile() {
        try {
            file.save(f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$0(FileConfiguration fileConfiguration, String key) {
        LocationFile.hold("Removing." + key, fileConfiguration.getInt("remove_placed." + key));
    }

    public static final class LF {
        private static String parse(Location loc) {
            String sx;
            int x = loc.getBlockX();
            int z = loc.getBlockZ();
            String string = x < 0 ? (x == -1 ? "-0" : "" + (x + 1)) : (sx = "" + x);
            String sz = z < 0 ? (z == -1 ? "-0" : "" + (z + 1)) : "" + z;
            return "[" + sx + ", " + loc.getBlockY() + ", " + sz + "]";
        }

        public static List<Location> get(World world, Player player) {
            List<Object> list = new ArrayList<Location>();
            List ss = file.getStringList("Locations." + player.getUniqueId().toString() + "." + world.getName());
            if (ss.isEmpty()) {
                return list;
            }
            try {
                list = ss.stream().map(s -> {
                    String[] ps = s.replace("[", "").replace("]", "").split(",");
                    if (ps.length != 3) {
                        return null;
                    }
                    int[] is = new int[3];
                    int i = 0;
                    while (i < 3) {
                        if (!Utils.isInteger(ps[i])) {
                            return null;
                        }
                        is[i] = Integer.parseInt(ps[i]);
                        ++i;
                    }
                    return new Location(world, (double)is[0], (double)is[1], (double)is[2]);
                }).filter(l -> l != null).collect(Collectors.toList());
            }
            catch (Exception e) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_RED + "[SM] Unable to get spawner locations: " + ChatColor.AQUA + e.getMessage());
            }
            return list;
        }

        public static int placed(Player player) {
            if (legacy) {
                return LM.getPlaced(player);
            }
            String path = "Locations." + player.getUniqueId().toString();
            ConfigurationSection cs = file.getConfigurationSection(path);
            if (cs == null) {
                return 0;
            }
            Set keys = cs.getKeys(false);
            int i = 0;
            for (String key : keys) {
                List list = file.getStringList(String.valueOf(path) + "." + key);
                i += list.size();
            }
            return i;
        }

        public static void add(Block block, Player player) {
            if (legacy) {
                LM.addPlaced(player);
                return;
            }
            World world = block.getWorld();
            Location loc = block.getLocation();
            String path = "Locations." + player.getUniqueId().toString() + "." + world.getName();
            List<String> ss = file.getStringList(path);
            String s = LF.parse(loc);
            if (ss == null || ss.isEmpty()) {
                ss = List.of(s);
            } else {
                ss.add(s);
            }
            LocationFile.save(path, ss);
        }

        public static void remove(Block block) {
            UUID owner = DataManager.getOwner(block);
            if (owner == null) {
                return;
            }
            if (legacy) {
                LM.removePlaced(block);
                return;
            }
            int t = DataManager.getStack(block);
            World world = block.getWorld();
            Location loc = block.getLocation();
            String path = "Locations." + owner.toString() + "." + world.getName();
            List ss = file.getStringList(path);
            if (ss == null || ss.isEmpty()) {
                return;
            }
            String s = LF.parse(loc);
            boolean b = false;
            while (t-- > 0) {
                b |= ss.remove(s);
            }
            if (b) {
                LocationFile.save(path, ss);
            }
        }
    }

    private static final class LM {
        private static final String METADATA_PLACED = "Placed_Spawners";

        private LM() {
        }

        public static void join() {
            if (!legacy) {
                return;
            }
            class LagacyJoin
            implements Listener {
                LagacyJoin() {
                }

                @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
                private void onPlayerJoin(PlayerJoinEvent event) {
                    Player player = event.getPlayer();
                    int r = LM.getPlacedToRemove(player.getUniqueId());
                    if (r <= 0) {
                        return;
                    }
                    LM.removePlaced(player, r);
                }
            }
            Bukkit.getPluginManager().registerEvents((Listener)new LagacyJoin(), (Plugin)SpawnerMeta.instance());
        }

        public static void removePlaced(Block block) {
            UUID id = DataManager.getOwner(block);
            if (id == null) {
                return;
            }
            int s = DataManager.getStack(block);
            Player player = Bukkit.getPlayer((UUID)id);
            if (player == null) {
                LM.setPlacedToRemove(id, s);
            } else {
                LM.removePlaced(player, s);
            }
        }

        public static void addPlaced(Player player) {
            MetadataValue m = LM.getPlacedData(player);
            int v = m == null ? 1 : m.asInt() + 1;
            player.setMetadata(METADATA_PLACED, (MetadataValue)new FixedMetadataValue((Plugin)SpawnerMeta.instance(), (Object)v));
        }

        public static int getPlaced(Player player) {
            MetadataValue m = LM.getPlacedData(player);
            return m == null ? 0 : m.asInt();
        }

        public static void removePlaced(Player player, int i) {
            MetadataValue m = LM.getPlacedData(player);
            if (m == null) {
                return;
            }
            int p = m.asInt() - i;
            if (p <= 0) {
                player.removeMetadata(METADATA_PLACED, (Plugin)SpawnerMeta.instance());
            } else {
                player.setMetadata(METADATA_PLACED, (MetadataValue)new FixedMetadataValue((Plugin)SpawnerMeta.instance(), (Object)p));
            }
        }

        private static MetadataValue getPlacedData(Player player) {
            if (!player.hasMetadata(METADATA_PLACED)) {
                return null;
            }
            List list = player.getMetadata(METADATA_PLACED);
            if (list == null || list.isEmpty()) {
                return null;
            }
            return (MetadataValue)list.get(0);
        }

        public static void setPlacedToRemove(UUID id, int i) {
            String path = "Removing." + id.toString();
            int j = file.getInt(path) + i;
            LocationFile.save(path, j);
        }

        public static int getPlacedToRemove(UUID id) {
            String path = "Removing." + id.toString();
            if (!file.contains(path)) {
                return 0;
            }
            int v = file.getInt(path);
            LocationFile.save(path, null);
            return v;
        }
    }
}

