/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.configuration;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.api.events.SpawnerExplodeEvent;
import mc.rellox.spawnermeta.configuration.Configuration;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.items.ItemMatcher;
import mc.rellox.spawnermeta.prices.IncreaseType;
import mc.rellox.spawnermeta.prices.PriceType;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.spawner.UpgradeType;
import mc.rellox.spawnermeta.utils.Reflections;
import mc.rellox.spawnermeta.utils.Version;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationFile {
    private File f;
    protected FileConfiguration file;
    private final String name;
    protected boolean first;

    public ConfigurationFile(String name) {
        this.name = name;
    }

    protected void initialize() {
        this.f = new File(SpawnerMeta.instance().getDataFolder(), String.valueOf(this.name) + ".yml");
        if (!this.f.getParentFile().exists()) {
            this.f.getParentFile().mkdirs();
        }
        if (!this.f.exists()) {
            try {
                this.first = true;
                this.f.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.file = YamlConfiguration.loadConfiguration((File)this.f);
    }

    public List<String> getStringList(String path) {
        return this.file.getStringList(path);
    }

    public String getString(String path) {
        return this.file.getString(path);
    }

    public boolean getBoolean(String path) {
        return this.file.getBoolean(path);
    }

    public int getInteger(String path) {
        return this.file.getInt(path);
    }

    public double getDouble(String path) {
        return this.file.getDouble(path);
    }

    public ItemMatcher getMatcher(String path) {
        return ItemMatcher.from(this.file, path);
    }

    public Set<String> getKeys(String path) {
        ConfigurationSection cs = this.file.getConfigurationSection(path);
        return cs == null ? new HashSet() : cs.getKeys(false);
    }

    public boolean is(String path) {
        return this.file.get(path) != null;
    }

    public final void hold(String path, Object o) {
        this.file.set(path, o);
    }

    public final void set(String path, Object o) {
        this.file.set(path, o);
        this.save();
    }

    public final void clear(String path) {
        this.file.set(path, null);
        this.save();
    }

    public final void save() {
        try {
            this.file.save(this.f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Commenter commenter() {
        return Version.version.high(Version.VersionType.v_18_1) ? new Commenter() : null;
    }

    protected void copy(String from, String to) {
        Object o = this.file.get(from);
        if (o == null) {
            return;
        }
        this.file.set(to, o);
        this.file.set(from, null);
    }

    protected class Commenter {
        protected Commenter() {
        }

        protected void comment(String path, String ... cs) {
            Reflections.RF.order((Object)ConfigurationFile.this.file, "setComments", String.class, List.class).invoke(new Object[]{path, List.of(cs)});
        }
    }

    public static final class SettingsFile
    extends ConfigurationFile {
        private static final int version = 2;

        public SettingsFile() {
            super("configuration");
        }

        @Override
        protected void initialize() {
            Commenter c;
            super.initialize();
            Configuration.CF.version = this.file.getInt("Configuration-version");
            this.file.addDefault("Debug-errors", (Object)true);
            this.file.addDefault("Spawners.values.DEFAULT.range", (Object)16);
            this.file.addDefault("Spawners.values.DEFAULT.delay", (Object)500);
            this.file.addDefault("Spawners.values.DEFAULT.amount", (Object)4);
            this.file.addDefault("Spawners.value-increase.DEFAULT.range", (Object)4);
            this.file.addDefault("Spawners.value-increase.DEFAULT.delay", (Object)-75);
            this.file.addDefault("Spawners.value-increase.DEFAULT.amount", (Object)1);
            this.file.addDefault("Spawners.spawning-type", (Object)"SINGLE");
            this.file.addDefault("Spawners.spawning-radius", (Object)3);
            this.file.addDefault("Spawners.switching", (Object)false);
            this.file.addDefault("Spawners.empty.enabled", (Object)false);
            this.file.addDefault("Spawners.empty.destroy-eggs.when-removing", (Object)false);
            this.file.addDefault("Spawners.empty.destroy-eggs.when-breaking", (Object)false);
            this.file.addDefault("Spawners.empty.store-eggs-inside", (Object)false);
            this.file.addDefault("Spawners.empty.egg-removing-verify", (Object)false);
            this.file.addDefault("Spawners.disabled-spawners", List.of());
            this.file.addDefault("Spawners.spawning-particles", (Object)true);
            this.file.addDefault("Spawners.disable-item-spawners", (Object)false);
            this.file.addDefault("Spawners.allow-renaming", (Object)true);
            this.file.addDefault("Spawners.nearby-entity-limit", (Object)6);
            this.file.addDefault("Spawners.kill-entities-on-spawn", (Object)false);
            this.file.addDefault("Spawners.drop-xp-when-instant-kill", (Object)true);
            this.file.addDefault("Spawners.default-slime-size", (Object)0);
            this.file.addDefault("Events.cancel-spawning-event", (Object)true);
            this.file.addDefault("Events.send-spawner-event", (Object)false);
            this.file.addDefault("Events.cancel-break-event", (Object)true);
            this.file.addDefault("Items.taking-ticks", (Object)1200);
            this.file.addDefault("Items.taking-remind-ticks", (Object)600);
            boolean i_h = this.file.getBoolean("Modifiers.spawner-item.show-header", true);
            boolean i_r = this.file.getBoolean("Modifiers.spawner-item.show-range", true);
            boolean i_d = this.file.getBoolean("Modifiers.spawner-item.show-delay", true);
            boolean i_a = this.file.getBoolean("Modifiers.spawner-item.show-amount", true);
            this.file.addDefault("Items.layout.spawner-item", List.of("!", "HEADER", "RANGE", "DELAY", "AMOUNT", "!", "CHARGES", "SPAWNABLE", "!", "INFO").stream().map(e -> switch (e) {
                case "HEADER" -> {
                    if (i_h) {
                        yield e;
                    }
                    yield String.valueOf(e) + "!";
                }
                case "RANGE" -> {
                    if (i_r) {
                        yield e;
                    }
                    yield String.valueOf(e) + "!";
                }
                case "DELAY" -> {
                    if (i_d) {
                        yield e;
                    }
                    yield String.valueOf(e) + "!";
                }
                case "AMOUNT" -> {
                    if (i_a) {
                        yield e;
                    }
                    yield String.valueOf(e) + "!";
                }
                default -> e;
            }).toList());
            this.file.addDefault("Items.layout.upgrades.stat-item", List.of("EMPTY", "SWITCHING", "!", "LOCATION", "STACK", "SPAWNABLE", "!", "WARNING", "!", "INFO"));
            this.file.addDefault("Items.layout.upgrades.upgrade-item", List.of("HELP", "!", "INFO", "!", "CURRENT", "!", "NEXT", "!", "PRICE"));
            this.file.addDefault("Items.layout.upgrades.disabled-upgrade-item", List.of("HELP", "!", "INFO", "!", "CURRENT"));
            this.file.addDefault("Modifiers.holograms.enabled", (Object)false);
            this.file.addDefault("Modifiers.holograms.show-natural", (Object)false);
            this.file.addDefault("Modifiers.upgrade-interface.enabled", (Object)true);
            UpgradeType.stream().forEach(type -> {
                this.file.addDefault("Modifiers.upgrades.upgradeable.DEFAULT." + type.lower(), (Object)true);
                this.file.addDefault("Modifiers.upgrades.levels.DEFAULT." + type.lower(), (Object)5);
                this.file.addDefault("Modifiers.upgrades.prices.DEFAULT." + type.lower(), (Object)100);
                this.file.addDefault("Modifiers.upgrades.price-increase.DEFAULT." + type.lower(), (Object)50);
            });
            this.file.addDefault("Modifiers.upgrades.price-increase-type", (Object)IncreaseType.ADDITION.name());
            this.file.addDefault("Modifiers.charges.enabled", (Object)false);
            this.file.addDefault("Modifiers.charges.allow-stacking", (Object)false);
            this.file.addDefault("Modifiers.charges.ignore-natural", (Object)true);
            this.file.addDefault("Modifiers.charges.buy-amount.first", (Object)16);
            this.file.addDefault("Modifiers.charges.buy-amount.second", (Object)128);
            this.file.addDefault("Modifiers.charges.prices.DEFAULT", (Object)2);
            this.file.addDefault("Modifiers.changing.enabled", (Object)false);
            this.file.addDefault("Modifiers.changing.use-price", (Object)false);
            this.file.addDefault("Modifiers.changing.prices.DEFAULT", (Object)100);
            this.file.addDefault("Modifiers.placing.enabled", (Object)true);
            this.file.addDefault("Modifiers.placing.use-price", (Object)false);
            this.file.addDefault("Modifiers.placing.prices.DEFAULT", (Object)100);
            this.file.addDefault("Modifiers.stacking.enabled", (Object)false);
            this.file.addDefault("Modifiers.stacking.use-price", (Object)false);
            this.file.addDefault("Modifiers.stacking.ticks-per", (Object)5);
            this.file.addDefault("Modifiers.stacking.prices.DEFAULT", (Object)100);
            this.file.addDefault("Modifiers.stacking.spawner-limit", (Object)16);
            this.file.addDefault("Modifiers.stacking.ignore-limit", (Object)true);
            this.file.addDefault("Modifiers.stacking.when-nearby.enabled", (Object)false);
            this.file.addDefault("Modifiers.stacking.when-nearby.radius", (Object)8);
            this.file.addDefault("Modifiers.stacking.when-nearby.particles", (Object)true);
            this.file.addDefault("Modifiers.breaking.unbreakable", (Object)false);
            this.file.addDefault("Modifiers.breaking.ignore-permission", (Object)false);
            this.file.addDefault("Modifiers.breaking.use-price", (Object)false);
            this.file.addDefault("Modifiers.breaking.prices.DEFAULT", (Object)100);
            this.file.addDefault("Modifiers.breaking.dropping-chance", (Object)100);
            this.file.addDefault("Modifiers.breaking.chance-changing.owned", (Object)"+0");
            this.file.addDefault("Modifiers.breaking.chance-changing.not-owned", (Object)"+0");
            this.file.addDefault("Modifiers.breaking.chance-changing.natural", (Object)"+0");
            this.file.addDefault("Modifiers.breaking.drop-on-ground", (Object)true);
            this.file.addDefault("Modifiers.breaking.silk-requirement.enabled", (Object)true);
            this.file.addDefault("Modifiers.breaking.silk-requirement.level", (Object)1);
            this.file.addDefault("Modifiers.breaking.silk-requirement.break-owned", (Object)true);
            this.file.addDefault("Modifiers.breaking.silk-requirement.break-natural", (Object)true);
            this.file.addDefault("Modifiers.breaking.silk-requirement.destroy-on-fail", (Object)true);
            this.file.addDefault("Modifiers.breaking.enable-durability", (Object)false);
            this.file.addDefault("Modifiers.breaking.durability-to-remove", (Object)1);
            int xp = this.first ? 20 : 0;
            this.file.addDefault("Modifiers.breaking.xp-on-failure", (Object)xp);
            this.file.addDefault("Modifiers.breaking.permissions", List.of());
            this.file.addDefault("Modifiers.breaking.show-owner", (Object)false);
            Object o = this.file.get("Modifiers.entity-AI");
            if (o != null) {
                this.file.set("Modifiers.entity-target", o);
                this.file.set("Modifiers.entity-AI", null);
            }
            this.file.addDefault("Modifiers.entity-target", (Object)true);
            this.file.addDefault("Modifiers.entity-movement", (Object)true);
            this.file.addDefault("Modifiers.check-spawner-nerf", (Object)true);
            this.file.addDefault("Modifiers.spawn-babies", (Object)true);
            this.file.addDefault("Modifiers.spawn-with-equipment", (Object)true);
            this.file.addDefault("Modifiers.modify-stacked-entities", (Object)true);
            this.file.addDefault("Modifiers.safety-limit", (Object)128);
            this.file.addDefault("Modifiers.chunk-limits.enabled", (Object)false);
            this.file.addDefault("Modifiers.chunk-limits.spawner-limit", (Object)16);
            this.file.addDefault("Modifiers.chunk-limits.entities-in-chuck", (Object)0);
            this.file.addDefault("Modifiers.players.owned.ignore-limit", (Object)true);
            this.file.addDefault("Modifiers.players.owned.spawner-limit", (Object)16);
            this.file.addDefault("Modifiers.players.owned.can-break", (Object)true);
            this.file.addDefault("Modifiers.players.owned.can-stack", (Object)true);
            this.file.addDefault("Modifiers.players.owned.can-change", (Object)true);
            this.file.addDefault("Modifiers.players.owned.can-open", (Object)true);
            this.file.addDefault("Modifiers.players.owned.can-upgrade", (Object)true);
            this.file.addDefault("Modifiers.players.natural.can-break", (Object)true);
            this.file.addDefault("Modifiers.players.natural.can-stack", (Object)true);
            this.file.addDefault("Modifiers.players.natural.can-change", (Object)true);
            this.file.addDefault("Modifiers.players.natural.can-open", (Object)true);
            this.file.addDefault("Modifiers.players.natural.can-upgrade", (Object)true);
            this.file.addDefault("Modifiers.spawnable.enabled", (Object)false);
            this.file.addDefault("Modifiers.spawnable.entity-amount.DEFAULT", (Object)5000);
            List.of(SpawnerExplodeEvent.ExplosionType.values()).forEach(type -> {
                this.file.addDefault("Miscellaneous.explosions." + type.name() + ".break-spawners", (Object)true);
                this.file.addDefault("Miscellaneous.explosions." + type.name() + ".drop-spawners", (Object)true);
                this.file.addDefault("Miscellaneous.explosions." + type.name() + ".break-natural-spawners", (Object)true);
                this.file.addDefault("Miscellaneous.explosions." + type.name() + ".drop-natural-spawners", (Object)true);
            });
            this.file.addDefault("Spawner-view.enabled", (Object)true);
            this.file.addDefault("Spawner-view.ignore-entities", Stream.of(SpawnerType.ARMOR_STAND, SpawnerType.BOAT, SpawnerType.EXPERIENCE_BOTTLE, SpawnerType.EXPERIENCE_ORB, SpawnerType.MINECART, SpawnerType.MINECART_CHEST, SpawnerType.MINECART_COMMAND, SpawnerType.MINECART_FURNACE, SpawnerType.MINECART_HOPPER, SpawnerType.MINECART_SPAWNER, SpawnerType.MINECART_TNT).map(Enum::name).toList());
            this.file.addDefault("Commands.spawner-view", (Object)"spawnerview");
            this.file.addDefault("Commands.spawner-shop", (Object)"spawnershop");
            this.file.addDefault("Commands.spawner-drops", (Object)"spawnerdrops");
            PriceType type2 = PriceType.EXPERIENCE;
            this.file.addDefault("Prices.upgrades.price-type", (Object)type2.name());
            this.file.addDefault("Prices.upgrades.item.material", (Object)Material.GOLD_INGOT.name());
            this.file.addDefault("Prices.charges.price-type", (Object)type2.name());
            this.file.addDefault("Prices.charges.item.material", (Object)Material.GOLD_INGOT.name());
            this.file.addDefault("Prices.shop.price-type", (Object)type2.name());
            this.file.addDefault("Prices.shop.item.material", (Object)Material.GOLD_INGOT.name());
            this.file.addDefault("Prices.placing.price-type", (Object)type2.name());
            this.file.addDefault("Prices.placing.item.material", (Object)Material.GOLD_INGOT.name());
            this.file.addDefault("Prices.stacking.price-type", (Object)type2.name());
            this.file.addDefault("Prices.stacking.item.material", (Object)Material.GOLD_INGOT.name());
            this.file.addDefault("Prices.breaking.price-type", (Object)type2.name());
            this.file.addDefault("Prices.breaking.item.material", (Object)Material.GOLD_INGOT.name());
            this.file.addDefault("Prices.changing.price-type", (Object)type2.name());
            this.file.addDefault("Prices.changing.item.material", (Object)Material.GOLD_INGOT.name());
            this.file.set("Configuration-version", (Object)2);
            this.file.addDefault("Spawner-version", (Object)0);
            this.file.options().copyDefaults(true);
            this.file.options().header("In this file you can configure all plugin values.\nTo reload this file do /sm update configuration");
            this.file.options().copyHeader(true);
            this.file.set("Modifiers.spawner-item", null);
            if (Configuration.CF.version() < 2) {
                this.copy("Modifiers.breaking.enabled", "Modifiers.breaking.ignore-permission");
            }
            if (this.first) {
                this.save();
                super.initialize();
            }
            if ((c = this.commenter()) != null) {
                c.comment("Spawners.disabled-spawners", "List of disabled spawners.", "Players will not be able to place, break, change", "  interact or do any other modifications", "  to disabled spawners.", "Disabled spawners do not spawn any entities.");
                c.comment("Spawners.values", "Spawner values define spawner upgrade attributes.", "  range - required player distance (in blocks)", "  delay - spawning delay (in ticks) (1 second = 20 ticks)", "  amount - entity amount when spawning");
                c.comment("Spawners.values.DEFAULT", "Default spawner upgrade values.", "For specific entities:", "  <entity>:", "    range: <value>", "    delay: <value>", "    amount: <value>", "Replace <entity> with the specific entity name, any", "  unset upgrade values will use default ones.");
                c.comment("Spawners.value-increase.DEFAULT", "Default spawner upgrade increase values.", "For specific entities:", "  <entity>:", "    range: <value>", "    delay: <value> (should be negative)", "    amount: <value>", "Replace <entity> with the specific entity name, any", "  unset upgrade values will use default ones.");
                c.comment("Spawners.spawning-type", "Spawner spawning type.", "  SINGLE - spawn entities in a single spot.", "  SPREAD - spread entities around spawner.");
                c.comment("Spawners.spawning-radius", "Entity spawning radius.");
                c.comment("Spawners.switching", "Is spawner switching enabled.", "To switch a spawner on or off players must click", "  the stat item in spawner upgrading interface.");
                c.comment("Spawners.empty.enabled", "Are empty spawner enabled.", "An empty spawner can be changed at any time", "  with spawn eggs, when broken they will drop", "  the empty spawner and used spawn eggs.");
                c.comment("Spawners.empty.destroy-eggs.when-removing", "Are eggs destroyed when a player removes them", "  from a filled empty spawner.");
                c.comment("Spawners.empty.destroy-eggs.when-breaking", "Are eggs destroyed when a player breaks", "  a filled empty spawner.");
                c.comment("Spawners.empty.store-eggs-inside", "Are eggs kept inside the empty spawner", "  when broken.");
                c.comment("Spawners.empty.egg-removing-verify", "Enables players to double verify when", "  removing eggs from empty spawners.", "Useful if", "  destroy-eggs:", "    when-removing: true");
                c.comment("Spawners.spawning-particles", "Should there be particles when", "  an entity spawns.");
                c.comment("Spawners.disable-item-spawners", "Are item spawners disabled.");
                c.comment("Spawners.allow-renaming", "If spawners can be renamed in an anvil.");
                c.comment("Spawners.nearby-entity-limit", "If there are this amount of entities", "  in a 4 block radius of the spawner", "  then no entities will be spawned.");
                c.comment("Spawners.kill-entities-on-spawn", "Will entities be killed when they spawn.");
                c.comment("Spawners.drop-xp-when-instant-kill", "Will entities drop xp when killed.", "Only applies when kill-entities-on-spawn", "  is set to true.");
                c.comment("Spawners.default-slime-size", "What size slimes and magma cubes spawners will spawn.", "If the value is 0 then the size will vary (1-3).");
                c.comment("Events.cancel-spawning-event", "Is entity spawning event cancelled.");
                c.comment("Events.send-spawner-event", "Is entity spawning event sent for each new entity.", "This option might be useful for some plugins.");
                c.comment("Events.cancel-break-event", "Is spawner break event cancelled.", "Useful for other plugins that register spawner locations.");
                c.comment("Items.taking-ticks", "Amount of ticks to get back dropped items using", "  /spawnerdrops.", "Only works if drop-on-ground is disabled.");
                c.comment("Items.taking-remind-ticks", "Amount of ticks when a player gets a reminder to", "  collect their spawner items.");
                c.comment("Modifiers.upgrade-interface.enabled", "Is upgrade interface (GUI) enabled.", "If disabled, players will not be able to open it.");
                c.comment("Modifiers.upgrades.upgradeable.DEFAULT", "Default spawner upgradeable upgrades.", "For specific entities:", "  <entity>:", "    range: <true/false>", "    delay: <true/false>", "    amount: <true/false>", "Replace <entity> with the specific entity name, any", "  unset upgrade values will use default ones.");
                c.comment("Modifiers.upgrades.levels.DEFAULT", "Default spawner upgrade levels.", "For specific entities:", "  <entity>:", "    range: <level>", "    delay: <level>", "    amount: <level>", "Replace <entity> with the specific entity name, any", "  unset upgrade values will use default ones.");
                c.comment("Modifiers.upgrades.prices.DEFAULT", "Default spawner upgrade prices.", "For specific entities:", "  <entity>:", "    range: <price>", "    delay: <price>", "    amount: <price>", "Replace <entity> with the specific entity name, any", "  unset upgrade values will use default ones.");
                c.comment("Modifiers.upgrades.price-increase.DEFAULT", "Default spawner upgrade price increases.", "For specific entities:", "  <entity>:", "    range: <increase>", "    delay: <increase>", "    amount: <increase>", "Replace <entity> with the specific entity name, any", "  unset upgrade values will use default ones.");
                c.comment("Modifiers.upgrades.price-increase-type", "Type of price increase.", "ADDITION - added increase to pervious price.", "  [ price + increase * level ]", "MULTIPLICATION - multuplies pervious price by increase.", "  increase value is a percentage (100 = 100%)", "  [ price * increase ^ level ]");
                c.comment("Modifiers.charges.enabled", "Are charges enabled.", "Charges define how many times a spawner can spawn,", "  they are purchased by players in game.");
                c.comment("Modifiers.charges.allow-stacking", "Will spawners with different charge amount be stacked.", "If true, players will be able stack spawners which", "  has different amount of charges.", "For example, if one spawner has 10 charges and the other 8", "  then the stacked spawner will have 9 charges", "  (9 charges for each spawner to keep the balance).", "Player might lose charges if the stack size and charges does", "  not divide equally.");
                c.comment("Modifiers.charges.ignore-natural", "Will natural spawners spawn entities even", "  if it has no charges.");
                c.comment("Modifiers.charges.buy-amount.first", "Amount of charges players can purchase when", "  left-clicking.");
                c.comment("Modifiers.charges.buy-amount.second", "Amount of charges players can purchase when", "  right-clicking.");
                c.comment("Modifiers.charges.prices.DEFAULT", "Default price per charge.", "For specific entities:", "  <entity>: <price>", "Replace <entity> with the specific entity name.");
                c.comment("Modifiers.holograms.enabled", "Are spawner holograms enabled.", "Holograms are rendered over spawners, showing", "  their entity type and stack size.");
                c.comment("Modifiers.holograms.show-natural", "Are holograms rendered on natural spawners.");
                c.comment("Modifiers.changing.enabled", "Is spawner changing enabled.", "To change spawner type a players must shift-right-click", "  onto a spawner with a specific spawn egg.");
                c.comment("Modifiers.changing.use-price", "Does changing cost.");
                c.comment("Modifiers.changing.prices.DEFAULT", "Default changing price.", "For specific entities:", "  <entity>: <price>", "Replace <entity> with the specific entity name.");
                c.comment("Modifiers.placing.enabled", "Is spawner placing enabled.");
                c.comment("Modifiers.placing.use-price", "Does placing cost.");
                c.comment("Modifiers.placing.prices.DEFAULT", "Default placing price.", "For specific entities:", "  <entity>: <price>", "Replace <entity> with the specific entity name.");
                c.comment("Modifiers.stacking.enabled", "Is spawner stacking enabled.", "To stack a spawner players must shift-right-click", "  onto a spawner with the same spawner in their hand.");
                c.comment("Modifiers.stacking.ticks-per", "Ticks between each stacking.");
                c.comment("Modifiers.stacking.use-price", "Does stacking cost.");
                c.comment("Modifiers.stacking.prices.DEFAULT", "Default stacking price.", "For specific entities:", "  <entity>: <price>", "Replace <entity> with the specific entity name.");
                c.comment("Modifiers.stacking.spawner-limit", "Maximum stack size a spawner can have.");
                c.comment("Modifiers.stacking.ignore-limit", "Is stacking limit ignored.");
                c.comment("Modifiers.stacking.when-nearby.enabled", "Player will be able to place same-type", "  spawners near another spawner and", "  it will be stacked to it if this", "  is set to true.");
                c.comment("Modifiers.stacking.when-nearby.radius", "Radius in which the nearest same-type spawner", "  will be searched.", "Radius interval: [1; 16]");
                c.comment("Modifiers.breaking.unbreakable", "Is this spawner unbreakable.", "Players only with permission will", "  be able to break spawners.", "  (spawnermeta.unbreakable.bypass) - this", "  permission is set to false by default.");
                c.comment("Modifiers.breaking.ignore-permission", "Will spawner breaking permission be ignored.", "  (spawnermeta.break)", "Note, this option may be removed in future,", "  instead use 'unbreakable' option.");
                c.comment("Modifiers.breaking.use-price", "Does breaking cost.");
                c.comment("Modifiers.breaking.prices.DEFAULT", "Default breaking price.", "For specific entities:", "  <entity>: <price>", "Replace <entity> with the specific entity name.");
                c.comment("Modifiers.breaking.dropping-chance", "Chance of the spawner to be dropped.");
                c.comment("Modifiers.breaking.chance-changing", "Breaking chance changing.", "Chance changers modifies breaking change for", "  owned, not owned and natural spawners.", "Value must have '+', '-', '*' or '/'", "  in front of a number.", "(E.g. '+20', '-12.5', '*1.5', '/2'...)");
                c.comment("Modifiers.breaking.chance-changing.owned", "How much will the breaking chance change if", "  the player breaks their own spawner.");
                c.comment("Modifiers.breaking.chance-changing.not-owned", "How much will the breaking chance change if", "  the player breaks other player owned spawner.");
                c.comment("Modifiers.breaking.chance-changing.natural", "How much will the breaking chance change if", "  the player breaks a natural spawner.");
                c.comment("Modifiers.breaking.drop-on-ground", "Should the spawner be dropped on the ground", "  or automatically be teleported into player inventory.");
                c.comment("Modifiers.breaking.show-owner", "If set to true then when a player fails", "  to break another player's owned spawner", "  their name will be shown in the chat.");
                c.comment("Modifiers.breaking.permissions", "Permissions with specific dropping chance can be created.", "Permission layout:", "  permissions:", "    <name>: <chance>", "Replace <name> with the specific permission name.", "  [ spawnermeta.breaking.permission.<name> ]");
                c.comment("Modifiers.breaking.silk-requirement.enabled", "Is silk touch enchantment required", "  to break spawners.");
                c.comment("Modifiers.breaking.silk-requirement.level", "Minumum required silk touch enchantment level.");
                c.comment("Modifiers.breaking.silk-requirement.break-owned", "Can player owned spawners be broken with silk touch.");
                c.comment("Modifiers.breaking.silk-requirement.break-natural", "Can natural spawners be broken with silk touch.");
                c.comment("Modifiers.breaking.silk-requirement.destroy-on-fail", "Will the spawner be destroyed if broken", "  with a pickaxe that does not have", "  silk touch enchantment.");
                c.comment("Modifiers.breaking.can-break-natural", "Are natural spawners breakable.");
                c.comment("Modifiers.breaking.enable-durability", "Is durability loss enabled.");
                c.comment("Modifiers.breaking.xp-on-failure", "Amount of xp that is dropped when a player", "  fails to break a spawner.");
                c.comment("Modifiers.breaking.durability-to-remove", "Durability amount that will be removed", "  when a player breaks a spawner.");
                c.comment("Modifiers.entity-target", "Does entities target players.", "Entities will not attack if this is set to false.");
                c.comment("Modifiers.entity-movement", "Does entities have movement.", "Entities will not move around if this is set to false.");
                c.comment("Modifiers.check-spawner-nerf", "Are spawned entities aware.", "If this option is enable then the value", "  is taken from the spigot configuration", "  option: nerf-spawner-mobs.");
                c.comment("Modifiers.spawn-babies", "Are baby entities spawned.", "If false then all entities will be adult age.");
                c.comment("Modifiers.spawn-with-equipment", "Are entities spawned with equipment.", "If false then all entities will not have any items,", "  nor will drop any.");
                c.comment("Modifiers.modify-stacked-entities", "Will already existing entities be modified.", "Entities, such as, WildStacker entities.");
                c.comment("Modifiers.safety-limit", "Limit of how many entities can spawn at one time.", "To prevent any unexpected server lagging and crashing.");
                c.comment("Modifiers.chunk-limits.enabled", "Is spawner limit in chunks enabled.", "When enabled, each world chunk will have a limit", "  of how many spawners it can have.");
                c.comment("Modifiers.chunk-limits.spawner-limit", "Spawner limit in each chunk.");
                c.comment("Modifiers.chunk-limits.entities-in-chuck", "How many entities can be in a chunk,", "  before the spawner stops spawning.", "Leave it 0 to ignore this limit.");
                c.comment("Modifiers.spawner-item", "All lores that are shown on the spawner item.");
                c.comment("Modifiers.players.owned", "Options for player owned spawners.", "When a player placed down a spawner, their ID is", "  saved on the spawner.");
                c.comment("Modifiers.players.owned.ignore-limit", "Is player owner spawner limit enabled.", "If false, each player will only have a specific", "  amount of spawner they can place.");
                c.comment("Modifiers.players.owned.spawner-limit", "Player owned spawner limit.");
                c.comment("Modifiers.players.owned.ignore-limit", "Is owned spawner limit ignored.");
                c.comment("Modifiers.players.owned.can-break", "Can players break other player owned spawners.");
                c.comment("Modifiers.players.owned.can-stack", "Can players stack other player owned spawners.");
                c.comment("Modifiers.players.owned.can-change", "Can players change other player owned spawners.");
                c.comment("Modifiers.players.owned.can-open", "Can players open other player owned spawners.");
                c.comment("Modifiers.players.owned.can-upgrade", "Can players upgrade other player owned spawners.");
                c.comment("Modifiers.players.natural.can-break", "Can players break natural spawners.");
                c.comment("Modifiers.players.natural.can-stack", "Can players stack natural spawners.");
                c.comment("Modifiers.players.natural.can-change", "Can players change natural spawners.");
                c.comment("Modifiers.players.natural.can-open", "Can players open natural spawners.");
                c.comment("Modifiers.players.natural.can-upgrade", "Can players upgrade natural spawners.");
                c.comment("Modifiers.spawnable.enabled", "Is spawnable entity amount enabled.", "If true, each spawner will have an amount of how many", "  entity it can spawn.", "When spawnable entity amount reaches 0 the spawner", "  will be destrayed.");
                c.comment("Modifiers.spawnable.entity-amount.DEFAULT", "Default spawnable entity amount.", "For specific entities:", "  <entity>: <amount>", "Replace <entity> with the specific entity name.");
                c.comment("Miscellaneous.explosions.TNT", "Breaking options for TNT explosions.");
                c.comment("Miscellaneous.explosions.CREEPERS", "Breaking options for creeper explosions.");
                c.comment("Miscellaneous.explosions.FIREBALLS", "Breaking options for fireball explosions.");
                c.comment("Miscellaneous.explosions.END_CRYSTALS", "Breaking options for end crystal explosions.");
                c.comment("Spawner-view.enabled", "Is spawner view enabled.", "Spawner view can be accessed by all players", "  using /spawnerview");
                c.comment("Spawner-view.ignore-entities", "Entities that are excluded from spawner view.");
                c.comment("Commands.spawner-view", "Command label for spawner view.");
                c.comment("Commands.spawner-shop", "Command label for spawner shop.");
                c.comment("Commands.spawner-drops", "Command label for spawner drops.");
                c.comment("Prices", "Price types:", "  EXPERIENCE - experience points", "  LEVELS\t- experience levels", "  ECONOMY - vault economy", "  MATERIAL - items", "Item format (only for MATERIAL price type):", "item:", "  material: <material>", "  name: <name> (checks item name, optional)", "  model: <model> (check item custom model data, optional)");
                c.comment("Prices.upgrades", "Price type for upgrades.");
                c.comment("Prices.charges", "Price type for charges.");
                c.comment("Prices.shop", "Price type for shop.");
                c.comment("Prices.placing", "Price type for placing.");
                c.comment("Prices.stacking", "Price type for stacking.");
                c.comment("Prices.breaking", "Price type for breaking.");
                c.comment("Prices.changing", "Price type for changing.");
                c.comment("Items.layout", "In this section you can change", "  the order of item lore and even", "  delete lines.", "You can delete a line by deleting", "  the line in this file or add '!'", "  after the line.", "  E.g. 'INFO' -> 'INFO!'");
                c.comment("Items.layout.spawner-item", "Keys:", "  HEADER, RANGE, DELAY, AMOUNT", "  CHARGES, SPAWNABLE, INFO");
                c.comment("Items.layout.upgrades.stat-item", "Keys:", "  EMPTY, SWITCHING, LOCATION, STACK", "  WARNING, SPAWNABLE, INFO");
                c.comment("Items.layout.upgrades.upgrade-item", "Keys:", "  HELP, INFO, CURRENT, NEXT, PRICE");
                c.comment("Items.layout.upgrades.disabled-upgrade-item", "Keys:", "  HELP, INFO, CURRENT");
                c.comment("Configuration-version", "Version of this configuration file.", "Should not be changed.");
                c.comment("Spawner-version", "Version of spawners in the server.", "By incrementing this value all spawners in the server", "  will be updated. Can also be done", "  using /sm update spawners.");
            }
            this.save();
            Settings.reload();
        }
    }
}

