/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mc.rellox.spawnermeta.SpawnerMeta;
import mc.rellox.spawnermeta.commands.CommandDrops;
import mc.rellox.spawnermeta.commands.CommandShop;
import mc.rellox.spawnermeta.commands.CommandSpawners;
import mc.rellox.spawnermeta.configuration.Configuration;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.events.EventListeners;
import mc.rellox.spawnermeta.holograms.HologramRegistry;
import mc.rellox.spawnermeta.items.ItemMatcher;
import mc.rellox.spawnermeta.shop.ShopRegistry;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.utils.DataManager;
import mc.rellox.spawnermeta.utils.Messagable;
import mc.rellox.spawnermeta.utils.Reflections;
import mc.rellox.spawnermeta.utils.Utils;
import mc.rellox.spawnermeta.views.SpawnerEditor;
import mc.rellox.spawnermeta.views.SpawnerUpgrade;
import mc.rellox.spawnermeta.views.SpawnerViewLayout;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class CommandManager {
    private static final Command SPAWNERMETA = Bukkit.getPluginCommand((String)"spawnermeta");

    public static void initialize() {
        CommandMap scm;
        String name = Settings.settings.command_view;
        try {
            scm = Reflections.RF.access(Bukkit.getServer(), "commandMap", CommandMap.class).field();
            scm.register(name, (Command)new CommandSpawners(name));
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "SpawnerMeta" + ChatColor.DARK_PURPLE + "] " + ChatColor.DARK_RED + "An error accured while registering spawner view command (" + name + ")! " + "Try changing it, and restart your server!");
            return;
        }
        name = Settings.settings.command_shop;
        try {
            scm = Reflections.RF.access(Bukkit.getServer(), "commandMap", CommandMap.class).field();
            scm.register(name, (Command)new CommandShop(name));
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "SpawnerMeta" + ChatColor.DARK_PURPLE + "] " + ChatColor.DARK_RED + "An error accured while registering spawner shop command (" + name + ")! " + "Try changing it, and restart your server!");
            return;
        }
        name = Settings.settings.command_drops;
        try {
            scm = Reflections.RF.access(Bukkit.getServer(), "commandMap", CommandMap.class).field();
            scm.register(name, (Command)new CommandDrops(name));
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "SpawnerMeta" + ChatColor.DARK_PURPLE + "] " + ChatColor.DARK_RED + "An error accured while registering spawner drops command (" + name + ")! " + "Try changing it, and restart your server!");
            return;
        }
    }

    public static boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (command.equals(SPAWNERMETA)) {
            String help = CommandManager.help(command, null, "update", "give", "edit", "modify", "disable");
            if (args.length < 1) {
                sender.sendMessage(help);
            } else if (args[0].equalsIgnoreCase("update")) {
                String help0 = CommandManager.help(command, "update", "configuration", "language", "shop", "holograms", "spawners");
                if (args.length < 2) {
                    sender.sendMessage(help0);
                } else if (args[1].equalsIgnoreCase("configuration")) {
                    sender.sendMessage(ChatColor.DARK_GREEN + "(!) " + ChatColor.AQUA + "Updating configuration...");
                    if (player != null) {
                        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 2.0f);
                    }
                    SpawnerMeta.ECONOMY.load();
                    Configuration.initialize();
                    EventListeners.update();
                    SpawnerViewLayout.initialize();
                } else if (args[1].equalsIgnoreCase("language")) {
                    sender.sendMessage(ChatColor.DARK_GREEN + "(!) " + ChatColor.AQUA + "Updating language...");
                    if (player != null) {
                        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 2.0f);
                    }
                    Language.initialize();
                } else if (args[1].equalsIgnoreCase("shop")) {
                    sender.sendMessage(ChatColor.DARK_GREEN + "(!) " + ChatColor.AQUA + "Updating shop...");
                    if (player != null) {
                        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 2.0f);
                    }
                    ShopRegistry.initialize();
                } else if (args[1].equalsIgnoreCase("holograms")) {
                    sender.sendMessage(ChatColor.DARK_GREEN + "(!) " + ChatColor.AQUA + "Updating holograms...");
                    if (player != null) {
                        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 2.0f);
                    }
                    HologramRegistry.initialize();
                } else if (args[1].equalsIgnoreCase("spawners")) {
                    sender.sendMessage(ChatColor.DARK_GREEN + "(!) " + ChatColor.AQUA + "Updating spawners...");
                    if (player != null) {
                        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 2.0f);
                    }
                    Settings.settings.update_spawners();
                } else {
                    sender.sendMessage(help0);
                }
            } else if (args[0].equalsIgnoreCase("give")) {
                String help0 = String.valueOf(CommandManager.help(command, "give", "type^")) + CommandManager.extra("amount*") + CommandManager.extra("player?") + CommandManager.extra("values?");
                if (args.length < 2) {
                    sender.sendMessage(help0);
                } else {
                    String a = args[1];
                    SpawnerType type = SpawnerType.of(a);
                    if (type == null) {
                        CommandManager.warn(sender, "Invalid entity type!", new Object[0]);
                    } else {
                        boolean empty;
                        boolean bl = empty = type == SpawnerType.EMPTY;
                        if (Settings.settings.disabled(type)) {
                            CommandManager.warn(sender, "This spawner is disabled!", new Object[0]);
                        } else if (args.length < 3) {
                            if (player != null) {
                                CommandManager.success(sender, "Added #0 to your inventory!", type.formated() + " Spawner");
                                player.getInventory().addItem(new ItemStack[]{DataManager.getSpawners(type, 1, empty, true).get(0)});
                                player.playSound(player.getEyeLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 2.0f);
                            }
                        } else if (!Utils.isInteger(args[2])) {
                            CommandManager.warn(sender, "Invalid amount!", new Object[0]);
                        } else {
                            int amount = Integer.parseInt(args[2]);
                            if (amount < 1) {
                                CommandManager.warn(sender, "Amount must be greater then 0!", new Object[0]);
                            } else if (args.length < 4) {
                                if (player != null) {
                                    new Messagable(player).send(Language.list("Spawners.give.success", "amount", amount, "type", type.formated()));
                                    player.getInventory().addItem(new ItemStack[]{DataManager.getSpawners(type, amount, empty, true).get(0)});
                                }
                            } else {
                                Player getter = Bukkit.getPlayer((String)args[3]);
                                if (getter == null) {
                                    CommandManager.warn(sender, "Player not online!", new Object[0]);
                                } else if (args.length < 5) {
                                    ItemStack item2 = DataManager.getSpawners(type, amount, empty, true).get(0);
                                    ItemMatcher.add(getter, item2);
                                } else {
                                    String values = "";
                                    int i = 4;
                                    while (i < args.length) {
                                        values = String.valueOf(values) + args[i];
                                        ++i;
                                    }
                                    List<ItemStack> items = DataManager.getSpawner(type, values, amount, empty);
                                    if (items.isEmpty()) {
                                        CommandManager.warn(sender, "Unable to read values!", new Object[0]);
                                    } else {
                                        items.forEach(item -> ItemMatcher.add(getter, item));
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (args[0].equalsIgnoreCase("edit")) {
                String help0 = CommandManager.help(command, "update", "edit", "open", "reset");
                if (args.length < 2) {
                    sender.sendMessage(help0);
                } else if (args[1].equalsIgnoreCase("open") && player != null) {
                    SpawnerEditor.open(player);
                } else if (args[1].equalsIgnoreCase("reset")) {
                    SpawnerViewLayout.resetLayout();
                    if (player != null) {
                        player.playSound(player.getEyeLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 0.5f, 2.0f);
                    }
                    CommandManager.success(sender, "Reseting Spawner GUI Layout!", new Object[0]);
                } else {
                    sender.sendMessage(help0);
                }
            } else if (args[0].equalsIgnoreCase("modify")) {
                String help0 = CommandManager.help(command, "modify", "type", "stack", "entities", "charges");
                if (args.length < 2) {
                    sender.sendMessage(help0);
                } else if (args[1].equalsIgnoreCase("type")) {
                    String help1 = CommandManager.help(command, "modify type", "type^");
                    if (args.length < 3) {
                        sender.sendMessage(help1);
                    } else {
                        String a = args[2].toUpperCase();
                        SpawnerType type = SpawnerType.of(a);
                        if (type == null) {
                            CommandManager.warn(sender, "Invalid type!", new Object[0]);
                        } else {
                            Block block = player.getTargetBlock(null, 10);
                            if (block == null) {
                                CommandManager.warn(sender, "Target spawner not found!", new Object[0]);
                            } else if (block.getType() != Material.SPAWNER) {
                                CommandManager.warn(sender, "Target spawner is not a spawner!", new Object[0]);
                            } else {
                                DataManager.setType(block, type);
                                SpawnerUpgrade.update(block);
                                CommandManager.success(sender, "Spawner type set to #0!", type.formated());
                            }
                        }
                    }
                } else if (args[1].equalsIgnoreCase("stack")) {
                    String help1 = CommandManager.help(command, "modify stack", "(+/-) value*");
                    if (args.length < 3) {
                        sender.sendMessage(help1);
                    } else {
                        String a = args[2];
                        if (!Utils.isInteger(a)) {
                            CommandManager.warn(sender, "Invalid value!", new Object[0]);
                        } else {
                            int s = Integer.parseInt(a);
                            Block block = player.getTargetBlock(null, 10);
                            if (block == null) {
                                CommandManager.warn(sender, "Target spawner not found!", new Object[0]);
                            } else if (block.getType() != Material.SPAWNER) {
                                CommandManager.warn(sender, "Target spawner is not a spawner!", new Object[0]);
                            } else {
                                if (a.charAt(0) == '+' || a.charAt(0) == '-') {
                                    s += DataManager.getStack(block);
                                }
                                DataManager.setStack(block, s < 1 ? 1 : s);
                                SpawnerUpgrade.update(block);
                                CommandManager.success(sender, "Spawner stack size set to #0!", s);
                            }
                        }
                    }
                } else if (args[1].equalsIgnoreCase("entities")) {
                    String help1 = CommandManager.help(command, "modify entities", "(+/-) value*");
                    if (args.length < 3) {
                        sender.sendMessage(help1);
                    } else {
                        String a = args[2];
                        boolean inf = a.equalsIgnoreCase("infinite");
                        if (!Utils.isInteger(a) && !inf) {
                            CommandManager.warn(sender, "Invalid value!", new Object[0]);
                        } else {
                            int s = inf ? 1500000000 : Integer.parseInt(a);
                            Block block = player.getTargetBlock(null, 10);
                            if (block == null) {
                                CommandManager.warn(sender, "Target spawner not found!", new Object[0]);
                            } else if (block.getType() != Material.SPAWNER) {
                                CommandManager.warn(sender, "Target spawner is not a spawner!", new Object[0]);
                            } else {
                                if (a.charAt(0) == '+' || a.charAt(0) == '-') {
                                    s += DataManager.getSpawnable(block);
                                }
                                DataManager.setSpawnable(block, s < 1 ? 1 : s);
                                SpawnerUpgrade.update(block);
                                CommandManager.success(sender, "Spawner spawnable entity set to #0!", inf ? "infinite" : Integer.valueOf(s));
                            }
                        }
                    }
                } else if (args[1].equalsIgnoreCase("charges")) {
                    String help1 = CommandManager.help(command, "modify charges", "(+/-) value*");
                    if (args.length < 3) {
                        sender.sendMessage(help1);
                    } else {
                        String a = args[2];
                        boolean inf = a.equalsIgnoreCase("infinite");
                        if (!Utils.isInteger(a) && !inf) {
                            CommandManager.warn(sender, "Invalid value!", new Object[0]);
                        } else {
                            int s = inf ? 1500000000 : Integer.parseInt(a);
                            Block block = player.getTargetBlock(null, 10);
                            if (block == null) {
                                CommandManager.warn(sender, "Target spawner not found!", new Object[0]);
                            } else if (block.getType() != Material.SPAWNER) {
                                CommandManager.warn(sender, "Target spawner is not a spawner!", new Object[0]);
                            } else {
                                if (a.charAt(0) == '+' || a.charAt(0) == '-') {
                                    s += DataManager.getCharges(block);
                                }
                                DataManager.setCharges(block, s);
                                SpawnerUpgrade.update(block);
                                CommandManager.success(sender, "Spawner charges set to #0!", inf ? "infinite" : Integer.valueOf(s));
                            }
                        }
                    }
                } else {
                    sender.sendMessage(help0);
                }
            } else if (args[0].equalsIgnoreCase("disable")) {
                String help1 = CommandManager.help(command, "disable", "true", "false");
                if (args.length < 2) {
                    sender.sendMessage(help1);
                } else if (!args[1].equalsIgnoreCase("true") && !args[1].equalsIgnoreCase("false")) {
                    sender.sendMessage(help1);
                } else {
                    Settings.settings.disable_spawning = Boolean.parseBoolean(args[1]);
                    CommandManager.success(sender, "Spawner spawning #0!", Settings.settings.disable_spawning ? "disabled" : "enabled");
                }
            } else {
                sender.sendMessage(help);
            }
        }
        return false;
    }

    private static String help(Command command, String arg, String ... ss) {
        String help = ChatColor.LIGHT_PURPLE + "Usage: " + ChatColor.AQUA + "/" + command.getLabel();
        if (arg != null) {
            help = String.valueOf(help) + " " + arg;
        }
        String a = ChatColor.DARK_AQUA + " [";
        int i = 0;
        int l = ss.length - 1;
        while (i < ss.length) {
            a = String.valueOf(a) + ChatColor.DARK_PURPLE + ss[i];
            if (i < l) {
                a = String.valueOf(a) + ChatColor.AQUA + "/";
            }
            ++i;
        }
        return String.valueOf(help) + a + ChatColor.DARK_AQUA + "]";
    }

    private static String extra(String ... ss) {
        String a = ChatColor.DARK_AQUA + " [";
        int i = 0;
        int l = ss.length - 1;
        while (i < ss.length) {
            a = String.valueOf(a) + ChatColor.DARK_PURPLE + ss[i];
            if (i < l) {
                a = String.valueOf(a) + ChatColor.AQUA + "/";
            }
            ++i;
        }
        return String.valueOf(a) + ChatColor.DARK_AQUA + "]";
    }

    private static void warn(CommandSender sender, String warning, Object ... os) {
        String w = ChatColor.DARK_RED + "(!) " + ChatColor.GOLD + warning;
        if (os != null) {
            int i = 0;
            while (i < os.length) {
                w = w.replace("#" + i, ChatColor.YELLOW + os[i].toString() + ChatColor.GOLD);
                ++i;
            }
        }
        sender.sendMessage(w);
    }

    public static void success(CommandSender sender, String success, Object ... os) {
        String w = ChatColor.DARK_GREEN + "(!) " + ChatColor.DARK_AQUA + success;
        if (os != null) {
            int i = 0;
            while (i < os.length) {
                w = w.replace("#" + i, ChatColor.AQUA + os[i].toString() + ChatColor.DARK_AQUA);
                ++i;
            }
        }
        sender.sendMessage(w);
    }

    public static List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> l = new ArrayList<String>();
        if (command.equals(SPAWNERMETA)) {
            if (args.length < 1) {
                return null;
            }
            if (args.length < 2) {
                return CommandManager.sm(args[0]);
            }
            if (args[0].equalsIgnoreCase("update")) {
                if (args.length < 3) {
                    return CommandManager.up(args[1]);
                }
                return l;
            }
            if (args[0].equalsIgnoreCase("give")) {
                if (args.length < 3) {
                    return CommandManager.entities(args[1]);
                }
                if (args.length < 4) {
                    return l;
                }
                if (Utils.isInteger(args[2])) {
                    if (args.length < 5) {
                        return CommandManager.pl(args[3]);
                    }
                    return l;
                }
                return l;
            }
            if (args[0].equalsIgnoreCase("edit")) {
                if (args.length < 3) {
                    return CommandManager.or(args[1]);
                }
                return l;
            }
            if (args[0].equalsIgnoreCase("modify")) {
                if (args.length < 3) {
                    return CommandManager.mo(args[1]);
                }
                if (args[1].equalsIgnoreCase("type")) {
                    if (args.length < 4) {
                        return CommandManager.entities(args[2]);
                    }
                    return l;
                }
                if (args[1].equalsIgnoreCase("charges") || args[1].equalsIgnoreCase("entities")) {
                    if (args.length < 4) {
                        return CommandManager.inf(args[2]);
                    }
                    return l;
                }
                return l;
            }
            if (args[0].equalsIgnoreCase("disable")) {
                if (args.length < 3) {
                    return CommandManager.tf(args[1]);
                }
                return l;
            }
            return l;
        }
        return null;
    }

    private static List<String> sm(String s) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("update");
        l.add("give");
        l.add("edit");
        l.add("modify");
        l.add("disable");
        return CommandManager.reduce(l, s);
    }

    private static List<String> pl(String s) {
        return CommandManager.reduce(Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toList()), s);
    }

    private static List<String> or(String s) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("open");
        l.add("reset");
        return CommandManager.reduce(l, s);
    }

    private static List<String> tf(String s) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("true");
        l.add("false");
        return CommandManager.reduce(l, s);
    }

    private static List<String> mo(String s) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("type");
        l.add("stack");
        l.add("entities");
        l.add("charges");
        return CommandManager.reduce(l, s);
    }

    private static List<String> up(String s) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("configuration");
        l.add("language");
        l.add("shop");
        l.add("spawners");
        l.add("holograms");
        return CommandManager.reduce(l, s);
    }

    private static List<String> inf(String s) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("infinite");
        return CommandManager.reduce(l, s);
    }

    private static List<String> entities(String s) {
        return CommandManager.reduce(Stream.of(SpawnerType.values()).filter(SpawnerType::exists).map(Enum::name).collect(Collectors.toList()), s);
    }

    private static List<String> reduce(List<String> l, String s) {
        if (s.isEmpty()) {
            return l;
        }
        return l.stream().filter(a -> a.toLowerCase().contains(s.toLowerCase())).collect(Collectors.toList());
    }
}

