/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.api.spawner;

import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.utils.DataManager;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public interface VirtualSpawner {
    public static VirtualSpawner of(ItemStack item) {
        return DataManager.getSpawnerItem(item);
    }

    public static VirtualSpawner of(Block block) {
        return DataManager.getSpawnerItem(block);
    }

    public boolean exact(VirtualSpawner var1);

    public SpawnerType getType();

    public int[] getUpgradeLevels();

    public int getCharges();

    public int getSpawnable();

    public boolean isEmpty();

    public ItemStack getItem(int var1);

    default public ItemStack getItem() {
        return this.getItem(1);
    }

    default public void place(Block block) {
        this.place(null, block);
    }

    default public void place(Player owner, Block block) {
        block.setType(Material.SPAWNER);
        DataManager.setNewSpawner(owner, block, this.getType(), this.getUpgradeLevels(), this.getCharges(), this.getSpawnable(), this.isEmpty());
    }
}

