/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.api.spawner;

import java.util.List;
import java.util.UUID;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.spawner.UpgradeType;
import mc.rellox.spawnermeta.utils.DataManager;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@FunctionalInterface
public interface Spawner {
    public static Spawner of(Block block) {
        return () -> block;
    }

    public Block block();

    default public boolean isEmpty() {
        return DataManager.isEmpty(this.block());
    }

    default public void setEmpty() {
        DataManager.setEmpty(this.block());
    }

    default public boolean isEnabled() {
        return DataManager.isEnabled(this.block());
    }

    default public void setEnabled(boolean b) {
        DataManager.setEnabled(this.block(), b);
    }

    default public boolean isRotating() {
        return DataManager.isRotating(this.block());
    }

    default public void setRotating(boolean b) {
        DataManager.setRotating(this.block(), b);
    }

    default public SpawnerType getType() {
        return DataManager.getType(this.block());
    }

    default public void setType(SpawnerType type) {
        DataManager.setType(this.block(), type);
    }

    @Deprecated(forRemoval=true)
    default public int getStackSize() {
        return DataManager.getStack(this.block());
    }

    default public int getStack() {
        return DataManager.getStack(this.block());
    }

    @Deprecated(forRemoval=true)
    default public void setStackSize(int s) {
        DataManager.setStack(this.block(), s);
    }

    default public void setStack(int s) {
        DataManager.setStack(this.block(), s);
    }

    @Deprecated(forRemoval=true)
    default public int getSpawnableSize() {
        return DataManager.getSpawnable(this.block());
    }

    default public int getSpawnable() {
        return DataManager.getSpawnable(this.block());
    }

    @Deprecated(forRemoval=true)
    default public void setSpawnableSize(int s) {
        DataManager.setSpawnable(this.block(), s);
    }

    default public void setSpawnable(int s) {
        DataManager.setSpawnable(this.block(), s);
    }

    default public boolean isNatural() {
        return !this.isOwned();
    }

    default public boolean isOwned() {
        return DataManager.isPlaced(this.block());
    }

    default public Player getOwner() {
        UUID id = DataManager.getOwner(this.block());
        return id == null ? null : Bukkit.getPlayer((UUID)id);
    }

    default public UUID getOwnerID() {
        return DataManager.getOwner(this.block());
    }

    default public boolean isOwner(Player player) {
        return this.isOwner(player, false);
    }

    default public boolean isOwner(Player player, boolean def) {
        UUID id = DataManager.getOwner(this.block());
        return id == null ? def : id.equals(player.getUniqueId());
    }

    default public void setOwner(Player player) {
        DataManager.setOwner(this.block(), player);
    }

    default public int[] getUpgradeLevels() {
        return DataManager.getUpgradeLevels(this.block());
    }

    default public int getUpgradeLevel(UpgradeType type) {
        return DataManager.getUpgradeLevels(this.block())[type.ordinal()];
    }

    default public void setUpgradeLevels(int[] as) {
        DataManager.setUpgradeLevels(this.block(), as);
    }

    default public int[] getUpgradeAttributes() {
        return DataManager.getUpgradeAttributes(this.block());
    }

    default public int getUpgradeAttribute(UpgradeType type) {
        return DataManager.getUpgradeAttributes(this.block())[type.ordinal()];
    }

    default public void setUpgradeAttributes(int[] as) {
        DataManager.setUpgradeAttributes(this.block(), as);
    }

    default public int getCharges() {
        return DataManager.getCharges(this.block());
    }

    default public void setCharges(int a) {
        DataManager.setCharges(this.block(), a);
    }

    default public void update() {
        DataManager.updateValues(this.block());
    }

    default public List<ItemStack> toItems() {
        return DataManager.getSpawners(this.block(), false);
    }
}

