/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta.api.spawner;

import java.util.Arrays;
import mc.rellox.spawnermeta.api.spawner.VirtualSpawner;
import mc.rellox.spawnermeta.configuration.Settings;
import mc.rellox.spawnermeta.spawner.SpawnerType;
import mc.rellox.spawnermeta.utils.DataManager;
import org.bukkit.inventory.ItemStack;

public class FilledVirtualSpawner
implements VirtualSpawner {
    private final SpawnerType type;
    private final int[] levels;
    private final int charges;
    private final int spawnable;
    private final boolean empty;

    public FilledVirtualSpawner(SpawnerType type, int[] levels, int charges, int spawnable, boolean empty) {
        int[] nArray;
        this.type = type;
        if (levels == null || levels.length != 3) {
            int[] nArray2 = new int[3];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 1;
        } else {
            nArray = levels;
        }
        this.levels = nArray;
        this.charges = charges;
        this.spawnable = spawnable;
        this.empty = empty;
    }

    @Override
    public boolean exact(VirtualSpawner other) {
        if (this.type != other.getType()) {
            return false;
        }
        if (this.empty != other.isEmpty()) {
            return false;
        }
        if (Settings.settings.charges_enabled && !Settings.settings.charges_allow_stacking && this.charges != other.getCharges()) {
            return false;
        }
        return Arrays.equals(this.levels, other.getUpgradeLevels());
    }

    @Override
    public SpawnerType getType() {
        return this.type;
    }

    @Override
    public int[] getUpgradeLevels() {
        return this.levels;
    }

    @Override
    public int getCharges() {
        return this.charges;
    }

    @Override
    public int getSpawnable() {
        return this.spawnable;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public ItemStack getItem(int a) {
        return DataManager.getSpawner(this, a);
    }
}

