/*
 * Decompiled with CFR 0.152.
 */
package mc.rellox.spawnermeta;

import java.util.List;
import mc.rellox.spawnermeta.api.APIInstance;
import mc.rellox.spawnermeta.api.APIRegistry;
import mc.rellox.spawnermeta.commands.CommandManager;
import mc.rellox.spawnermeta.configuration.Configuration;
import mc.rellox.spawnermeta.configuration.Language;
import mc.rellox.spawnermeta.configuration.LocationFile;
import mc.rellox.spawnermeta.events.EventListeners;
import mc.rellox.spawnermeta.holograms.HologramRegistry;
import mc.rellox.spawnermeta.hook.HookEconomy;
import mc.rellox.spawnermeta.hook.HookShopGUI;
import mc.rellox.spawnermeta.hook.HookWildStacker;
import mc.rellox.spawnermeta.hook.HookWildTools;
import mc.rellox.spawnermeta.shop.ShopRegistry;
import mc.rellox.spawnermeta.utils.DataManager;
import mc.rellox.spawnermeta.utils.Metrics;
import mc.rellox.spawnermeta.utils.Utils;
import mc.rellox.spawnermeta.utils.Version;
import mc.rellox.spawnermeta.views.SpawnerViewLayout;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SpawnerMeta
extends JavaPlugin {
    public static final double PLUGIN_VERSION = 20.0;
    private static SpawnerMeta plugin;
    public static final HookEconomy ECONOMY;
    public static final HookWildStacker WILD_STACKER;
    public static final HookWildTools WILD_TOOLS;
    public static final HookShopGUI SHOP_GUI;
    private static boolean loaded;
    private APIInstance api;

    static {
        ECONOMY = new HookEconomy();
        WILD_STACKER = new HookWildStacker();
        WILD_TOOLS = new HookWildTools();
        SHOP_GUI = new HookShopGUI();
    }

    public void onLoad() {
        loaded = Version.version != null;
        plugin = this;
    }

    public void onEnable() {
        if (loaded) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "Spawner Meta " + ChatColor.AQUA + "v" + 20.0 + ChatColor.DARK_PURPLE + "]" + ChatColor.GREEN + " enabled!");
            Utils.check(74188, s -> {
                if (!Utils.isDouble(s)) {
                    return;
                }
                double v = Double.parseDouble(s);
                if (v > 20.0) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "Spawner Meta " + ChatColor.AQUA + "v" + 20.0 + ChatColor.DARK_PURPLE + "] " + ChatColor.YELLOW + "New version is available: v" + v + "! " + ChatColor.GOLD + "To download visit: " + "https://www.spigotmc.org/resources/spawnermeta.74188/");
                }
            });
            ECONOMY.load();
            if (ECONOMY.exists()) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "SpawnerMeta" + ChatColor.DARK_PURPLE + "] " + ChatColor.GRAY + "Vault has been found, economy enabled!");
            }
            WILD_STACKER.load();
            if (WILD_STACKER.exists()) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "SpawnerMeta" + ChatColor.DARK_PURPLE + "] " + ChatColor.GRAY + "Wild Stacker has been found, entity stacking enabled!");
            }
            WILD_TOOLS.load();
            if (WILD_TOOLS.exists()) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "SpawnerMeta" + ChatColor.DARK_PURPLE + "] " + ChatColor.GRAY + "Wild Tools has been found, custom drop provided!");
            }
            SHOP_GUI.load();
            if (SHOP_GUI.exists()) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "SpawnerMeta" + ChatColor.DARK_PURPLE + "] " + ChatColor.GRAY + "ShopGUI+ has been found, custom spawners provided!");
            }
            this.initializeMetrics();
            Configuration.initialize();
            Language.initialize();
            CommandManager.initialize();
            DataManager.initialize();
            SpawnerViewLayout.initialize();
            ShopRegistry.initialize();
            HologramRegistry.initialize();
            EventListeners.initialize();
            LocationFile.initialize();
            this.api = new APIRegistry();
        } else {
            Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "Spawner Meta " + ChatColor.AQUA + "v" + 20.0 + ChatColor.DARK_PURPLE + "]" + ChatColor.DARK_RED + " failed to load, invalid server version!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public static SpawnerMeta instance() {
        return plugin;
    }

    public APIInstance getAPI() {
        return this.api;
    }

    public void onDisable() {
        if (loaded) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_PURPLE + "[" + ChatColor.LIGHT_PURPLE + "Spawner Meta " + ChatColor.AQUA + "v" + 20.0 + ChatColor.DARK_PURPLE + "]" + ChatColor.RED + " disabled!");
            HologramRegistry.erase();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return CommandManager.onCommand(sender, command, label, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return CommandManager.onTabComplete(sender, command, alias, args);
    }

    private void initializeMetrics() {
        new Metrics((Plugin)plugin, 8373);
    }
}

